/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionData;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionExpressionData;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class BGSActionExpressionPanel
extends BGUPanel {
    private boolean initActionsPanel = false;
    private ActionTree actionTree = new ActionTree();
    private BGUComboBox<KeyValue> components = new BGUComboBox();
    private ActionExpressionDataTableModel tableModel = new ActionExpressionDataTableModel();

    @Override
    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, this.getActionTreePanel(), (Component)this.getActionTablePanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getActionTreePanel() {
        this.actionTree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.actionTree.addTreeSelectionListener(e -> this.performAction("loadExtensionDataList"));
        this.components.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.performAction("onComponentChage");
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        panel.add(this.components, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 3, 3, 3), 0, 0));
        panel.add((Component)new JLabel("\u0411\u0430\u0437\u043e\u0432\u044b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 8, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.actionTree), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getActionTablePanel() {
        BGUTable table = new BGUTable(this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit(table, this);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
        return panel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (!this.initActionsPanel) {
                Async.of(() -> {
                    ModuleService moduleService = ((ClientContext)this.getContext()).getWebService(ModuleService.class, 0);
                    ArrayList<KeyValue> componentItems = new ArrayList<KeyValue>();
                    componentItems.add(new KeyValue("kernel", "\u042f\u0434\u0440\u043e"));
                    moduleService.installedModuleList().forEach(a -> componentItems.add(new KeyValue(a.getName(), a.getTitle() + " [" + a.getType() + "]")));
                    moduleService.installedPluginList().forEach(a -> componentItems.add(new KeyValue(a.getName(), a.getTitle() + " [" + a.getType() + "]")));
                    this.components.setData(componentItems);
                    this.performAction("onComponentChage");
                    this.initActionsPanel = true;
                });
            }
        });
        new AbstractBGUPanel.BGActionNew(e -> {
            TreePath treePath = this.actionTree.getSelectionPath();
            if (treePath == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0431\u0430\u0437\u043e\u0432\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435");
                return;
            }
            ActionData actionData = (ActionData)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            if (actionData.getServiceId() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0431\u0430\u0437\u043e\u0432\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435");
                return;
            }
            ActionExpressionData actionExpressionData = new ActionExpressionData();
            actionExpressionData.setTitle(actionData.getTitle() + " + \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
            actionExpressionData.setComponentId(((KeyValue)this.components.getSelectedItem()).getKey());
            actionExpressionData.setServiceId(actionData.getServiceId());
            actionExpressionData.setServiceName(actionData.getServiceName());
            actionExpressionData.setServiceOperation(actionData.getServiceOperation());
            new ActionExpressionDataEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", actionExpressionData).open();
        });
        new AbstractBGUPanel.BGActionEdit(e -> this.showEditDialog(this.tableModel, ActionExpressionDataEditor.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u043e\u0433\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f"));
        new AbstractBGUPanel.BGActionDelete(e -> {
            ActionExpressionData expressionData = (ActionExpressionData)this.tableModel.getSelectedRow();
            if (expressionData == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete(expressionData)) {
                ((ClientContext)this.getContext()).getWebService(RoleService.class, 0).actionExpressionDataDelete(expressionData.getId());
                this.performAction("loadExtensionDataList");
            }
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("onComponentChage", "", e -> {
            KeyValue component = (KeyValue)this.components.getSelectedItem();
            ActionData actionData = ((ClientContext)this.getContext()).getWebService(RoleService.class, 0).actionDataRoot(component.getKey());
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(actionData);
            this.buildTree(rootNode);
            this.actionTree.setModel(new DefaultTreeModel(rootNode));
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("loadExtensionDataList", "", e -> {
            DefaultMutableTreeNode treeNode;
            Object patt8374$temp;
            List<Object> data = new ArrayList();
            TreePath treePath = this.actionTree.getSelectionPath();
            if (treePath != null && (patt8374$temp = (treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof ActionData) {
                ActionData actionData = (ActionData)patt8374$temp;
                if (actionData.getServiceId() > 0) {
                    data = ((ClientContext)this.getContext()).getWebService(RoleService.class, 0).actionExpressionDataList(((KeyValue)this.components.getSelectedItem()).getKey(), Arrays.asList(actionData.getServiceId()));
                } else {
                    ArrayList<Integer> serviceIds = new ArrayList<Integer>();
                    this.buildServiceIds(actionData, serviceIds);
                    data = ((ClientContext)this.getContext()).getWebService(RoleService.class, 0).actionExpressionDataList(((KeyValue)this.components.getSelectedItem()).getKey(), serviceIds);
                }
            }
            this.tableModel.setData(data);
        });
    }

    private void buildServiceIds(ActionData actionData, List<Integer> serviceIds) {
        serviceIds.add(actionData.getServiceId());
        Optional.ofNullable(actionData.getChildren()).ifPresent(b -> b.forEach(a -> this.buildServiceIds((ActionData)a, serviceIds)));
    }

    private void buildTree(DefaultMutableTreeNode parentNode) {
        ActionData parentActionData = (ActionData)parentNode.getUserObject();
        List<ActionData> actionDatas = parentActionData.getChildren();
        if (actionDatas != null) {
            for (ActionData actionData : actionDatas) {
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(actionData);
                parentNode.add(treeNode);
                this.buildTree(treeNode);
            }
        }
    }

    class ActionTree
    extends JTree {
        public ActionTree() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.setRootVisible(true);
            this.setShowsRootHandles(true);
            this.getSelectionModel().setSelectionMode(1);
            this.setCellRenderer(new ActionTreeCellRenderer());
        }
    }

    class ActionExpressionDataTableModel
    extends BGTableModel<ActionExpressionData> {
        public ActionExpressionDataTableModel() {
            super(ActionExpressionDataTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 300, 400, 800, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u0441\u043b\u043e\u0432\u043d\u0438\u0435", 200, 300, -1, "serviceExpression", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class ActionExpressionDataEditor
    extends BGEditorDialog<ActionExpressionData> {
        private Font font;
        private Color bgColor;
        private BGTextField title;
        private BGTextField componentName;
        private BGTextField serviceId;
        private BGTextField serviceName;
        private BGTextField serviceOperation;
        private BGTextField serviceExpression;

        public ActionExpressionDataEditor(String title, ActionExpressionData data) {
            super(title, data);
            this.title = new BGTextField(50);
            this.componentName = new BGTextField(30);
            this.serviceId = new BGTextField(10);
            this.serviceName = new BGTextField(50);
            this.serviceOperation = new BGTextField(50);
            this.serviceExpression = new BGTextField(50);
            BGTextField bgTextField = new BGTextField();
            this.bgColor = bgTextField.getBackground();
            this.font = bgTextField.getFont();
            this.font = this.font.deriveFont(1).deriveFont(this.font.getSize2D() * 1.2f);
        }

        @Override
        public void doDialogPanel() {
            this.title.setHorizontalAlignment(0);
            this.serviceExpression.setHorizontalAlignment(0);
            this.serviceName.setHorizontalAlignment(0);
            this.serviceName.setEditable(false);
            this.serviceName.setBackground(this.bgColor);
            this.serviceName.setFont(this.font);
            this.serviceOperation.setHorizontalAlignment(0);
            this.serviceOperation.setEditable(false);
            this.serviceOperation.setBackground(this.bgColor);
            this.serviceOperation.setFont(this.font);
            this.panel.add((Component)this.getComponentActionIdPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0421\u0435\u0440\u0432\u0438\u0441:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.serviceName, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.serviceOperation, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0423\u0441\u043b\u043e\u0432\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.serviceExpression, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            if (((ActionExpressionData)this.data).getId() > 0) {
                try {
                    this.data = ((ClientContext)BGSActionExpressionPanel.this.getContext()).getWebService(RoleService.class, 0).actionExpressionDataGet(((ActionExpressionData)this.data).getId());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            this.title.setText(((ActionExpressionData)this.data).getTitle());
            this.componentName.setText(((ActionExpressionData)this.data).getComponentId());
            this.serviceId.setText(String.valueOf(((ActionExpressionData)this.data).getServiceId()));
            this.serviceName.setText(((ActionExpressionData)this.data).getServiceName());
            this.serviceOperation.setText(((ActionExpressionData)this.data).getServiceOperation());
            this.serviceExpression.setText(((ActionExpressionData)this.data).getServiceExpression());
        }

        @Override
        public boolean doApply() throws Exception {
            if (Utils.isEmptyString(this.title.getText())) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            if (Utils.isEmptyString(this.serviceExpression.getText())) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
                return false;
            }
            ((ActionExpressionData)this.data).setTitle(this.title.getText());
            ((ActionExpressionData)this.data).setServiceExpression(this.serviceExpression.getText());
            try {
                ((ClientContext)BGSActionExpressionPanel.this.getContext()).getWebService(RoleService.class, 0).actionExpressionDataUpdate((ActionExpressionData)this.data);
                BGSActionExpressionPanel.this.performAction("loadExtensionDataList");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
                return false;
            }
            return true;
        }

        private JPanel getComponentActionIdPanel() {
            this.componentName.setHorizontalAlignment(0);
            this.componentName.setEditable(false);
            this.componentName.setBackground(this.bgColor);
            this.componentName.setFont(this.font);
            this.serviceId.setHorizontalAlignment(0);
            this.serviceId.setEditable(false);
            this.serviceId.setBackground(this.bgColor);
            this.serviceId.setFont(this.font);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.componentName, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("ID#:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
            panel.add((Component)this.serviceId, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }
    }

    class ActionTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ActionTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof ActionData) {
                ActionData actionData = (ActionData)userObject;
                this.setText(actionData.getTitle() + (String)(actionData.getServiceId() > 0 ? " [ID#" + actionData.getServiceId() + "]" : ""));
            }
            return component;
        }
    }
}

