/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.publish.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.event.publish.client.DirectoryPanel;
import ru.bitel.bgbilling.kernel.event.publish.client.MQServerListCellRenderer;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQServer;
import ru.bitel.bgbilling.kernel.event.publish.common.service.MQServerService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class MQServerPanel
extends DirectoryPanel {
    private MQServer mqServer = null;
    private JPanel serverEditPanel = null;
    private MQServerService mqServerService = null;
    private Map<String, JTextField> fields = new HashMap<String, JTextField>();
    private DefaultListModel<MQServer> serverListModel = new DefaultListModel();
    private JList<MQServer> serverList = new JList<MQServer>(this.serverListModel);
    private final String[][] serversFieldKey = new String[][]{{"title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"}, {"url", "\u0410\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (URL)"}, {"userName", "\u041b\u043e\u0433\u0438\u043d"}, {"userPassword", "\u041f\u0430\u0440\u043e\u043b\u044c"}};

    @Override
    protected void jbInit() throws Exception {
        this.serverList.setCellRenderer(new MQServerListCellRenderer());
        this.serverList.setSelectionMode(0);
        this.serverList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MQServerPanel.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("\u0421\u0435\u0440\u0432\u0435\u0440\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)new JScrollPane(this.serverList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.getServerEditPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private MQServerService getMQServerService() {
        if (this.mqServerService == null) {
            this.mqServerService = ((ClientContext)this.getContext()).getPort(MQServerService.class);
        }
        return this.mqServerService;
    }

    private JPanel getServerEditPanel() {
        if (this.serverEditPanel == null) {
            BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
            okCancelPanel.addActionListener(actionEvent -> {
                this.stopEditMQServer(actionEvent.getActionCommand().equals("ok"));
                this.serverEditPanel.setVisible(false);
            });
            this.serverEditPanel = new JPanel(new GridBagLayout());
            this.serverEditPanel.setBorder(new TitledBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 MQ \u0441\u0435\u0440\u0432\u0435\u0440\u0430"));
            this.serverEditPanel.setVisible(false);
            int gridy = 0;
            this.fields.clear();
            for (String[] field : this.serversFieldKey) {
                this.fields.put(field[0], new JTextField());
                this.serverEditPanel.add((Component)new JLabel(field[1]), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
                this.serverEditPanel.add((Component)this.fields.get(field[0]), new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            }
            this.serverEditPanel.add((Component)okCancelPanel, new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 5, 0), 0, 0));
        }
        return this.serverEditPanel;
    }

    private void editMQServer() {
        this.serverList.setEnabled(false);
        this.serverEditPanel.setVisible(true);
        block12: for (String[] field : this.serversFieldKey) {
            JTextField textField = this.fields.get(field[0]);
            switch (field[0]) {
                case "title": {
                    textField.setText(this.mqServer.getTitle());
                    continue block12;
                }
                case "url": {
                    textField.setText(this.mqServer.getUrl());
                    continue block12;
                }
                case "userName": {
                    textField.setText(this.mqServer.getUserName());
                    continue block12;
                }
                case "userPassword": {
                    textField.setText(this.mqServer.getUserPassword());
                    continue block12;
                }
            }
        }
    }

    private void stopEditMQServer(boolean save) {
        if (save) {
            block14: for (String[] field : this.serversFieldKey) {
                JTextField textField = this.fields.get(field[0]);
                switch (field[0]) {
                    case "title": {
                        this.mqServer.setTitle(textField.getText());
                        continue block14;
                    }
                    case "url": {
                        this.mqServer.setUrl(textField.getText());
                        continue block14;
                    }
                    case "userName": {
                        this.mqServer.setUserName(textField.getText());
                        continue block14;
                    }
                    case "userPassword": {
                        this.mqServer.setUserPassword(textField.getText());
                        continue block14;
                    }
                }
            }
            try {
                this.getMQServerService().updateMQServer(this.mqServer);
                this.mqServer = null;
                this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
                return;
            }
        }
        this.serverEditPanel.setVisible(false);
        this.serverList.setEnabled(true);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            this.serverListModel.clear();
            this.getMQServerService().searchMQServerList(null).getList().forEach(a -> this.serverListModel.addElement((MQServer)a));
        });
        new AbstractBGUPanel.BGActionNew(e -> {
            this.mqServer = new MQServer();
            this.editMQServer();
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            MQServer mqServer = this.serverList.getSelectedValue();
            if (mqServer != null) {
                this.mqServer = mqServer;
                this.editMQServer();
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            if (!this.serverEditPanel.isVisible()) {
                MQServer mqServer = this.serverList.getSelectedValue();
                if (mqServer != null && ClientUtils.confirmDelete(mqServer.getTitle())) {
                    this.getMQServerService().deleteMQServer(mqServer.getId());
                    this.performAction("refresh");
                }
            } else {
                ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0437\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440.");
            }
        });
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public String getTitle() {
        return "\u0421\u0435\u0440\u0432\u0435\u0440\u0430";
    }

    @Override
    public String getCardName() {
        return "servers";
    }
}

