/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.info.AbinaryInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.BinaryInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.ByteInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.IntegerInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.IpAddrInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.Ipv6AddrInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.Ipv6PrefixInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.LongInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.ShortInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.StringInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.TlvInfo;
import ru.bitel.bgbilling.kernel.network.tlv.TlvDictionary;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.inet.IpNet;

public class RadiusDictionary
extends TlvDictionary<RadiusAttributeInfo<?>, RadiusAttribute<?>> {
    private static final Logger log = LogManager.getLogger();
    public static final int User_Name = 1;
    public static final int User_Password = 2;
    public static final int CHAP_Password = 3;
    public static final int NAS_IP_Address = 4;
    public static final int NAS_Port = 5;
    public static final int Service_Type = 6;
    public static final int Framed_Protocol = 7;
    public static final int Framed_IP_Address = 8;
    public static final int Framed_IP_Netmask = 9;
    public static final int Framed_Routing = 10;
    public static final int Filter_Id = 11;
    public static final int Framed_MTU = 12;
    public static final int Framed_Compression = 13;
    public static final int Login_IP_Host = 14;
    public static final int Login_Service = 15;
    public static final int Login_TCP_Port = 16;
    public static final int Reply_Message = 18;
    public static final int Callback_Number = 19;
    public static final int Callback_Id = 20;
    public static final int Framed_Route = 22;
    public static final int State = 24;
    public static final int Class = 25;
    public static final int Vendor_Specific = 26;
    public static final int Called_Station_Id = 30;
    public static final int Calling_Station_Id = 31;
    public static final int NAS_Identifier = 32;
    public static final int Proxy_State = 33;
    public static final int NAS_Port_Id = 87;
    public static final int Acct_Status_Type = 40;
    public static final int Acct_Delay_Time = 41;
    public static final int Acct_Input_Octets = 42;
    public static final int Acct_Output_Octets = 43;
    public static final int Acct_Session_Id = 44;
    public static final int Acct_Authentic = 45;
    public static final int Acct_Session_Time = 46;
    public static final int Acct_Input_Packets = 47;
    public static final int Acct_Output_Packets = 48;
    public static final int Acct_Terminate_Cause = 49;
    public static final int Acct_Input_Gigawords = 52;
    public static final int Acct_Output_Gigawords = 53;
    public static final int CHAP_Challenge = 60;
    public static final int EAP_Message = 79;
    public static final int Message_Authenticator = 80;
    public static final int Framed_Pool = 88;
    public static final int NAS_IPv6_Address = 95;
    public static final int Framed_Interface_Id = 96;
    public static final int Framed_IPv6_Prefix = 97;
    public static final int Framed_IPv6_Route = 99;
    public static final int Delegated_IPv6_Prefix = 123;
    public static final int Draft_Digest_Response = 206;
    public static final int Draft_Digest_Attributes = 207;
    public static final int Digest_Response = 103;
    public static final int Digest_Realm = 104;
    public static final int Digest_Nonce = 105;
    public static final int Digest_Response_Auth = 106;
    public static final int Digest_Nextnonce = 107;
    public static final int Digest_Method = 108;
    public static final int Digest_URI = 109;
    public static final int Digest_Qop = 110;
    public static final int Digest_Algorithm = 111;
    public static final int Digest_Entity_Body_Hash = 112;
    public static final int Digest_CNonce = 113;
    public static final int Digest_Nonce_Count = 114;
    public static final int Digest_Username = 115;
    public static final int Digest_Opaque = 116;
    public static final int Digest_Auth_Param = 117;
    public static final int Digest_AKA_Auts = 118;
    public static final int Digest_Domain = 119;
    public static final int Digest_Stale = 120;
    public static final int Digest_HA1 = 121;
    public static final int SIP_AOR = 122;
    private final RadiusAttributeInfo<?> standartAttributes;
    private final RadiusAttributeInfo<?> vendorAttributes;
    private final Map<String, RadiusAttributeInfo<?>> attributesMap;
    private static RadiusDictionary instance = RadiusDictionary.loadDictionary();
    private static final Pattern octetsPattern = Pattern.compile("^0x([a-fA-F\\d]+)\\s*$");
    private static final Pattern tlvPattern = Pattern.compile("^\\s*\\{\\s*(.*?)\\s*\\}\\s*$");
    private static final Pattern slashPattern = Pattern.compile("\\s*/\\s*");
    private static final char delimiter = ';';

    public RadiusDictionary(RadiusAttributeInfo<?> root) {
        this.standartAttributes = root;
        this.vendorAttributes = (RadiusAttributeInfo)root.getChild(26);
        this.attributesMap = new HashMap();
        this.buildMap(this.attributesMap, root);
    }

    private void buildMap(Map<String, RadiusAttributeInfo<?>> map, RadiusAttributeInfo<?> info) {
        for (RadiusAttributeInfo radiusAttributeInfo : info) {
            this.buildMap(map, radiusAttributeInfo);
            map.put(radiusAttributeInfo.name.toLowerCase(), radiusAttributeInfo);
            if (radiusAttributeInfo.aliases == null) continue;
            for (String alias : radiusAttributeInfo.aliases) {
                map.put(alias.toLowerCase(), radiusAttributeInfo);
            }
        }
    }

    public static void reload() {
        instance = RadiusDictionary.loadDictionary();
        log.info("Load RADIUS dictionary");
    }

    private static File getDictionaryFile() {
        File dictionaryFile = new File("conf" + File.separatorChar + "dictionary.xml");
        if (!dictionaryFile.exists()) {
            dictionaryFile = new File("data" + File.separatorChar + "dictionary.xml");
        }
        return dictionaryFile;
    }

    private static RadiusDictionary loadDictionary() {
        try {
            return RadiusDictionary.loadDictionary(new FileReader(RadiusDictionary.getDictionaryFile()));
        }
        catch (Throwable e) {
            log.error("Error while loading radius dictionary!", e);
            return null;
        }
    }

    private static RadiusDictionary loadDictionary(Reader reader) {
        BinaryInfo root = null;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(RadiusDictionary.getDictionaryFile());
            ArrayList children = new ArrayList();
            for (Element element : XMLUtils.selectElements(doc, "dictionary/attributes/attribute")) {
                children.add(RadiusDictionary.loadAttribute(0, -1, element));
            }
            root = new BinaryInfo(-1, -1, "Dictionary", 0, 1, 1, false, false, children);
            for (RadiusAttributeInfo radiusAttributeInfo : children) {
                radiusAttributeInfo.setParent(root);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new RadiusDictionary(root);
    }

    private static RadiusAttributeInfo<?> loadAttribute(int deep, int vendor, Element attr) {
        Set<String> aliases;
        int code = Utils.parseInt(attr.getAttribute("code"));
        String name = attr.getAttribute("name");
        String type = attr.getAttribute("type");
        ArrayList children = new ArrayList();
        if (deep == 0 && vendor == -1 && code == 26) {
            for (Element vendorEl : XMLUtils.selectElements(attr, "//vendors/vendor")) {
                String vendorName = vendorEl.getAttribute("name");
                int n = Integer.parseInt(vendorEl.getAttribute("code"));
                ArrayList vendorAttributes = new ArrayList();
                for (Element child : XMLUtils.selectElements(vendorEl, "attribute")) {
                    vendorAttributes.add(RadiusDictionary.loadAttribute(1, n, child));
                }
                children.add(new BinaryInfo(n, n, vendorName, 0, 1, 1, false, false, vendorAttributes));
            }
        } else {
            for (Element child : XMLUtils.selectElements(attr, "attribute")) {
                if (deep > 0) {
                    children.add(RadiusDictionary.loadAttribute(deep + 1, -1, child));
                    continue;
                }
                children.add(RadiusDictionary.loadAttribute(deep + 1, vendor, child));
            }
        }
        if (vendor != -1 || code == 79) {
            // empty if block
        }
        RadiusAttributeInfo result = "string".equals(type) ? new StringInfo(vendor, code, name, attr, children) : ("integer".equals(type) ? new IntegerInfo(vendor, code, name, attr, children) : ("long".equals(type) ? new LongInfo(vendor, code, name, attr, children) : ("short".equals(type) ? new ShortInfo(vendor, code, name, attr, children) : ("byte".equals(type) ? new ByteInfo(vendor, code, name, attr, children) : ("ipaddr".equals(type) ? new IpAddrInfo(vendor, code, name, attr, children) : ("ipv6addr".equals(type) ? new Ipv6AddrInfo(vendor, code, name, attr, children) : ("ipv6prefix".equals(type) ? new Ipv6PrefixInfo(vendor, code, name, attr, children) : ("abinary".equals(type) ? new AbinaryInfo(vendor, code, name, attr, children) : ("tlv".equals(type) ? new TlvInfo(vendor, code, name, attr, children) : new BinaryInfo(vendor, code, name, attr, children))))))))));
        String aliasesString = attr.getAttribute("aliases");
        if (Utils.notEmptyString(aliasesString) && (aliases = Utils.toSet(aliasesString)).size() > 0) {
            result.aliases = aliases;
        }
        for (RadiusAttributeInfo radiusAttributeInfo : children) {
            radiusAttributeInfo.setParent(result);
        }
        return result;
    }

    private static final NameAndTag getNameAndTag(String name) {
        NameAndTag result = new NameAndTag();
        result.name = name;
        int pos = name.indexOf(58);
        if (pos > 0 && pos < name.length() - 1) {
            result.tag = Utils.parseInt(name.substring(pos + 1), -1);
            if (result.tag >= 0) {
                result.name = name.substring(0, pos);
            }
        }
        return result;
    }

    public static RadiusAttributeInfo<?> findAttributeInfo(String name) {
        return RadiusDictionary.instance.attributesMap.get(RadiusDictionary.getNameAndTag((String)name).name.toLowerCase());
    }

    public static RadiusAttribute<?> newRadiusAttribute(String name, String value) {
        RadiusAttributeInfo<?> info = RadiusDictionary.findAttributeInfo(name);
        if (info != null) {
            return RadiusDictionary.newRadiusAttribute(info, RadiusDictionary.getNameAndTag((String)name).tag, value);
        }
        log.warn("Radius attribute " + name + " not found in dictionary!");
        return null;
    }

    static RadiusAttribute<?> newRadiusAttribute(RadiusAttributeInfo<?> parentInfo, String name, String value) {
        NameAndTag nameAndTag = RadiusDictionary.getNameAndTag(name);
        RadiusAttributeInfo<?> info = parentInfo == null ? RadiusDictionary.instance.attributesMap.get(nameAndTag.name.toLowerCase()) : (RadiusAttributeInfo<?>)parentInfo.getChild(nameAndTag.name.toLowerCase());
        if (info != null) {
            return RadiusDictionary.newRadiusAttribute(info, nameAndTag.tag, value);
        }
        log.warn("Radius attribute " + name + " not found in dictionary!");
        return null;
    }

    static <V> RadiusAttribute<V> newRadiusAttribute(RadiusAttributeInfo<V> info, int tag, ByteBuffer data, V value) {
        return new RadiusAttribute<V>(info, tag, data, value);
    }

    static RadiusAttribute<?> newRadiusAttribute(RadiusAttributeInfo<?> info, int tag, ByteBuffer value) {
        switch (info.valueType) {
            case 4: {
                return new RadiusAttribute.RadiusAttributeInteger(info, tag, value);
            }
            case 5: {
                return new RadiusAttribute<ByteBuffer>((RadiusAttributeInfo<ByteBuffer>)info, tag, value);
            }
            case 6: {
                return new RadiusAttribute<ByteBuffer>((RadiusAttributeInfo<ByteBuffer>)info, tag, value);
            }
            case 10: {
                return new RadiusAttribute.RadiusAttributeIpAddr(info, tag, value);
            }
            case 2: {
                return new RadiusAttribute.RadiusAttributeString((RadiusAttributeInfo<String>)info, tag, value);
            }
            case 11: {
                return new RadiusAttribute.RadiusAttributeAbinary((RadiusAttributeInfo<String>)info, tag, value);
            }
        }
        return new RadiusAttribute<ByteBuffer>((RadiusAttributeInfo<ByteBuffer>)info, tag, value);
    }

    static RadiusAttribute<?> newRadiusAttribute(RadiusAttributeInfo<?> info, int tag, String value) {
        switch (info.valueType) {
            case 4: {
                return new RadiusAttribute.RadiusAttributeInteger(info, tag, Utils.parseInt(value));
            }
            case 5: {
                return new RadiusAttribute<Short>(info, tag, Short.valueOf((short)(Utils.parseInt(value) & 0xFFFF)));
            }
            case 6: {
                return new RadiusAttribute<Byte>(info, tag, Byte.valueOf((byte)(Utils.parseInt(value) & 0xFF)));
            }
            case 10: {
                return new RadiusAttribute.RadiusAttributeIpAddr(info, tag, IPUtils.convertStringIPtoInt(value));
            }
            case 2: {
                return new RadiusAttribute.RadiusAttributeString(info, tag, value);
            }
            case 11: {
                return new RadiusAttribute.RadiusAttributeAbinary(info, tag, value);
            }
            case 9: {
                Matcher m = tlvPattern.matcher(value);
                if (m.matches()) {
                    value = m.group(1);
                }
                HashMap map = new HashMap();
                for (RadiusAttribute<?> ra : RadiusDictionary.parseAttributes(value)) {
                    map.put(((RadiusAttributeInfo)ra.info).type, ra);
                }
                return new RadiusAttribute(info, tag, map);
            }
            case 1: {
                Matcher m = octetsPattern.matcher(value);
                if (m.find()) {
                    byte[] data = new BigInteger(m.group(1), 16).toByteArray();
                    return new RadiusAttribute<byte[]>(info, tag, data);
                }
                log.info("info = {}, tag = {}, vaalue = {}", info, (Object)tag, (Object)value);
                return new RadiusAttribute<String>(info, tag, value);
            }
            case 20: {
                try {
                    InetAddress address = InetAddress.getByName(value);
                    return new RadiusAttribute<byte[]>(info, tag, address.getAddress());
                }
                catch (UnknownHostException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return new RadiusAttribute<byte[]>(info, tag, new byte[16]);
                }
            }
            case 21: {
                try {
                    String[] s = slashPattern.split(value);
                    if (s.length == 2) {
                        InetAddress address = InetAddress.getByName(s[0]);
                        int mask = Utils.parseInt(s[1], 64);
                        return new RadiusAttribute<IpNet>(info, tag, new IpNet(address.getAddress(), mask));
                    }
                }
                catch (UnknownHostException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                return new RadiusAttribute<IpNet>(info, tag, new IpNet(new byte[16], 64));
            }
        }
        log.info("info = {}, tag = {}, vaalue = {}", info, (Object)tag, (Object)value);
        return new RadiusAttribute<String>(info, tag, value);
    }

    @Deprecated
    public static RadiusAttribute<?> parse(ByteBuffer bb) {
        RadiusAttributeInfo.RadiusAttributeHeader header = new RadiusAttributeInfo.RadiusAttributeHeader();
        RadiusDictionary.instance.standartAttributes.readTypeLength(bb, header, 0, true);
        RadiusAttributeInfo info = null;
        if (header.type != 26) {
            header.vendor = -1;
            info = (RadiusAttributeInfo)RadiusDictionary.instance.standartAttributes.getChild(header.type);
            if (info == null) {
                String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
                info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
            }
        } else {
            header.vendor = bb.getInt();
            RadiusAttributeInfo vendorInfo = (RadiusAttributeInfo)RadiusDictionary.instance.vendorAttributes.getChild(header.vendor);
            if (vendorInfo != null) {
                vendorInfo.readTypeLength(bb, header, header.length, true);
                info = (RadiusAttributeInfo)vendorInfo.getChild(header.type);
            } else {
                header.length -= 4;
                header.type = -1;
            }
            if (info == null) {
                String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
                info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
            }
        }
        return info.read(bb, header);
    }

    public static void parse(ByteBuffer bb, List<RadiusAttribute<?>> result) {
        RadiusAttributeInfo.RadiusAttributeHeader header = new RadiusAttributeInfo.RadiusAttributeHeader();
        RadiusDictionary.instance.standartAttributes.readTypeLength(bb, header, 0, true);
        RadiusAttributeInfo info = null;
        if (header.type != 26) {
            header.vendor = -1;
            info = (RadiusAttributeInfo)RadiusDictionary.instance.standartAttributes.getChild(header.type);
            if (info == null) {
                String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
                info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
            }
            result.add(info.read(bb, header));
            return;
        }
        header.vendor = bb.getInt();
        RadiusAttributeInfo vendorInfo = (RadiusAttributeInfo)RadiusDictionary.instance.vendorAttributes.getChild(header.vendor);
        if (vendorInfo != null) {
            int len = header.length - 4;
            int lastLen = 0;
            while (len >= 2) {
                vendorInfo.readTypeLength(bb, header, header.length, true);
                lastLen = header.length;
                len -= lastLen + 2;
                info = (RadiusAttributeInfo)vendorInfo.getChild(header.type);
                if (info == null) {
                    String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
                    info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
                }
                result.add(info.read(bb, header));
            }
            return;
        }
        header.length -= 4;
        header.type = -1;
        String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
        info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
        result.add(info.read(bb, header));
    }

    public static RadiusAttribute<?> parse(RadiusAttributeInfo.RadiusAttributeHeader header, ByteBuffer bb) {
        RadiusAttributeInfo info = null;
        if (header.type != 26) {
            header.vendor = -1;
            info = (RadiusAttributeInfo)RadiusDictionary.instance.standartAttributes.getChild(header.type);
            if (info == null) {
                String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
                info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
            }
        } else {
            header.vendor = bb.getInt();
            RadiusAttributeInfo vendorInfo = (RadiusAttributeInfo)RadiusDictionary.instance.vendorAttributes.getChild(header.vendor);
            if (vendorInfo != null) {
                vendorInfo.readTypeLength(bb, header, header.length, true);
                info = (RadiusAttributeInfo)vendorInfo.getChild(header.type);
            } else {
                header.length -= 4;
                header.type = -1;
            }
            if (info == null) {
                String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
                info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
            }
        }
        return info.read(bb, header);
    }

    static RadiusAttribute<?> newRadiusAttribute(int vendor, int type, ByteBuffer data) {
        StringInfo info = RadiusDictionary.getAttributeInfo(vendor, type);
        if (info != null) {
            return RadiusDictionary.newRadiusAttribute(info, 0, data);
        }
        String name = "UNKNOWN[" + vendor + "-" + type + "]";
        info = new StringInfo(vendor, type, name, 0, 1, 1, false, false, null);
        return new RadiusAttribute<ByteBuffer>((RadiusAttributeInfo<ByteBuffer>)info, 0, data);
    }

    public static boolean parseAttributes(ByteBuffer bb, int packetLength, Map<Integer, List<RadiusAttribute<?>>> standartAttributes, Map<Integer, Map<Integer, List<RadiusAttribute<?>>>> vendorAttributes) {
        int maxPosition = bb.position() + packetLength - 20;
        return RadiusDictionary.parseAttributes0(bb, maxPosition, standartAttributes, vendorAttributes);
    }

    public static RadiusAttributeSet parseAttributes(ByteBuffer bb) {
        HashMap standartAttributes = new HashMap();
        HashMap vendorAttributes = new HashMap();
        if (RadiusDictionary.parseAttributes0(bb, bb.limit(), standartAttributes, vendorAttributes)) {
            return new RadiusAttributeSet(standartAttributes, vendorAttributes);
        }
        return null;
    }

    private static boolean parseAttributes0(ByteBuffer bb, int maxPosition, Map<Integer, List<RadiusAttribute<?>>> standartAttributes, Map<Integer, Map<Integer, List<RadiusAttribute<?>>>> vendorAttributes) {
        ArrayList attrList = new ArrayList(4);
        while (bb.position() < maxPosition) {
            attrList.clear();
            RadiusDictionary.parse(bb, attrList);
            int size = attrList.size();
            for (int i = 0; i < size; ++i) {
                List<RadiusAttribute<?>> list;
                RadiusAttribute attr = (RadiusAttribute)attrList.get(i);
                int vendor = ((RadiusAttributeInfo)attr.info).vendor;
                int type = ((RadiusAttributeInfo)attr.info).type;
                if (vendor == -1) {
                    List<RadiusAttribute<?>> list2 = standartAttributes.get(type);
                    if (list2 == null) {
                        list2 = new ArrayList(3);
                        standartAttributes.put(type, list2);
                    }
                    list2.add(attr);
                    continue;
                }
                Map<Integer, List<RadiusAttribute<?>>> attributes = vendorAttributes.get(vendor);
                if (attributes == null) {
                    attributes = new HashMap();
                    vendorAttributes.put(vendor, attributes);
                }
                if ((list = attributes.get(type)) == null) {
                    list = new ArrayList(3);
                    attributes.put(type, list);
                }
                list.add(attr);
            }
        }
        return bb.position() == maxPosition;
    }

    public static <V> RadiusAttributeInfo<V> getAttributeInfo(int vendor, int type) {
        if (vendor < 0) {
            return (RadiusAttributeInfo)RadiusDictionary.instance.standartAttributes.getChild(type);
        }
        RadiusAttributeInfo attributes = (RadiusAttributeInfo)RadiusDictionary.instance.vendorAttributes.getChild(vendor);
        if (attributes != null) {
            return (RadiusAttributeInfo)attributes.getChild(type);
        }
        return null;
    }

    static List<RadiusAttribute<?>> parseAttributes(String attributes) {
        ArrayList result = new ArrayList();
        if (!Utils.isBlankString(attributes)) {
            StringBuilder attribute = new StringBuilder();
            int length = attributes.length();
            int lastPos = length - 1;
            int prevDelimCount = 0;
            for (int i = 0; i < length; ++i) {
                char letter = attributes.charAt(i);
                if (letter == ';' && i != lastPos) {
                    ++prevDelimCount;
                    continue;
                }
                if (letter == ';') {
                    ++prevDelimCount;
                }
                for (int k = 0; k < prevDelimCount / 2; ++k) {
                    attribute.append(';');
                }
                if (i == lastPos && letter != ';') {
                    attribute.append(letter);
                }
                if (i == lastPos || prevDelimCount % 2 == 1) {
                    String value;
                    String name;
                    RadiusAttribute<?> ra;
                    int pos;
                    String attrString = attribute.toString();
                    if (attrString.length() > 0 && (pos = attrString.indexOf("=")) > 0 && (ra = RadiusDictionary.newRadiusAttribute(name = attrString.substring(0, pos), value = attrString.substring(pos + 1).replaceAll(";;", ";"))) != null) {
                        result.add(ra);
                    }
                    attribute.setLength(0);
                }
                prevDelimCount = 0;
                attribute.append(letter);
            }
        }
        return result;
    }

    public static boolean checkAttribute(int vendorCode, int type, int valueType) {
        RadiusAttributeInfo info = RadiusDictionary.getAttributeInfo(vendorCode, type);
        return info != null && info.valueType == valueType;
    }

    private static class NameAndTag {
        public String name;
        public int tag;

        private NameAndTag() {
        }
    }

    static enum RadiusAttributeValueType {
        octets,
        string,
        integer,
        ipaddr,
        abinary;

    }
}

