/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelItem;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelTreeCellRenderer;

public class TariffLabelTree
extends JTree
implements Autoscroll {
    private int margin = 12;
    private JPopupMenu popupMenu = null;
    private NodeSelectionListener listener = new NodeSelectionListener();

    public TariffLabelTree() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setCellRenderer(new TariffLabelTreeCellRenderer());
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.getSelectionModel().setSelectionMode(1);
        this.onNodeSelectionListener();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath treePath;
                if (TariffLabelTree.this.isEnabled() && event.getButton() == 3 && (treePath = TariffLabelTree.this.getSelectionPath()) != null) {
                    Point p = event.getPoint();
                    Rectangle b = TariffLabelTree.this.getPathBounds(treePath);
                    if (b.contains(p) && TariffLabelTree.this.popupMenu != null) {
                        TariffLabelTree.this.popupMenu.show(event.getComponent(), p.x, b.y + b.height + 1);
                    }
                }
            }
        });
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public void setData(List<TariffLabelItem> tariffLabelItemList) {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(new TariffLabelItem(){
            {
                this.setTitle("\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
            }
        })));
        this.buildTariffLabelTree((DefaultMutableTreeNode)this.getModel().getRoot(), tariffLabelItemList, 0);
        for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)this.getModel().getRoot()).getNextNode(); node != null; node = node.getNextNode()) {
            this.expandPath(new TreePath(node.getPath()));
        }
    }

    public List<TariffLabelItem> getSelectedItems() {
        ArrayList<TariffLabelItem> tariffLabelItemList = new ArrayList<TariffLabelItem>();
        for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)this.getModel().getRoot()).getNextNode(); node != null; node = node.getNextNode()) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof TariffLabelItem) || !((TariffLabelItem)userObject).isSelected()) continue;
            tariffLabelItemList.add((TariffLabelItem)userObject);
        }
        return tariffLabelItemList;
    }

    public List<Integer> getSelectedIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)this.getModel().getRoot()).getNextNode(); node != null; node = node.getNextNode()) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof TariffLabelItem) || !((TariffLabelItem)userObject).isSelected()) continue;
            ids.add(((TariffLabelItem)userObject).getId());
        }
        return ids;
    }

    private void buildTariffLabelTree(DefaultMutableTreeNode currentNode, List<TariffLabelItem> tariffLabelItemList, int parentTariffPlanId) {
        for (TariffLabelItem tariffLabelItem : tariffLabelItemList) {
            if (tariffLabelItem.getParentId() != parentTariffPlanId) continue;
            DefaultMutableTreeNode labelTreeNode = new DefaultMutableTreeNode();
            labelTreeNode.setUserObject(tariffLabelItem);
            currentNode.add(labelTreeNode);
            this.buildTariffLabelTree(labelTreeNode, tariffLabelItemList, tariffLabelItem.getId());
        }
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TariffLabelItem tariffLabelItem;
        DefaultMutableTreeNode tariffLabelTreeNode;
        Object userObject;
        String text = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode && !this.isEditable() && (userObject = (tariffLabelTreeNode = (DefaultMutableTreeNode)value).getUserObject()) instanceof TariffLabelItem && (tariffLabelItem = (TariffLabelItem)userObject).getTariffLinkCount() > 0) {
            text = text.concat(" [").concat(String.valueOf(tariffLabelItem.getTariffLinkCount())).concat("]");
        }
        return text;
    }

    public void onNodeSelectionListener() {
        boolean fl = true;
        for (MouseListener mouseListener : this.getMouseListeners()) {
            if (mouseListener != this.listener) continue;
            fl = false;
            break;
        }
        if (fl) {
            this.addMouseListener(this.listener);
        }
        fl = true;
        for (EventListener eventListener : this.getKeyListeners()) {
            if (eventListener != this.listener) continue;
            fl = false;
            break;
        }
        if (fl) {
            this.addKeyListener(this.listener);
        }
    }

    public void offNodeSelectionListener() {
        this.removeMouseListener(this.listener);
        this.removeKeyListener(this.listener);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + this.margin, inner.x - outer.x + this.margin, outer.height - inner.height - inner.y + outer.y + this.margin, outer.width - inner.width - inner.x + outer.x + this.margin);
    }

    @Override
    public void autoscroll(Point p) {
        int realrow = this.getRowForLocation(p.x, p.y);
        Rectangle outer = this.getBounds();
        realrow = p.y + outer.y <= this.margin ? (realrow < 1 ? 0 : realrow - 1) : (realrow < this.getRowCount() - 1 ? realrow + 1 : realrow);
        this.scrollRowToVisible(realrow);
    }

    private final class NodeSelectionListener
    extends MouseAdapter
    implements KeyListener {
        private NodeSelectionListener() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Object selectedObject;
            int y;
            int x;
            int row;
            TreePath path;
            Object source = event.getSource();
            if (source instanceof TariffLabelTree && ((TariffLabelTree)source).isEnabled() && (path = TariffLabelTree.this.getPathForRow(row = TariffLabelTree.this.getRowForLocation(x = event.getX(), y = event.getY()))) != null && SwingUtilities.isLeftMouseButton(event) && (selectedObject = TariffLabelTree.this.getLastSelectedPathComponent()) instanceof DefaultMutableTreeNode) {
                this.action((DefaultMutableTreeNode)selectedObject);
            }
        }

        @Override
        public final void keyReleased(KeyEvent keyevent) {
            int i = keyevent.getKeyCode();
            if (i == 32 || i == 10) {
                this.action((DefaultMutableTreeNode)TariffLabelTree.this.getLastSelectedPathComponent());
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void action(DefaultMutableTreeNode node) {
            if (node == null) {
                return;
            }
            Object userObject = node.getUserObject();
            if (userObject instanceof TariffLabelItem) {
                TariffLabelItem tariffLabelItem;
                tariffLabelItem.setSelected(!(tariffLabelItem = (TariffLabelItem)userObject).isSelected());
                TariffLabelTree.this.firePropertyChange("changeSelected", !tariffLabelItem.isSelected(), tariffLabelItem.isSelected());
                TariffLabelTree.this.repaint();
            }
        }
    }
}

