/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.admin.action.base.ActionBase;
import bitel.billing.server.admin.bgsecure.bean.MenuRestrictManager;
import bitel.billing.server.admin.bgsecure.bean.RestrictionMap;
import bitel.billing.server.util.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.MenuItem;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserMenuDao;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginBase;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;

public class ActionMenuAndToolBar
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        this.rootNode.setAttribute("timeZone", TimeZone.getDefault().getID());
        this.rootNode.setAttribute("userId", String.valueOf(this.userId));
        String firmTitle = FileUtils.getInstance().getTitle();
        if (firmTitle != null) {
            this.rootNode.setAttribute("firmTitle", firmTitle);
            this.rootNode.setAttribute("user", this.userName);
        }
        Element modules = this.createElement(this.rootNode, "moduleParams");
        List<BGModule> modulesList = ModuleCache.getInstance().getModulesList();
        for (BGModule module : modulesList) {
            ModuleSetup moduleSetup = this.setup.getModuleSetup(module.getId());
            this.createModuleParamNode(modules, moduleSetup, String.valueOf(module.getId()));
        }
        Element plugins = this.createElement(this.rootNode, "pluginParams");
        Map<String, BGPluginServer> pluginsMap = BGPluginManagerServer.getManager().getPluginsMap();
        for (Map.Entry entry : pluginsMap.entrySet()) {
            this.createModuleParamNode(plugins, ((BGPluginServer)entry.getValue()).getSetup(), ((BGPluginServer)entry.getValue()).getId());
        }
        Element params = this.createElement(this.rootNode, "params");
        ParameterMap parameterMap = this.setup.sub("client.gui.");
        for (Object entry : parameterMap.entrySet()) {
            Element element = this.createElement(params, "param");
            element.setAttribute("key", (String)entry.getKey());
            element.setAttribute("value", (String)entry.getValue());
        }
        Element pluginList = this.createElement(this.rootNode, "plugin_list");
        for (BGPluginBase bGPluginBase : BGPluginManagerServer.getManager().getPluginsMap().values()) {
            Element pluginEl = this.createElement(pluginList, "plugin");
            pluginEl.setAttribute("id", bGPluginBase.getId());
        }
        this.menuBar();
        this.toolBar();
        VersionInfo versionInfo = VersionInfo.getVersionInfo((String)"kernel");
        String string = versionInfo.getVersion();
        this.rootNode.setAttribute("serverversion", string);
        this.rootNode.setAttribute("clientversion", versionInfo.getVersionString());
    }

    private void createModuleParamNode(Element rootElem, Preferences setup, String id) {
        Object[] entry = setup.entrySet().toArray();
        Element elem = this.createElement(rootElem, rootElem.getNodeName().equals("moduleParams") ? "module" : "plugin");
        elem.setAttribute("id", id);
        for (int i = 0; i < entry.length; ++i) {
            String param = entry[i].toString();
            if (!param.startsWith("client.")) continue;
            Element paramModule = this.createElement(elem, "param");
            paramModule.setAttribute("key", param.substring(0, param.indexOf("=")));
            paramModule.setAttribute("value", param.substring(param.indexOf("=") + 1, param.length()));
        }
    }

    private void menuBar() {
        try {
            int i;
            MenuRestrictManager menuRestrictManager = new MenuRestrictManager(this.con);
            RestrictionMap menuAccessMap = menuRestrictManager.getMenuAccessListForUser(this.userId);
            int userMenuId = -1;
            String menuXml = null;
            if (this.userId > 1) {
                userMenuId = PermissionOfRoles.getRoleByUserId(this.userId).map(Role::getMenuId).orElse(-1);
                try (UserMenuDao userMenuDao = new UserMenuDao(this.con);){
                    if (userMenuId == -1) {
                        Optional<MenuItem> optional = userMenuDao.list().stream().filter(MenuItem::isDefault).findFirst();
                        if (optional.isPresent()) {
                            userMenuId = optional.get().getId();
                            menuXml = userMenuDao.getData(userMenuId);
                        }
                    } else if (userMenuId > 0) {
                        menuXml = userMenuDao.getData(userMenuId);
                    }
                }
            }
            if (menuXml == null || menuXml.isBlank() || userMenuId == -1) {
                menuXml = Files.readString(Paths.get("data", this.setup.get("file.menu", "menu.xml")), Charset.forName("UTF-8"));
            }
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document doc = docBuilder.parse((InputStream)new ByteArrayInputStream(menuXml.getBytes(StandardCharsets.UTF_8)));
            Element menuBar = doc.getDocumentElement();
            NodeList menulist = menuBar.getElementsByTagName("menu");
            HashMap<String, Object> idElementMenu = new HashMap<String, Object>();
            for (i = 0; i < menulist.getLength(); ++i) {
                Element menu1 = (Element)menulist.item(i);
                String id1 = menu1.getAttribute("id");
                if (id1 == null) continue;
                idElementMenu.put(id1, menu1);
            }
            i = 1;
            for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions(ActionMenuAndToolBar.class.getCanonicalName(), false)) {
                try {
                    Element extensionElement = extension.getElement();
                    BGPluginServer plugin = (BGPluginServer)extension.getPlugin();
                    NodeList menuList = extensionElement.getElementsByTagName("menu");
                    for (int index1 = 0; index1 < menuList.getLength(); ++index1) {
                        Element menuElement = (Element)menuList.item(index1);
                        String menuId = menuElement.getAttribute("id");
                        String menuTitle = plugin.getResourceString(menuElement.getAttribute("title"));
                        NodeList menuItemList = menuElement.getElementsByTagName("menuItem");
                        for (int index2 = 0; index2 < menuItemList.getLength(); ++index2) {
                            Element menuItemElement = (Element)menuItemList.item(index2);
                            String menuItemClassName = menuItemElement.getAttribute("className");
                            String menuItemTitle = plugin.getResourceString(menuItemElement.getAttribute("title"));
                            if (!idElementMenu.containsKey(menuId)) {
                                Element menu1 = doc.createElement("menu");
                                menu1.setAttribute("id", menuId);
                                menu1.setAttribute("title", menuTitle);
                                menuBar.appendChild(menu1);
                                idElementMenu.put(menuId, menu1);
                            }
                            Element menuItem1 = doc.createElement("menuItem");
                            menuItem1.setAttribute("id", menuItemElement.getAttribute("id"));
                            menuItem1.setAttribute("title", menuItemTitle);
                            if ("plugin".equals(menuId)) {
                                menuItem1.setAttribute("name", i++ + ". " + menuItemTitle);
                            }
                            menuItem1.setAttribute("className", menuItemClassName);
                            ((Element)idElementMenu.get(menuId)).appendChild(menuItem1);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            NodeList modulesList = menuBar.getElementsByTagName("modules");
            Element modules = modulesList != null && modulesList.getLength() > 0 ? (Element)modulesList.item(0) : null;
            NodeList reportsList = menuBar.getElementsByTagName("reports");
            Element reports = reportsList != null && reportsList.getLength() > 0 ? (Element)reportsList.item(0) : null;
            i = 1;
            for (BGModule bgModule : ModuleCache.getInstance().getModulesList()) {
                BGInstalledModule bgInstalledModule = bgModule.getInstalledModule();
                if (bgInstalledModule != null) {
                    Element menuItem1 = doc.createElement("menuItem");
                    menuItem1.setAttribute("id", String.valueOf(bgModule.getId()));
                    menuItem1.setAttribute("mid", String.valueOf(bgModule.getId()));
                    menuItem1.setAttribute("title", bgModule.getTitle());
                    menuItem1.setAttribute("name", i++ + ". " + bgModule.getTitle());
                    String packageClient = bgInstalledModule.getPackageClient();
                    if (modules != null) {
                        menuItem1.setAttribute("className", packageClient + ".ActionServiceConfig");
                        modules.getParentNode().insertBefore(menuItem1, modules);
                    }
                    if (reports == null) continue;
                    Element menuItem2 = (Element)menuItem1.cloneNode(true);
                    menuItem2.setAttribute("className", packageClient + ".ActionServiceReport");
                    reports.getParentNode().insertBefore(menuItem2, reports);
                    continue;
                }
                log.error("bgModule.getInstalledModule() == null for bgModule = {} (#{})", (Object)bgModule.getTitle(), (Object)bgModule.getId());
            }
            if (modules != null) {
                modules.getParentNode().removeChild(modules);
            }
            if (reports != null) {
                reports.getParentNode().removeChild(reports);
            }
            NodeList menuItemList = menuBar.getElementsByTagName("menuItem");
            block14: for (int m = 0; m < menuItemList.getLength(); ++m) {
                Element menuItem = (Element)menuItemList.item(m);
                Object itemId = menuItem.getAttribute("id");
                if (itemId == null) continue;
                Element menuElement = (Element)menuItem.getParentNode();
                while (!"menuBar".equals(menuElement.getNodeName())) {
                    Boolean hideItem;
                    String id = menuElement.getAttribute("id");
                    if (id != null && (hideItem = menuAccessMap.get((String)(itemId = id + "." + (String)itemId))) != null && hideItem.booleanValue()) {
                        menuItem.getParentNode().removeChild(menuItem);
                        --m;
                        continue block14;
                    }
                    menuElement = (Element)menuElement.getParentNode();
                }
            }
            this.rootNode.appendChild(this.rootNode.getOwnerDocument().importNode(menuBar, true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void toolBar() throws SQLException {
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            docBuilder = dFactory.newDocumentBuilder();
            File fileBar = new File(this.setup.get("file.toolbar", "data/toolbar.xml"));
            URL url = fileBar.toURI().toURL();
            Document doc = docBuilder.parse(url.toString());
            Element toolBar = doc.getDocumentElement();
            this.rootNode.appendChild(this.rootNode.getOwnerDocument().importNode(toolBar, true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

