/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.ContractUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractPluginConfigDao;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.bgbilling.kernel.contract.period.server.bean.ContractPeriodDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.SerializeContract;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.ZipUtils;

public class ContractRemover
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger();
    private Connection con;
    private Map<String, String> modulesPackages = new HashMap<String, String>();
    private Map<String, Integer> serviceModules = new HashMap<String, Integer>();
    private ContractUtils _cu;
    private File archiveFolder;
    private File currentFolder;
    private ContractPeriodDao contractPeriodDao;
    private ContractModuleConfigDao contractModuleConfigDao;
    private ContractPluginConfigDao contractPluginConfigDao;
    private Map<String, PreparedStatement> psCach = new HashMap<String, PreparedStatement>();

    public ContractRemover(Connection con, String folder) throws SQLException {
        this.con = con;
        this._cu = new ContractUtils(con);
        this.initServerPackages();
        this.initFolders(folder);
        this.contractPeriodDao = new ContractPeriodDao(con);
        this.contractModuleConfigDao = new ContractModuleConfigDao(con, 0);
        this.contractPluginConfigDao = new ContractPluginConfigDao(con, 0);
    }

    private void initFolders(String folder) {
        this.archiveFolder = new File("archive");
        if (this.archiveFolder.exists() && this.archiveFolder.isDirectory()) {
            String currentFolderPath = this.archiveFolder.getAbsolutePath() + File.separator;
            if (folder != null && !folder.equals("/") && !folder.equals("\\") && folder.length() > 0) {
                currentFolderPath = currentFolderPath + folder + File.separator;
            }
            this.currentFolder = new File(currentFolderPath);
            if (!(this.currentFolder.exists() && this.currentFolder.isDirectory() || this.currentFolder.mkdir())) {
                this.currentFolder = null;
            }
        } else {
            this.archiveFolder = null;
        }
    }

    private void initServerPackages() throws SQLException {
        ResultSet rs;
        String query = "SELECT module.id, im.pack_server FROM module LEFT JOIN installed_modules im ON module.name=im.name";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    this.modulesPackages.put(rs.getString(1), rs.getString(2));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        query = "SELECT id, mid FROM service";
        ps = this.con.prepareStatement(query);
        try {
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    this.serviceModules.put(rs.getString(1), rs.getInt(2));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public String removeContracts(List<Integer> cids, boolean save) throws BGException {
        StringBuilder result = new StringBuilder();
        for (Integer cid : cids) {
            String error = this.removeContract(cid, save);
            if (!Utils.notBlankString((String)error)) continue;
            result.append("\u041a\u043e\u043d\u0442\u0440\u0430\u043a\u0442 \u0441 id=").append(cid).append(" \u043d\u0435 \u0443\u0434\u0430\u043b\u0435\u043d! ").append(error).append("\n");
        }
        return result.toString();
    }

    public String removeContract(int contractId, boolean save) throws BGException {
        return this.removeContract(contractId, save, 0);
    }

    public String removeContract(int cid, boolean save, int userId) throws BGException {
        String error = null;
        ContractDeleteEvent checkEvent = new ContractDeleteEvent(0, userId, cid, true);
        checkEvent = EventProcessor.getInstance().request(checkEvent);
        error = checkEvent.getError() != null ? checkEvent.getError() : (save ? (this.saveContract(cid) ? this.deleteContract(userId, cid) : "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!") : this.deleteContract(userId, cid));
        return error;
    }

    public String deleteContract(int cid) {
        return this.deleteContract(0, cid);
    }

    public String deleteContract(int userId, int contractId) {
        try {
            EventProcessor.getInstance().request(new ContractDeleteEvent(0, userId, contractId, false));
            ContractPatternDao.removeContractTitleFromLastTitles(this._cu.getContractTitle(contractId));
            this.executeDelete("DELETE FROM contract WHERE id=?", contractId);
            this.executeDelete("DELETE FROM contract_service WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_status WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_status_log WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_module WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_payment WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_payment_deleted WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_charge WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_tariff WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_tariff_option WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_tariff_group WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_tariff_vars WHERE contract_tariff_id IN ( SELECT id FROM contract_tariff WHERE cid=? )", contractId);
            this.executeDelete("DELETE FROM contract_balance WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_account WHERE cid=?", contractId);
            try (Statement statement = this.con.createStatement();){
                statement.executeUpdate("CREATE TEMPORARY TABLE `contract_account_detail_ids` AS SELECT DISTINCT `contract_id` FROM `contract_account_detail` AS d LEFT JOIN `contract` AS c ON c.id=d.contract_id WHERE c.id IS NULL");
                statement.executeUpdate("DELETE FROM `contract_account_detail` WHERE `contract_id`=" + contractId + " OR `contract_id` IN ( SELECT `contract_id` FROM `contract_account_detail_ids` )");
                statement.executeUpdate("DROP TEMPORARY TABLE IF EXISTS `contract_account_detail_ids`");
            }
            this.executeDelete("DELETE FROM contract_comment WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_script WHERE cid=?", contractId);
            this.executeDelete("DELETE FROM contract_label_link WHERE contract_id=?", contractId);
            statement = this.con.createStatement();
            try {
                statement.executeUpdate("CREATE TEMPORARY TABLE `contract_web_menu_ids` AS SELECT `contract_id` FROM `contract_web_menu` AS m LEFT JOIN `contract` AS c ON c.id=m.contract_id WHERE c.id IS NULL");
                statement.executeUpdate("DELETE FROM `contract_web_menu` WHERE `contract_id` IN ( SELECT `contract_id` FROM `contract_web_menu_ids` )");
                statement.executeUpdate("DROP TEMPORARY TABLE IF EXISTS `contract_web_menu_ids`");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            this.contractPeriodDao.deleteForContract(contractId);
            this.contractModuleConfigDao.deleteForContract(contractId);
            this.contractPluginConfigDao.deleteForContract(contractId);
            try (ContractParameterManager contractParameterManager = new ContractParameterManager(this.con);){
                contractParameterManager.deleteParamForContractByType(1, contractId);
                contractParameterManager.deleteParamForContractByType(2, contractId);
                contractParameterManager.deleteParamForContractByType(3, contractId);
                contractParameterManager.deleteParamForContractByType(4, contractId);
                contractParameterManager.deleteParamForContractByType(5, contractId);
                contractParameterManager.deleteParamForContractByType(6, contractId);
                contractParameterManager.deleteParamForContractByType(7, contractId);
                contractParameterManager.deleteParamForContractByType(8, contractId);
                contractParameterManager.deleteParamForContractByType(9, contractId);
                contractParameterManager.deleteParamForContractByType(11, contractId);
            }
            List<String> objects = ServerUtils.deleteRowsFromTable(this.con, "object", "cid", String.valueOf(contractId), "id");
            for (String objectId : objects) {
                ServerUtils.deleteRowsFromTable(this.con, "object_param_value_address", "object_id", objectId, null);
                ServerUtils.deleteRowsFromTable(this.con, "object_param_value_date", "object_id", objectId, null);
                ServerUtils.deleteRowsFromTable(this.con, "object_param_value_list", "object_id", objectId, null);
                ServerUtils.deleteRowsFromTable(this.con, "object_param_value_text", "object_id", objectId, null);
            }
            List<String> perTariffs = ServerUtils.deleteRowsFromTable(this.con, "contract_tree_link", "cid", String.valueOf(contractId), "tree_id");
            for (String treeId : perTariffs) {
                ServerUtils.deleteRowsFromTable(this.con, "tariff_tree", "id", treeId, null);
                List<String> mtreeIdList = ServerUtils.deleteRowsFromTable(this.con, "module_tariff_tree", "tree_id", treeId, "id");
                for (String mtreeId : mtreeIdList) {
                    ServerUtils.deleteRowsFromTable(this.con, "mtree_node", "mtree_id", mtreeId, null);
                }
            }
            this.executeDelete("DELETE FROM `customer_link` WHERE `contract_id`=?", contractId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex.getMessage();
        }
        return null;
    }

    private void executeDelete(String query, int contractId) throws SQLException {
        PreparedStatement ps = this.psCach.get(query);
        if (ps == null) {
            ps = this.con.prepareStatement(query);
            this.psCach.put(query, ps);
        }
        if (contractId > 0) {
            ps.setInt(1, contractId);
        }
        ps.executeUpdate();
    }

    private boolean serializeContract(Document doc, int cid) {
        boolean result = false;
        try {
            String cidStr = String.valueOf(cid);
            Element tables = doc.createElement("tables");
            doc.appendChild(tables);
            ServerUtils.addItemsFromRS(this.con, tables, "contract", "id", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_service", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_status", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_account", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_balance", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_payment", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_payment_deleted", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_charge", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_1", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_2", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_3", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_4", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_5", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_6", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_7", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_8", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_phone", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_phone_item", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_multilist", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_parameter_type_multilist_item", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "user_dispatch", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_tariff", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_comment", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_tariff_option", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_script", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_status_log", "cid", cidStr, null, false, null, null);
            ServerUtils.addItemsFromRS(this.con, tables, "contract_tariff_group", "cid", cidStr, null, false, null, null);
            List<String> objects = ServerUtils.addItemsFromRS(this.con, tables, "object", "cid", cidStr, "id", false, null, null);
            for (String string : objects) {
                ServerUtils.addItemsFromRS(this.con, tables, "object_param_value_address", "object_id", string, null, false, null, null);
                ServerUtils.addItemsFromRS(this.con, tables, "object_param_value_date", "object_id", string, null, false, null, null);
                ServerUtils.addItemsFromRS(this.con, tables, "object_param_value_list", "object_id", string, null, false, null, null);
                ServerUtils.addItemsFromRS(this.con, tables, "object_param_value_text", "object_id", string, null, false, null, null);
            }
            List<String> perTariffs = ServerUtils.addItemsFromRS(this.con, tables, "contract_tree_link", "cid", cidStr, "tree_id", false, null, null);
            for (String treeId : perTariffs) {
                ServerUtils.addItemsFromRS(this.con, tables, "tariff_tree", "id", treeId, null, false, null, null);
                List<String> mtreeIdList = ServerUtils.addItemsFromRS(this.con, tables, "module_tariff_tree", "tree_id", treeId, "id", false, null, null);
                for (String mtreeId : mtreeIdList) {
                    ServerUtils.addItemsFromRS(this.con, tables, "mtree_node", "mtree_id", mtreeId, null, false, null, null);
                }
            }
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            List<String> mids = ServerUtils.addItemsFromRS(this.con, tables, "contract_module", "cid", cidStr, "mid", false, null, null);
            for (String mid : mids) {
                ApplicationModule am;
                String packageServer = this.modulesPackages.get(mid);
                if (packageServer == null || (am = ContractRemover.getModule(packageServer)) == null) continue;
                am.serializeContract(this.con, cid, Utils.parseInt((String)mid), xMLOutputFactory.createXMLStreamWriter(new DOMResult(tables)), false);
            }
            for (SerializeContract p : BGPluginManagerServer.getManager().getInvokeables(SerializeContract.class, false)) {
                p.serializeContract(this.con, cid, xMLOutputFactory.createXMLStreamWriter(new DOMResult(tables)), false);
            }
            result = true;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return result;
    }

    private static ApplicationModule getModule(String packageServer) {
        ApplicationModule result = null;
        try {
            result = (ApplicationModule)Class.forName(packageServer + ".Module").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return result;
    }

    private boolean saveContract(int contractId) {
        Document doc = XMLUtils.newDocument();
        boolean result = this.serializeContract(doc, contractId);
        if (result) {
            if (this.currentFolder != null) {
                try {
                    String title = this._cu.getContractTitle(contractId, true);
                    if (title.length() > 100) {
                        title = title.substring(0, 100);
                    }
                    FileOutputStream fos = new FileOutputStream(this.currentFolder.getAbsolutePath() + File.separator + contractId + "$" + title.replace('\\', '_').replace('/', '_') + ".zip");
                    ZipOutputStream zos = new ZipOutputStream(fos);
                    zos.putNextEntry(new ZipEntry("archive.xml"));
                    XMLUtils.serialize((Node)doc, (OutputStream)zos, (String)"UTF-8");
                    zos.closeEntry();
                    zos.close();
                    fos.flush();
                    fos.close();
                }
                catch (Exception ex) {
                    logger.error("error save/serialize contract #" + contractId, (Throwable)ex);
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    public List<File> getContractsFromArchive(String fileFilter) {
        ArrayList<File> result = new ArrayList<File>();
        if (this.currentFolder != null) {
            for (File arch : this.currentFolder.listFiles()) {
                if (!arch.isFile() || fileFilter != null && arch.getName().toLowerCase().indexOf(fileFilter.toLowerCase()) < 0) continue;
                result.add(arch);
            }
        } else {
            System.err.println("No archive folder find!");
        }
        return result;
    }

    public String restoreContract(String fileName) {
        Object result;
        block11: {
            result = "";
            if (this.currentFolder != null) {
                try {
                    File zipFile = new File(this.currentFolder.getAbsolutePath() + File.separator + fileName);
                    if (zipFile.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(zipFile);
                        byte[] xml = ZipUtils.getEntry((InputStream)fileInputStream, null);
                        if (xml != null) {
                            Document doc = XMLUtils.parseDocument((byte[])xml);
                            for (Element node : XMLUtils.selectElements((Node)doc, (String)"/tables/*")) {
                                try {
                                    XMLDatabaseSerializer.insertElementToBase(node, this.con);
                                }
                                catch (Exception ex) {
                                    logger.error("error restoreContract.insertElementToBase", (Throwable)ex);
                                    result = (String)result + "\n\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 " + node.getNodeName() + ": " + ex;
                                }
                            }
                        } else {
                            result = "XML \u0432 \u0444\u0430\u0439\u043b\u0435 " + zipFile.getAbsolutePath() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d?";
                        }
                        fileInputStream.close();
                        if (Utils.isBlankString((String)result) && !zipFile.delete()) {
                            result = "Archive delete error!";
                        }
                        break block11;
                    }
                    result = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u0439\u043b:" + fileName + "(" + zipFile.getAbsolutePath() + ")";
                }
                catch (Exception ex) {
                    logger.error("error restoreContract", (Throwable)ex);
                    result = ex.toString();
                }
            } else {
                result = "Not found archive folder!";
            }
        }
        return result;
    }

    public String restoreContractClone(String fileName) {
        Object result;
        block11: {
            result = "";
            if (this.currentFolder != null) {
                try {
                    File zipFile = new File(this.currentFolder.getAbsolutePath() + File.separator + fileName);
                    if (zipFile.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(zipFile);
                        byte[] xml = ZipUtils.getEntry((InputStream)fileInputStream, null);
                        if (xml != null) {
                            Document doc = XMLUtils.parseDocument((byte[])xml);
                            Set<String> kernelTables = ContractRemover.getKernelTables();
                            int cid = 0;
                            for (Element node : XMLUtils.selectElements((Node)doc, (String)"/tables/*")) {
                                try {
                                    String tableName = node.getNodeName();
                                    if (tableName.equals("contract")) {
                                        node.removeAttribute("id");
                                        cid = XMLDatabaseSerializer.insertElementToBase(node, this.con);
                                        continue;
                                    }
                                    if (!kernelTables.contains(node.getNodeName()) || cid == 0) continue;
                                    node.setAttribute("cid", String.valueOf(cid));
                                    node.removeAttribute("id");
                                    XMLDatabaseSerializer.insertElementToBase(node, this.con);
                                }
                                catch (Exception ex) {
                                    logger.error("error restoreContractClone.insertElementToBase", (Throwable)ex);
                                    result = (String)result + "\n\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 " + node.getNodeName() + ": " + ex.toString();
                                }
                            }
                        } else {
                            result = "XML \u0432 \u0444\u0430\u0439\u043b\u0435 " + zipFile.getAbsolutePath() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d?";
                        }
                        fileInputStream.close();
                        break block11;
                    }
                    result = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u0439\u043b:" + fileName + "(" + zipFile.getAbsolutePath() + ")";
                }
                catch (Exception ex) {
                    logger.error("error restoreContractClone", (Throwable)ex);
                    result = ex.toString();
                }
            } else {
                result = "No archive folder find!";
            }
        }
        return result;
    }

    private static Set<String> getKernelTables() {
        HashSet<String> result = new HashSet<String>();
        result.add("contract_account");
        result.add("contract_balance");
        result.add("contract_payment");
        result.add("contract_charge");
        result.add("contract_parameter_type_1");
        result.add("contract_parameter_type_2");
        result.add("contract_parameter_type_3");
        result.add("contract_parameter_type_4");
        result.add("contract_parameter_type_5");
        result.add("contract_parameter_type_6");
        result.add("contract_parameter_type_7");
        result.add("contract_parameter_type_phone");
        result.add("contract_parameter_type_phone_item");
        result.add("contract_tariff");
        result.add("contract_service");
        result.add("contract_tariff_group");
        return result;
    }

    public List<String> getFolders() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.archiveFolder != null) {
            File[] files = this.archiveFolder.listFiles();
            result.add("/");
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                result.add(files[i].getName());
            }
        }
        return result;
    }

    public String getArchiveContent(String fileName) {
        String result = "";
        if (this.currentFolder != null) {
            try {
                File zipFile = new File(this.currentFolder.getAbsolutePath() + File.separator + fileName);
                if (zipFile.exists()) {
                    FileInputStream fis = new FileInputStream(zipFile);
                    byte[] xml = ZipUtils.getEntry((InputStream)fis, null);
                    if (xml != null && (result = new String(xml, "UTF-8")).indexOf("encoding=\"WINDOWS-1251\"") != -1) {
                        result = new String(xml, "cp1251");
                    }
                    fis.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        result = result.replace("><", ">\n<");
        return result;
    }

    @Override
    public void close() {
        try {
            for (PreparedStatement ps : this.psCach.values()) {
                ps.close();
            }
            this.contractModuleConfigDao.close();
            this.contractPluginConfigDao.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

