/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import bitel.billing.server.util.RequestCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.StopableThread;
import ru.bitel.common.Utils;

public class Antispam
extends StopableThread {
    private static final Logger log = LogManager.getLogger();
    private static Antispam antispam = null;
    private static final int REVISE_PERIOD = 60000;
    private boolean antispamEnable = false;
    private List<RadiusAttributeInfo<?>> keyAttributes = new ArrayList();
    private int rejectCount = 10;
    private long rejectPerTime = 120000L;
    private long banTime = 600000L;
    private Map<String, RequestCounter> rejectCounters = new ConcurrentHashMap<String, RequestCounter>();
    private Map<String, Long> banStartTimes = new ConcurrentHashMap<String, Long>();

    public static void initAntispam(ParameterMap setup) {
        if (antispam != null) {
            antispam.shutdown();
        }
        antispam = new Antispam(setup);
    }

    public static Antispam getAntispam() {
        return antispam;
    }

    private Antispam(ParameterMap setup) {
        String prefix = "antispam.";
        List keyAttributes = Utils.toList((String)setup.get(prefix + "key.attributes", null));
        if (keyAttributes.size() == 0) {
            return;
        }
        for (String attrName : keyAttributes) {
            RadiusAttributeInfo<?> attr = RadiusDictionary.findAttributeInfo(attrName);
            if (attr == null) {
                log.error("Antispam init attr " + attrName + " notfound!");
                return;
            }
            this.keyAttributes.add(attr);
        }
        this.rejectCount = setup.getInt(prefix + "reject.count", this.rejectCount);
        this.rejectPerTime = setup.getLong(prefix + "reject.per.time", this.rejectPerTime / 1000L) * 1000L;
        this.banTime = setup.getLong(prefix + "ban.time", this.banTime / 1000L) * 1000L;
        this.antispamEnable = true;
        this.start();
        log.info("Antispam started. Reject count " + this.rejectCount + " per " + this.rejectPerTime / 1000L + " sec. ban on " + this.banTime / 1000L + " sec.");
    }

    public void addReject(RadiusPacket request) {
        if (!this.antispamEnable) {
            return;
        }
        String key = this.getKey(request);
        RequestCounter counter = this.rejectCounters.get(key);
        if (counter == null) {
            counter = new RequestCounter((int)(this.rejectPerTime / 1000L));
            this.rejectCounters.put(key, counter);
        }
        counter.addRequestCount();
        if (counter.getCount() >= this.rejectCount) {
            log.info("Add to ban: " + key);
            this.banStartTimes.put(key, System.currentTimeMillis());
            this.rejectCounters.remove(key);
        }
    }

    public boolean needBan(RadiusPacket request) {
        if (!this.antispamEnable) {
            return false;
        }
        long now = System.currentTimeMillis();
        String key = this.getKey(request);
        Long banStart = this.banStartTimes.get(key);
        boolean result = banStart != null && now - banStart < this.banTime;
        return result;
    }

    private String getKey(RadiusPacket packet) {
        StringBuilder key = new StringBuilder(20);
        for (RadiusAttributeInfo<?> attr : this.keyAttributes) {
            Object attrValue = packet.getAttribute(attr.vendor, attr.type);
            if (attrValue != null) {
                key.append(((RadiusAttribute)attrValue).toString());
            } else {
                key.append("null");
            }
            key.append('/');
        }
        if (key.length() > 0) {
            key.setLength(key.length() - 1);
        }
        return key.toString();
    }

    public void run() {
        while (this.working) {
            try {
                long now = System.currentTimeMillis();
                HashSet<String> keysForRemove = new HashSet<String>();
                for (Map.Entry<String, Long> entry : this.banStartTimes.entrySet()) {
                    long banStart = entry.getValue();
                    if (now - banStart <= this.banTime) continue;
                    keysForRemove.add(entry.getKey());
                }
                this.banStartTimes.keySet().removeAll(keysForRemove);
                keysForRemove.clear();
                for (Map.Entry<String, Object> entry : this.rejectCounters.entrySet()) {
                    if (((RequestCounter)entry.getValue()).getCount() != 0) continue;
                    keysForRemove.add(entry.getKey());
                }
                this.rejectCounters.keySet().removeAll(keysForRemove);
                if (log.isDebugEnabled()) {
                    log.debug("Antispam ban size: " + this.banStartTimes.size() + "; reject stat size: " + this.rejectCounters.size());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Antispam.sleep((long)60000L);
            }
            catch (Exception exception) {}
        }
    }

    public int getBanCount() {
        return this.banStartTimes.size();
    }

    public Collection<String> getBanList() {
        return this.banStartTimes.keySet();
    }

    public boolean removeBan(String key) {
        return this.banStartTimes.remove(key) != null;
    }
}

