/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.converters.BGConverter;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class ConvertContractGroupsToLabels
implements BGConverter {
    private static final Logger logger = LogManager.getLogger((String)ConvertContractGroupsToLabels.class.getSimpleName());
    private static final String NEED_CONVERT_KEY = "convert_groups_to_labels_was_runned";
    private static final String ENABLE_CONVERT = "converter.groups.to.labels";

    @Override
    public void runConverter(Connection connection) {
        boolean enableConvert = Setup.getSetup().getBoolean(ENABLE_CONVERT, true);
        if (!enableConvert) {
            logger.info("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f \u0432 \u043c\u0435\u0442\u043a\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438!");
            return;
        }
        boolean alreadyBeenRunned = Utils.maskBlank((String)ServerUtils.getSetupValue(connection, NEED_CONVERT_KEY), (String)"0").equals("0");
        if (alreadyBeenRunned) {
            logger.info("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f \u0432 \u043c\u0435\u0442\u043a\u0438 \u0443\u0436\u0435 \u0431\u044b\u043b\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0440\u0430\u043d\u0435\u0435!");
            return;
        }
        try {
            logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0433\u0440\u0443\u043f\u043f \u0438 \u043c\u0435\u0442\u043e\u043a");
            ContractLabelManager contractLabelManager = new ContractLabelManager(connection);
            contractLabelManager.syncLabelAndGroupDirectory();
            contractLabelManager.syncLabelAndGroupContract(0);
        }
        catch (BGException ex) {
            logger.error((Object)ex);
        }
        ServerUtils.setSetupValue(connection, NEED_CONVERT_KEY, "1");
        logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f \u0432 \u043c\u0435\u0442\u043a\u0438.");
    }
}

