/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RoleItem;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.PermissionKitDao;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;

public class RoleDao
extends AbstractIdDao<Role> {
    private PermissionKitDao permissionKitDao;

    public RoleDao(Connection con) {
        super(con, 0, "role");
        this.permissionKitDao = new PermissionKitDao(con);
    }

    public List<Role> list(String filter, String orderBy, Object ... params) throws BGException {
        return super.list(null, null, new Object[0]);
    }

    public List<RoleItem> roleItemList(boolean initChilds) throws BGException {
        ArrayList<RoleItem> result = new ArrayList<RoleItem>();
        String query = "SELECT r.id, r.title, m.title, childs FROM " + this.tableName + " AS r LEFT JOIN bgs_menu AS m ON m.id=r.menu_id";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            HashMap<Integer, List> roleChildIds = new HashMap<Integer, List>();
            while (rs.next()) {
                int roleId = rs.getInt("r.id");
                RoleItem roleItem = new RoleItem(roleId, rs.getString("r.title"));
                roleItem.setMenuTitle(rs.getString("m.title"));
                result.add(roleItem);
                if (!initChilds) continue;
                roleChildIds.put(roleId, Utils.toIntegerList((String)rs.getString("childs")));
            }
            if (initChilds) {
                for (RoleItem roleItem : result) {
                    List childIds = (List)roleChildIds.get(roleItem.getId());
                    if (childIds.isEmpty()) continue;
                    result.stream().filter(i -> childIds.contains(i.getId())).forEach(i -> roleItem.getChildren().add((RoleItem)((Object)i)));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected Role getFromRS(ResultSet rs) throws SQLException, BGException {
        return Role.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setMenuId(rs.getInt("menu_id")).setPermissionKits(this.permissionKitDao.getByIds(Utils.toIntegerList((String)rs.getString("permission_kit_ids")))).setChildren(this.loadChildren(Utils.toIntegerList((String)rs.getString("childs")))).build();
    }

    private List<Role> loadChildren(List<Integer> childIds) throws BGException {
        ArrayList<Role> childs = new ArrayList<Role>();
        if (childIds == null || childIds.isEmpty()) {
            return childs;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + Utils.toString(childIds) + ")";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                childs.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return childs;
    }

    protected void updateImpl(Role role) throws BGException, SQLException {
        if (role == null) {
            return;
        }
        boolean update = role.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, menu_id=?, childs=?, permission_kit_ids=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, role.getTitle());
            ps.setInt(index++, role.getMenuId());
            ps.setString(index++, Utils.toString((Iterable)role.getChildren().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList())));
            String permissionKitIds = "";
            if (Utils.notEmptyCollection(role.getPermissionKits())) {
                permissionKitIds = Utils.toString((Iterable)role.getPermissionKits().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()), (String)",");
            }
            ps.setString(index++, permissionKitIds);
            if (update) {
                ps.setInt(index, role.getId());
            }
            ps.executeUpdate();
            if (!update) {
                role.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }
}

