/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffMasterData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractTariffMasterDataMode;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffMasterDataHandler;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class ContractTariffMasterDataDefaultHandler
implements ContractTariffMasterDataHandler {
    private Contract contract = null;
    private List<Integer> contractLabelIds = new ArrayList<Integer>();
    private int contractId;
    private int contractTariffId;
    private int userId;
    private List<IdTitle> tariffs = null;
    private List<IdTitle> tariffGroups = null;

    @Override
    public ContractTariffMasterData get(int contractId, ContractTariffMasterDataMode masterDataMode, int contractTariffId, int userId) throws BGException, BGMessageException {
        this.contractId = contractId;
        this.contractTariffId = contractTariffId;
        this.userId = userId;
        ServerContext context = (ServerContext)ServerContext.get();
        try (ContractDao contractDao = new ContractDao(context.getConnection(), userId);){
            this.contract = (Contract)contractDao.get(contractId);
            this.contractLabelIds = new ContractLabelManager(context.getConnection()).getContractLabelIds(contractId);
        }
        switch (masterDataMode) {
            case NEW: {
                return this.tariffNew(contractId);
            }
            case EDIT: {
                return this.tariffEdit(contractTariffId);
            }
            case COPY: {
                return this.tariffCopy(contractTariffId);
            }
            case CHANGE: {
                return this.tariffChange(contractTariffId);
            }
        }
        return null;
    }

    @Override
    public ContractTariffMasterData tariffNew(int contractId) throws BGException, BGMessageException {
        ContractTariff contractTariff = new ContractTariff().setContractId(contractId).setPeriod(new Period(LocalDate.now(), null));
        return new ContractTariffMasterData().setContractTariff(contractTariff).setTariffs(this.getTariffs()).setTariffGroups(this.getTariffGroups());
    }

    @Override
    public ContractTariffMasterData tariffEdit(int contractTariffId) throws BGException, BGMessageException {
        return new ContractTariffMasterData().setContractTariff(this.contractTariff(contractTariffId)).setTariffs(this.getTariffs()).setTariffGroups(this.getTariffGroups());
    }

    @Override
    public ContractTariffMasterData tariffCopy(int contractTariffId) throws BGException, BGMessageException {
        ContractTariff newContractTariff = this.contractTariff(contractTariffId).setPeriod(new Period(LocalDate.now(), null)).setReplacedFromContractTariffId(contractTariffId);
        newContractTariff.setId(0);
        return new ContractTariffMasterData().setContractTariff(newContractTariff).setTariffs(this.getTariffs()).setTariffGroups(this.getTariffGroups());
    }

    @Override
    public ContractTariffMasterData tariffChange(int contractTariffId) throws BGException, BGMessageException {
        ContractTariff newContractTariff = this.contractTariff(contractTariffId).setComment("").setPeriod(new Period(LocalDate.now(), null)).setReplacedFromContractTariffId(contractTariffId);
        newContractTariff.setId(0);
        return new ContractTariffMasterData().setContractTariff(newContractTariff).setTariffs(this.getTariffs()).setTariffGroups(this.getTariffGroups());
    }

    protected ContractTariff contractTariff(int contractTariffId) throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        try (ContractTariffDao contractTariffDao = new ContractTariffDao(context.getConnection());){
            ContractTariff contractTariff = (ContractTariff)contractTariffDao.get(contractTariffId);
            return contractTariff;
        }
    }

    @Deprecated
    protected List<TariffPlan> contractTariffs() throws BGException {
        return this.tariffPlans();
    }

    protected List<TariffPlan> tariffPlans() throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        try (TariffPlanDao tariffDao = new TariffPlanDao(context.getConnection());){
            List<TariffPlan> list = tariffDao.list();
            return list;
        }
    }

    protected List<TariffGroup> contractTariffGroups() throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        try (TariffGroupDao tariffDao = new TariffGroupDao(context.getConnection());){
            List<TariffGroup> list = tariffDao.list();
            return list;
        }
    }

    protected IdTitle getTariffGroupDefault() {
        return new IdTitle(-1, "<\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e>");
    }

    protected IdTitle getTariffGroupNoSet() {
        return new IdTitle(0, "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>");
    }

    protected List<IdTitle> getTariffGroups() throws BGException, BGMessageException {
        if (this.tariffGroups == null) {
            this.tariffGroups = new ArrayList<IdTitle>(this.contractTariffGroups().stream().map(IdTitle::toIdTitle).toList());
            this.tariffGroups.add(0, this.getTariffGroupNoSet());
            this.tariffGroups.add(0, this.getTariffGroupDefault());
        }
        return this.tariffGroups;
    }

    protected List<IdTitle> getTariffs() throws BGException, BGMessageException {
        if (this.tariffs == null) {
            int tariffPlanId = Optional.ofNullable(this.contractTariff(this.contractTariffId)).map(a -> a.getTariffPlanId()).orElse(0);
            this.tariffs = new ArrayList<IdTitle>(this.tariffPlans().stream().filter(a -> a.getId() != tariffPlanId).filter(a -> a.isUsed()).filter(a -> a.getFilterFace() == 0 || a.getFilterFace() - 1 == this.contract.getPersonType()).filter(a -> this.checkContractLabel(a.getFilterContractLabelIds(), this.contractLabelIds)).map(IdTitle::toIdTitle).toList());
            if (this.contractTariffId > 0) {
                this.tariffs.add(0, this.tariffPlans().stream().filter(a -> a.getId() == tariffPlanId).findFirst().map(IdTitle::toIdTitle).orElse(new IdTitle(this.contractTariffId, "??? [#" + tariffPlanId + "]")));
            }
        }
        return this.tariffs;
    }

    protected boolean checkContractLabel(List<Integer> tariffContractLabelIds, List<Integer> contractLabelIds) {
        if (tariffContractLabelIds == null || tariffContractLabelIds.isEmpty()) {
            return true;
        }
        if (contractLabelIds == null || contractLabelIds.isEmpty()) {
            return false;
        }
        for (int tariflId : tariffContractLabelIds) {
            if (!contractLabelIds.contains(tariflId)) continue;
            return true;
        }
        return false;
    }

    protected int getContractId() {
        return this.contractId;
    }

    protected Contract getContract() {
        return this.contract;
    }

    protected List<Integer> getContractLabelIds() {
        return this.contractLabelIds;
    }

    protected int getTariffId() {
        return this.contractTariffId;
    }

    protected int getUserId() {
        return this.userId;
    }
}

