/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractFace;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractMode;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel_Mode;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ContractSubPanelModeFaceBase
extends ContractSubPanel {
    protected JPanel parentPanel;
    protected int selectedIndex = 0;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGUComboBox<IdTitle> comboBox = new BGUComboBox();
    private BGButton aplButton = new BGButton();
    private TableModel tableModel = new TableModel(TableModel.class.getName());
    private BGUTable table = new BGUTable((javax.swing.table.TableModel)((Object)this.tableModel));

    public ContractSubPanelModeFaceBase() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pagePanel.setKey(ContractSubPanel_Mode.class.getName());
    }

    private void jbInit() throws Exception {
        this.aplButton.setText("OK");
        this.aplButton.setActionCommand("ok");
        this.aplButton.addActionListener(e -> this.aplButton_actionPerformed(e));
        this.pagePanel.setBorder((Border)new BGTitleBorder(" \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 "));
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.setData();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.getStatePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getStatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getModeFacePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getModeFacePanel() {
        this.comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.aplButton.setEnabled(this.comboBox.getSelectedIndex() > 0 && this.comboBox.getSelectedIndex() != this.selectedIndex);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(this.getBorderName()));
        panel.add((Component)this.comboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.aplButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    protected String getBorderName() {
        return null;
    }

    protected String getTypePanel() {
        return null;
    }

    protected List<IdTitle> getItems() {
        return null;
    }

    protected String getLoadAction() {
        return "ContractModeFaceBase";
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.getLoadAction());
        request.setContractId(this.getContractId());
        request.setPageIndex(this.pagePanel.getPageIndex());
        request.setPageSize(this.pagePanel.getPageSize());
        request.setAttribute("view", "0");
        request.setAttribute("type", this.getTypePanel());
        this.setDocument(this.getDocument(request));
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element tableNode = XMLUtils.selectElement((Node)doc, (String)"//table");
            ArrayList datas = new ArrayList();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            XMLUtils.selectElements((Node)doc, (String)"//table/data/row").forEach(e -> {
                RowData rowData = new RowData();
                rowData.date = TimeUtils.parseDate((String)e.getAttribute("date"), (DateFormat)dateFormat);
                rowData.user = e.getAttribute("user");
                rowData.value = e.getAttribute("value");
                datas.add(rowData);
            });
            this.tableModel.setData(datas);
            this.comboBox.setData(this.getItems());
            if (this.getTypePanel().equals("face")) {
                if ("0".equals(XMLUtils.getAttribute((Element)tableNode, (String)"face", (String)"0"))) {
                    this.comboBox.setSelectedIndex(1);
                } else {
                    this.comboBox.setSelectedIndex(2);
                }
            } else if ("0".equals(XMLUtils.getAttribute((Element)tableNode, (String)"mode", (String)"0"))) {
                this.comboBox.setSelectedIndex(2);
            } else {
                this.comboBox.setSelectedIndex(1);
            }
            this.selectedIndex = this.comboBox.getSelectedIndex();
            this.aplButton.setEnabled(false);
            this.pagePanel.setPageCount(tableNode);
        }
    }

    private void aplButton_actionPerformed(ActionEvent e) {
        IdTitle selectItem = (IdTitle)this.comboBox.getSelectedItem();
        if (this.getTypePanel().equals("face")) {
            if (selectItem.getId() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0438\u0446\u043e");
                return;
            }
            if (this.doButton()) {
                try {
                    ((ContractService)this.getContext().getWebService(ContractService.class, 0)).contractFaceUpdate(this.getContractId(), selectItem.getId() == 1 ? ContractFace.FIZIC : ContractFace.URIC);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            } else {
                this.comboBox.setSelectedIndex(this.selectedIndex);
            }
        } else {
            if (selectItem.getId() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0436\u0438\u043c");
                return;
            }
            try {
                ((ContractService)this.getContext().getWebService(ContractService.class, 0)).contractModeUpdate(this.getContractId(), selectItem.getId() == 1 ? ContractMode.DEBET : ContractMode.CREDIT);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
    }

    protected boolean doButton() {
        return true;
    }

    protected String getTableHeader() {
        return "";
    }

    public class TableModel
    extends BGTableModel<RowData> {
        public TableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 150, 150, 150, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 250, 250, 250, "user", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn(ContractSubPanelModeFaceBase.this.getTableHeader(), 150, -1, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class RowData {
        Date date;
        String user;
        String value;

        public Date getDate() {
            return this.date;
        }

        public String getUser() {
            return this.user;
        }

        public String getValue() {
            return this.value;
        }
    }
}

