/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.runtime;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList2;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.ContractTariffOptionChangedEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.ref.ConcurrentReferenceHashMap;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;

public class ContractRuntimeMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final Date initialDate;
    private final boolean realtime;
    private final ConcurrentReferenceHashMap<Integer, ContractRuntime> contractRuntimeMap = new ConcurrentReferenceHashMap(512, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private long fetchedGroups = 0L;

    public ContractRuntimeMap(Date initialDate) throws BGException {
        this(initialDate, true);
    }

    public ContractRuntimeMap(Date initialDate, boolean realtime) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing contract runtime map");
        }
        this.initialDate = initialDate;
        this.realtime = realtime;
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug("Initialization completed");
        }
    }

    public static ContractRuntimeMap getInstance() {
        return InstanceHolder.instance;
    }

    private void init() throws BGException {
        if (this.realtime) {
            this.writeLock(this.writeLock);
            try {
                EventProcessor ep = EventProcessor.getInstance();
                ep.addListener(this, ContractTariffOptionChangedEvent.class);
                ep.addListener(this, ProductPeriodModifiedEvent.class);
                ep.addListener(this, ContractStatusChangedTopicEvent.class);
                ep.addListener(this, ContractStatusModifiedEvent.class);
                ep.addListener(this, ContractModifiedEvent.class);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public ContractRuntime getContractRuntime(ConnectionSet connectionSet, Integer contractId) throws BGException {
        return this.getContractRuntime(connectionSet.getConnection(), contractId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractRuntime getContractRuntime(Connection con, Integer contractId) throws BGException {
        ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)contractId));
        if (runtime == null) {
            ContractRuntime newRuntime;
            block27: {
                try (ContractManager contractManager = new ContractManager(con);){
                    if (this.initialDate != null) {
                        try (ProductPeriodDao productPeriodDao = new ProductPeriodDao(con, 0);
                             ContractStatusDao contractStatusDao = new ContractStatusDao(con);
                             ContractTariffOptionDao contractTariffOptionDao = new ContractTariffOptionDao(con);){
                            newRuntime = this.newRuntime(contractManager, contractStatusDao, contractTariffOptionDao, productPeriodDao, contractId);
                            break block27;
                        }
                    }
                    newRuntime = this.newRuntime(contractManager, null, null, null, contractId);
                }
            }
            if (newRuntime != null) {
                try {
                    this.readLock.lock();
                    runtime = (ContractRuntime)((Object)this.contractRuntimeMap.putIfAbsent((Object)contractId, (Object)newRuntime));
                    if (runtime == null) {
                        runtime = newRuntime;
                    }
                }
                finally {
                    this.readLock.unlock();
                }
            }
        }
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractRuntime getContractRuntime(ContractManager contractManager, ContractStatusDao contractStatusDao, ContractTariffOptionDao contractTariffOptionDao, ProductPeriodDao productPeriodDao, Integer contractId) throws BGException {
        ContractRuntime newRuntime;
        ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)contractId));
        if (runtime == null && (newRuntime = this.newRuntime(contractManager, contractStatusDao, contractTariffOptionDao, productPeriodDao, contractId)) != null) {
            try {
                this.readLock.lock();
                runtime = (ContractRuntime)((Object)this.contractRuntimeMap.putIfAbsent((Object)contractId, (Object)newRuntime));
                if (runtime == null) {
                    runtime = newRuntime;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return runtime;
    }

    private ContractRuntime newRuntime(ContractManager contractManager, ContractStatusDao contractStatusDao, ContractTariffOptionDao contractTariffOptionDao, ProductPeriodDao productPeriodDao, int contractId) throws BGException {
        ContractRuntime runtime = new ContractRuntime(contractId);
        bitel.billing.server.contract.bean.Contract contract = contractManager.getContractById(contractId);
        if (contract == null) {
            logger.warn("Contract ID#{} not found", (Object)contractId);
            return null;
        }
        int superContractId = contract.getSuperId();
        if (superContractId > 0) {
            if (contract.getSubMode() == 0 && superContractId != contractId) {
                ContractRuntime superContractRuntime = this.getContractRuntime(contractManager, contractStatusDao, contractTariffOptionDao, productPeriodDao, superContractId);
                runtime.setSuperContract(superContractRuntime);
            }
        } else if (contract.isSuper()) {
            runtime.setDependSubContractIds(contract.getDependSubList());
            runtime.setSuper(true);
        }
        runtime.contractTitle = contract.getTitle();
        runtime.domainId = contract.getDomainId();
        runtime.contractGroups = contract.getGroups();
        runtime.contractMode = contract.getBalanceMode();
        runtime.contractStatus = contract.getStatus();
        if (this.initialDate != null) {
            List<ContractStatus> statusList = contractStatusDao.getStatusList(contractId, this.initialDate);
            runtime.load(statusList, contractTariffOptionDao, productPeriodDao, this.initialDate, new GregorianCalendar());
        }
        return runtime;
    }

    @Override
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.writeLock.lock();
        try {
            logger.info("Taked event: {}", (Object)e);
            if (e instanceof ContractStatusChangedTopicEvent) {
                this.onContractStatusChanged((ContractStatusChangedTopicEvent)e);
            } else if (e instanceof ContractStatusModifiedEvent) {
                this.onContractStatusModified((ContractStatusModifiedEvent)e);
            } else if (e instanceof ContractTariffOptionChangedEvent) {
                this.onContractTariffOptionChanged((ContractTariffOptionChangedEvent)e);
            } else if (e instanceof ProductPeriodModifiedEvent) {
                this.onProductPeriodModified((ProductPeriodModifiedEvent)e);
            } else if (e instanceof ContractModifiedEvent) {
                this.onContractModified((ContractModifiedEvent)e, ctx);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void onContractModified(ContractModifiedEvent contractModifiedEvent, EventListenerContext ctx) throws BGException {
        this.updateContractRuntime(ctx, contractModifiedEvent.getContractId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContractRuntime(ServerContext ctx, int contractId) throws BGException {
        ContractRuntime runtime;
        if (logger.isDebugEnabled()) {
            logger.debug("Updating runtime for contract ID#{}", (Object)contractId);
        }
        if ((runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)contractId))) == null) {
            return;
        }
        Connection con = ctx.getConnection();
        runtime.internalLock();
        try {
            bitel.billing.server.contract.bean.Contract contract;
            try (ContractManager contractManager = new ContractManager(con);){
                contract = contractManager.getContractById(contractId);
            }
            if (contract == null) {
                logger.error("Contract ID#{} is absent in DB", (Object)contractId);
                return;
            }
            runtime.contractTitle = contract.getTitle();
            runtime.domainId = contract.getDomainId();
            runtime.contractGroups = contract.getGroups();
            runtime.contractMode = contract.getBalanceMode();
            runtime.contractStatus = contract.getStatus();
            runtime.moduleIds = null;
            int superContractId = contract.getSuperId();
            if (superContractId > 0) {
                if (superContractId != runtime.contractId) {
                    if (contract.getSubMode() == 0) {
                        ContractRuntime superContractRuntime = this.getContractRuntime(ctx.getConnectionSet(), (Integer)superContractId);
                        runtime.setSuperContract(superContractRuntime);
                    } else {
                        runtime.independentSuperContractId = superContractId;
                    }
                }
                runtime.setDependSubContractIds(null);
            } else if (contract.isSuper()) {
                runtime.setDependSubContractIds(contract.getDependSubList());
                runtime.setSuper(true);
            } else {
                runtime.setDependSubContractIds(null);
            }
        }
        finally {
            runtime.internalUnlock();
            if (logger.isDebugEnabled()) {
                logger.debug("Updating completed");
            }
        }
    }

    private void onContractStatusChanged(ContractStatusChangedTopicEvent e) {
        ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)e.getContractId()));
        if (runtime == null) {
            return;
        }
        ContractStatus contractStatus = e.getStatus();
        runtime.contractStatus = contractStatus.getStatus();
        if (logger.isDebugEnabled()) {
            logger.debug("New contract status {}", (Object)contractStatus.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContractStatusModified(ContractStatusModifiedEvent e) {
        ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)e.getContractId()));
        if (runtime == null) {
            return;
        }
        ContractStatus oldContractStatus = e.getOldContractStatus();
        ContractStatus newContractStatus = e.getNewContractStatus();
        GregorianCalendar utilCalendar = new GregorianCalendar();
        runtime.internalLock();
        try {
            ContractStatusList2 contractStatuses;
            long millisTo;
            long millisFrom;
            if (oldContractStatus != null) {
                millisFrom = TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (Date)oldContractStatus.getDateFrom());
                millisTo = TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (Date)oldContractStatus.getDateTo());
                contractStatuses = runtime.contractStatuses;
                if (contractStatuses != null) {
                    runtime.contractStatuses = contractStatuses.remove(oldContractStatus.getId(), millisFrom, millisTo, oldContractStatus.getStatus());
                }
            }
            if (newContractStatus != null) {
                millisFrom = TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (Date)newContractStatus.getDateFrom());
                millisTo = TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (Date)newContractStatus.getDateTo());
                contractStatuses = runtime.contractStatuses;
                if (contractStatuses != null) {
                    runtime.contractStatuses = contractStatuses.update(newContractStatus.getId(), millisFrom, millisTo, newContractStatus.getStatus());
                }
            }
        }
        finally {
            runtime.internalUnlock();
        }
        if (logger.isDebugEnabled() && runtime.contractStatuses != null) {
            logger.debug("New contract status list:\n" + runtime.contractStatuses);
        }
    }

    private void onContractTariffOptionChanged(ContractTariffOptionChangedEvent e) {
        switch (e.getState()) {
            case 1: {
                this.onTariffOptionActivated(e, false);
                break;
            }
            case 2: {
                this.onTariffOptionDeactivated(e);
                break;
            }
            case 3: {
                this.onTariffOptionActivated(e, true);
                break;
            }
            case 4: {
                this.onTariffOptionDeleted(e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTariffOptionActivated(ContractTariffOptionChangedEvent e, boolean reactivated) {
        ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)e.getContractId()));
        if (runtime != null) {
            long timeTo;
            ContractTariffOption tariffOption = e.getContractTariffOption();
            Date from = tariffOption.getTimeFrom();
            Date to = tariffOption.getTimeTo();
            long timeFrom = from != null ? from.getTime() : 0L;
            long l = timeTo = to != null ? to.getTime() - 1L : 0L;
            if (logger.isDebugEnabled()) {
                logger.debug("Tariff option was activated: " + tariffOption.getOptionId() + " " + TimeUtils.format((Date)new Date(timeFrom), (String)"dd.MM.yyyy HH:mm:ss.S") + " - " + TimeUtils.format((Date)new Date(timeTo), (String)"dd.MM.yyyy HH:mm:ss.S"));
            }
            runtime.internalLock();
            try {
                ContractTariffOptionList tariffOptions = runtime.tariffOptions;
                if (tariffOptions != null) {
                    runtime.tariffOptions = reactivated ? tariffOptions.update(tariffOption.getOptionId(), tariffOption.getId(), timeFrom, timeTo) : tariffOptions.add(tariffOption.getOptionId(), tariffOption.getId(), timeFrom, timeTo);
                }
            }
            finally {
                runtime.internalUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTariffOptionDeactivated(ContractTariffOptionChangedEvent e) {
        ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)e.getContractId()));
        if (runtime != null) {
            ContractTariffOption tariffOption = e.getContractTariffOption();
            Date from = tariffOption.getTimeFrom();
            Date to = tariffOption.getTimeTo();
            long timeFrom = from != null ? from.getTime() : 0L;
            long timeTo = to != null ? to.getTime() - 1L : 0L;
            runtime.internalLock();
            try {
                ContractTariffOptionList tariffOptions = runtime.tariffOptions;
                if (tariffOptions != null) {
                    runtime.tariffOptions = tariffOptions.update(tariffOption.getOptionId(), tariffOption.getId(), timeFrom, timeTo);
                }
            }
            finally {
                runtime.internalUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTariffOptionDeleted(ContractTariffOptionChangedEvent e) {
        ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)e.getContractId()));
        if (runtime != null) {
            ContractTariffOption tariffOption = e.getContractTariffOption();
            Date from = tariffOption.getTimeFrom();
            Date to = tariffOption.getTimeTo();
            long timeFrom = from != null ? from.getTime() : 0L;
            long timeTo = to != null ? to.getTime() - 1L : 0L;
            runtime.internalLock();
            try {
                ContractTariffOptionList tariffOptions = runtime.tariffOptions;
                if (tariffOptions != null) {
                    runtime.tariffOptions = tariffOptions.remove(tariffOption.getOptionId(), tariffOption.getId(), timeFrom, timeTo);
                }
            }
            finally {
                runtime.internalUnlock();
            }
        }
    }

    private void onProductPeriodModified(ProductPeriodModifiedEvent e) {
        ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)e.getContractId()));
        if (runtime == null) {
            return;
        }
        runtime.internalLock();
        try {
            runtime.updateProductPeriods(e);
        }
        finally {
            runtime.internalUnlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prefetch(ConnectionSet connectionSet, long groups) throws BGException {
        logger.info("Starting prefetching ContractRuntimeMap.");
        long time = System.currentTimeMillis();
        if (groups != 0L || this.fetchedGroups != 0L) {
            if (groups == 0L) {
                groups = -1L;
            }
            if ((groups ^= this.fetchedGroups) == 0L) {
                return;
            }
        }
        ContractDao contractDao = new ContractDao(connectionSet.getConnection(), 0);
        ContractFilters contractFilters = ContractFilters.builder().setFc(-1).setGroupMask(groups).setSubContracts(true).build();
        List<Contract> contractList = contractDao.list(contractFilters, null, "scid", null);
        for (Contract contract : contractList) {
            int contractId = contract.getId();
            if (this.contractRuntimeMap.containsKey((Object)contractId)) continue;
            ContractRuntime newRuntime = new ContractRuntime(contract.getId());
            int superContractId = contract.getSuperCid();
            if (superContractId > 0) {
                if (contract.getBalanceSubMode() == 0 && superContractId != contractId) {
                    ContractRuntime superContractRuntime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)superContractId));
                    if (superContractRuntime == null) continue;
                    newRuntime.setSuperContract(superContractRuntime);
                }
            } else if (contract.isSuper()) {
                newRuntime.setDependSubContractIds(contract.getDependSubList());
            }
            newRuntime.contractTitle = contract.getTitle();
            newRuntime.domainId = contract.getDomainId();
            newRuntime.contractGroups = contract.getGroups();
            newRuntime.contractMode = contract.getBalanceMode();
            newRuntime.contractStatus = contract.getStatus();
            newRuntime.moduleIds = null;
            this.readLock.lock();
            try {
                this.contractRuntimeMap.putIfAbsent((Object)contractId, (Object)newRuntime);
            }
            finally {
                this.readLock.unlock();
            }
        }
        contractList.clear();
        contractDao.close();
        ContractModuleManager contractModuleManager = new ContractModuleManager(connectionSet.getConnection());
        for (Map.Entry<Integer, Set<Integer>> e : contractModuleManager.getContractModuleMap().entrySet()) {
            ContractRuntime runtime = (ContractRuntime)((Object)this.contractRuntimeMap.get((Object)e.getKey()));
            if (runtime == null || runtime.isModuleIdsFetched()) continue;
            runtime.setModuleIds(e.getValue());
        }
        this.fetchedGroups = groups == 0L ? -1L : (this.fetchedGroups |= groups);
        logger.info("Prefetching ContractRuntimeMap done for " + (System.currentTimeMillis() - time) + " ms.");
    }

    private void writeLock(ReentrantReadWriteLock.WriteLock writeLock) throws BGException {
        if (this.lock.getReadHoldCount() > 0) {
            logger.error("lock.getReadHoldCount() > 0");
            if (this.lock.getWriteHoldCount() == 0) {
                logger.error("lock.getWriteHoldCount() == 0");
                throw new BGException("lock.getReadHoldCount() > 0");
            }
        }
        writeLock.lock();
    }

    static class InstanceHolder {
        static final ContractRuntimeMap instance;

        InstanceHolder() {
        }

        static {
            ContractRuntimeMap instance0 = null;
            try {
                instance0 = new ContractRuntimeMap(null, true);
            }
            catch (BGException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            instance = instance0;
        }
    }
}

