/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.task;

import bitel.billing.server.script.global.bean.GlobalScriptManager;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.kernel.script.common.service.GlobalScriptService;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class GlobalScriptTimer
extends TaskBase {
    private static final int TYPE_BSH = 0;
    private static final int TYPE_JAVA = 1;
    private String taskIds;
    private int type;
    private boolean autoCommit = true;

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432 \u043f\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0443.";
    }

    @Override
    protected boolean initTask() {
        this.taskIds = this.taskSetup.get("task.ids", this.taskSetup.get("tids", null));
        this.type = this.taskSetup.getInt("task.type", this.taskSetup.getInt("type", 1));
        this.autoCommit = this.taskSetup.getBoolean("autocommit", true);
        return Utils.notBlankString((String)this.taskIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void executeTask() {
        ServerContext context = (ServerContext)((Object)ServerContext.get(ServerContext.class));
        ConnectionSet connectionSet = context.getConnectionSet();
        boolean oldAutoCommit = connectionSet.getAutoCommit();
        try {
            connectionSet.setAutoCommit(this.autoCommit);
            switch (this.type) {
                case 1: {
                    this.executeJava(context, (ParameterMap)this.taskSetup);
                    return;
                }
                default: {
                    this.executeBsh(connectionSet);
                    return;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            if (!this.autoCommit) {
                try {
                    connectionSet.commit();
                }
                catch (BGException e) {
                    e.printStackTrace();
                }
            }
            connectionSet.setAutoCommit(oldAutoCommit);
        }
    }

    private void executeBsh(ConnectionSet connectionSet) {
        GlobalScriptManager globalScriptManager = new GlobalScriptManager(connectionSet);
        List taskIds = Utils.toIntegerList((String)this.taskIds);
        for (Integer id : taskIds) {
            try {
                globalScriptManager.executeGlobalScript(id);
            }
            catch (Exception e) {
                this.getLogger().error((Object)e);
            }
        }
    }

    private void executeJava(ServerContext context, ParameterMap params) throws BGException {
        GlobalScriptService globalScriptService = ServiceFactory.newService(context, GlobalScriptService.class, 0);
        List taskIds = Utils.toIntegerList((String)this.taskIds);
        for (Integer id : taskIds) {
            globalScriptService.executeGlobalScriptParams(id, params);
        }
    }
}

