/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.groovy;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyShell;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import ru.bitel.common.groovy.MetaClassDelegate;

public abstract class GroovyMacro {
    private Logger logger = LogManager.getLogger();
    private static final GroovyShell SHELL = GroovyMacro.newShell();
    private static final ReentrantLock LOCK = new ReentrantLock();
    private boolean string;
    private final ConcurrentMap<String, Closure<?>> macroMap = new ConcurrentHashMap();
    private final ThreadLocal<Object[]> globalArgsLocal = new ThreadLocal();
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Pattern quotePattern = Pattern.compile("\\\"");

    public GroovyMacro(boolean string) {
        this.string = string;
    }

    private static GroovyShell newShell() {
        ImportCustomizer imports = new ImportCustomizer().addStaticStars(new String[]{"java.lang.Math"});
        SecureASTCustomizer secure = new SecureASTCustomizer();
        secure.setClosuresAllowed(true);
        secure.setImportsWhitelist(Collections.singletonList("java.lang.Math"));
        secure.setStaticImportsWhitelist(Collections.emptyList());
        secure.setStaticStarImportsWhitelist(Collections.singletonList("java.lang.Math"));
        secure.setTokensWhitelist(Arrays.asList(200, 201, 202, 203, 205, 206, 250, 260, 123, 120, 124, 125, 126, 127, 100, 1103, 164, 168, 162, 166, 1107, 601, 611, 610, 561, 562, 560, 572, 576, 577, 574, 578));
        secure.setConstantTypesClassesWhiteList(Arrays.asList(Object[].class, Object.class, String.class, Integer.class, Float.class, Long.class, Double.class, BigDecimal.class, Boolean.class, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE));
        secure.setReceiversClassesWhiteList(Arrays.asList(Object[].class, Object.class, String.class, Integer.class, Float.class, Long.class, Double.class, BigDecimal.class, Boolean.class, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE));
        CompilerConfiguration config = new CompilerConfiguration();
        config.addCompilationCustomizers(new CompilationCustomizer[]{imports, secure});
        ClassLoader classLoader = null;
        GroovyShell shell = classLoader == null ? new GroovyShell(config) : new GroovyShell(classLoader, config);
        return shell;
    }

    protected abstract Object invoke(String var1, Object[] var2);

    protected Object[] getGlobalArgs() {
        return this.globalArgsLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String macro, Object ... args) {
        Closure closure = this.macroMap.computeIfAbsent(macro, a -> this.parse((String)a));
        Object[] parent = this.globalArgsLocal.get();
        this.globalArgsLocal.set(args);
        try {
            Object object = closure.call(args);
            return object;
        }
        catch (Throwable e) {
            this.logger.error("macro = " + macro);
            if (args != null) {
                Stream.iterate(0, i -> i + 1).limit(args.length).forEach(i -> this.logger.error("args[" + i + "]=" + args[i]));
            }
            this.logger.error((Object)e);
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            if (parent != null) {
                this.globalArgsLocal.set(parent);
            } else {
                this.globalArgsLocal.remove();
            }
        }
    }

    public void validate(String macro) {
        this.parse(macro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Closure<?> parse(String macro) {
        Script script;
        String macroMethodName = "macroGClosure" + counter.incrementAndGet();
        macro = quotePattern.matcher(macro).replaceAll("\\\\\"");
        LOCK.lock();
        try {
            script = this.string ? SHELL.parse(macroMethodName + " =  { Object[] globalArgs -> \"" + macro + "\" }") : SHELL.parse(macroMethodName + " =  { Object[] globalArgs -> " + macro + " }");
        }
        finally {
            LOCK.unlock();
        }
        script.setBinding((Binding)new MacroBinding(script));
        script.run();
        Closure closure = (Closure)script.getBinding().getVariable(macroMethodName);
        MetaClass metaClass = closure.getMetaClass();
        closure.setMetaClass((MetaClass)new MacroMetaClassDelegate(metaClass));
        return closure;
    }

    protected List resolveConstructorArguments(Object[] args, int start, int end) {
        Object[] constructorArgs = this.subarray(args, start, end);
        this.filterGStringReferences(constructorArgs);
        return Arrays.asList(constructorArgs);
    }

    protected Class<?>[] resolveConstructorClasses(List list) {
        ArrayList result = new ArrayList();
        for (Object o : list) {
            result.add(o.getClass());
        }
        Class[] res = new Class[list.size()];
        return result.toArray(res);
    }

    protected void filterGStringReferences(Object[] constructorArgs) {
        for (int i = 0; i < constructorArgs.length; ++i) {
            Object constructorArg = constructorArgs[i];
            if (!(constructorArg instanceof GString)) continue;
            constructorArgs[i] = constructorArg.toString();
        }
    }

    protected Object[] subarray(Object[] args, int i, int j) {
        assert (j <= args.length) : "Upper bound can't be greater than array length";
        Object[] b = new Object[j - i];
        int n = 0;
        int k = i;
        while (k < j) {
            b[n] = args[k];
            ++k;
            ++n;
        }
        return b;
    }

    void addNamedMacro(String name, String macro) {
        Closure<?> closure = this.parse(macro);
        this.macroMap.put(name, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object evalNamedMacro(String name, Object ... args) {
        Closure closure = (Closure)this.macroMap.get(name);
        this.globalArgsLocal.set(args);
        try {
            Object object = closure.call(args);
            return object;
        }
        finally {
            this.globalArgsLocal.remove();
        }
    }

    public static void main(String[] args) {
        GroovyMacro macro = new GroovyMacro(true){

            @Override
            protected Object invoke(String name, Object[] args) {
                System.out.println(name);
                System.out.println(Arrays.asList(this.getGlobalArgs()));
                System.out.println(Arrays.asList(args));
                return 1;
            }
        };
        for (int i = 0; i < 1; ++i) {
            System.out.println(macro.eval("${asd(5)}", 2));
        }
    }

    final class MacroBinding
    extends Binding {
        private final Script script;

        public MacroBinding(Script script) {
            this.script = script;
        }

        public Object getVariable(final String name) {
            Object result = super.getVariable(name);
            if (result != null) {
                return result;
            }
            Closure c = new Closure(this.script, this.script){
                private static final long serialVersionUID = -2778328821635253740L;

                public Object call(Object ... args) {
                    return GroovyMacro.this.invoke(name, args);
                }
            };
            c.setDelegate((Object)this.script);
            super.setVariable(name, (Object)c);
            return super.getVariable(name);
        }
    }

    final class MacroMetaClassDelegate
    extends MetaClassDelegate {
        public MacroMetaClassDelegate(MetaClass delegate) {
            super(delegate);
        }

        @Override
        public Object invokeMethod(Object o, String name, Object[] args) {
            if (GroovyMacro.this.logger.isDebugEnabled()) {
                GroovyMacro.this.logger.debug("o = " + o);
                GroovyMacro.this.logger.debug("name = " + name);
                GroovyMacro.this.logger.debug("args = " + Arrays.toString(args));
            }
            if ("doCall".equals(name)) {
                return super.invokeMethod(o, name, args);
            }
            if (args.length == 0) {
                return GroovyMacro.this.invoke(name, args);
            }
            if (args[0] instanceof Closure) {
                Object result;
                Closure closure = (Closure)args[0];
                MetaClass metaClass = closure.getMetaClass();
                if (!(metaClass instanceof MacroMetaClassDelegate)) {
                    closure.setMetaClass((MetaClass)new MacroMetaClassDelegate(metaClass));
                }
                if (args.length > 1) {
                    List closureArgs = GroovyMacro.this.resolveConstructorArguments(args, 1, args.length - 1);
                    result = closure.call(closureArgs.toArray());
                } else {
                    result = closure.call();
                }
                return GroovyMacro.this.invoke(name, new Object[]{result});
            }
            if (args.length > 1 && args[args.length - 1] instanceof Closure) {
                Closure closure = (Closure)args[args.length - 1];
                MetaClass metaClass = closure.getMetaClass();
                if (!(metaClass instanceof MacroMetaClassDelegate)) {
                    closure.setMetaClass((MetaClass)new MacroMetaClassDelegate(metaClass));
                }
                List closureArgs = GroovyMacro.this.resolveConstructorArguments(args, 0, args.length - 1);
                Object result = closure.call(closureArgs.toArray());
                return GroovyMacro.this.invoke(name, new Object[]{result});
            }
            return GroovyMacro.this.invoke(name, args);
        }
    }

    static class MethodCallExpressionChecker
    implements SecureASTCustomizer.ExpressionChecker {
        MethodCallExpressionChecker() {
        }

        public boolean isAuthorized(Expression expression) {
            return !(expression instanceof MethodCallExpression) || !(((MethodCallExpression)expression).getObjectExpression() instanceof ClassExpression) || ((MethodCallExpression)expression).getObjectExpression().getType().getName() != System.class.getName() || !"exit".equals(((MethodCallExpression)expression).getMethodAsString());
        }
    }
}

