/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class MegogoSubscriptionDao
extends AbstractIdDao<MegogoSubscription> {
    public static final String MEGOGO_SUBSCRIPTION_TABLE_NAME = "megogo_subscription";

    public MegogoSubscriptionDao(Connection con, int moduleId) {
        super(con, moduleId, MEGOGO_SUBSCRIPTION_TABLE_NAME);
    }

    public List<Integer> getMainSubscriptionsServiceIds() throws BGException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT sid FROM " + this.tableName + " WHERE type=1");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getInt("sid"));
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List<MegogoSubscription> getSubscriptionList(Boolean used, int type) throws BGException {
        List list;
        block11: {
            Object request = "SELECT s.id as serId, s.title, s.isusing, ms.* FROM service AS s ";
            if (used == null || used.booleanValue()) {
                request = (String)request + " LEFT ";
            }
            request = (String)request + "JOIN " + this.tableName + " AS ms ON s.id=ms.sid WHERE mid=" + this.moduleId + (used != null ? " AND s.isusing=?" : "");
            if (type > 0 && type < 3) {
                request = (String)request + " AND type=" + type;
            }
            request = (String)request + " ORDER BY ms.type, ms.id";
            PreparedStatement ps = this.con.prepareStatement((String)request);
            try {
                if (used != null) {
                    ps.setBoolean(1, used);
                }
                ResultSet rs = ps.executeQuery();
                list = this.getListFromRS(rs);
                if (ps == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MegogoSubscription getByServiceId(int serviceId) throws BGException {
        String query = "SELECT s.id as serId, s.title, s.isusing, ms.* FROM " + this.tableName + " AS ms LEFT JOIN service AS s ON ms.sid=s.id WHERE ms.sid=" + serviceId;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            MegogoSubscription megogoSubscription = this.getFromRS(rs);
            return megogoSubscription;
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    protected MegogoSubscription getFromRS(ResultSet rs) throws SQLException, BGException {
        MegogoSubscription megogoService = new MegogoSubscription();
        megogoService.setId(rs.getInt("id"));
        megogoService.setSid(rs.getInt("sid"));
        megogoService.setTitle(rs.getString("title"));
        if (megogoService.getSid() == 0) {
            megogoService.setSid(rs.getInt("serId"));
        }
        megogoService.setKey(rs.getString("megogoKey"));
        megogoService.setUsed(rs.getBoolean("isusing"));
        megogoService.setComment(rs.getString("comment"));
        megogoService.setLm((Date)rs.getTimestamp("lm"));
        megogoService.setUserId(rs.getInt("userId"));
        megogoService.setType(rs.getInt("type"));
        return megogoService;
    }

    protected void updateImpl(MegogoSubscription subscription) throws BGException, SQLException {
        if (subscription != null) {
            PreparedStatement ps = null;
            if (subscription.getId() < 1) {
                String query = "INSERT INTO " + this.tableName + " SET sid=?, type=?, megogoKey=?, comment=?, userId=?";
                ps = this.con.prepareStatement(query, 1);
            } else {
                String query = "UPDATE " + this.tableName + " SET sid=?, type=?, megogoKey=?, comment=?, userId=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(6, subscription.getId());
            }
            ps.setInt(1, subscription.getSid());
            ps.setInt(2, subscription.getType());
            ps.setString(3, subscription.getKey());
            ps.setString(4, subscription.getComment());
            ps.setInt(5, subscription.getUserId());
            ps.executeUpdate();
            if (subscription.getId() < 1) {
                subscription.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
    }
}

