/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobilePushToken;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class MobilePushTokenDao
extends AbstractIdDao<MobilePushToken> {
    public MobilePushTokenDao(Connection con, int moduleId) {
        super(con, moduleId, "mobile_push_tokens");
    }

    protected MobilePushToken getFromRS(ResultSet rs) throws SQLException, BGException {
        MobilePushToken token = new MobilePushToken();
        token.setId(rs.getInt("id"));
        token.setToken(rs.getString("token"));
        token.setType(rs.getInt("type"));
        token.setDateCreate(rs.getTimestamp("dateCreate"));
        token.setLastSendDate(rs.getTimestamp("lastSendDate"));
        token.setLastConfirmDate(rs.getTimestamp("lastConfirmDate"));
        token.setRejected(rs.getInt("rejected"));
        token.setRejectedDate(rs.getTimestamp("rejectedDate"));
        return token;
    }

    protected void updateImpl(MobilePushToken token) throws BGException, SQLException {
        int index = 0;
        if (token.getId() > 0) {
            String query = "UPDATE " + this.tableName + " SET lastSendDate=?, lastConfirmDate=?, rejected=?, rejectedDate=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setTimestamp(++index, TimeUtils.convertDateToTimestamp((Date)token.getLastSendDate()));
                ps.setTimestamp(++index, TimeUtils.convertDateToTimestamp((Date)token.getLastConfirmDate()));
                ps.setInt(++index, token.getRejected());
                ps.setTimestamp(++index, TimeUtils.convertDateToTimestamp((Date)token.getRejectedDate()));
                ps.setInt(++index, token.getId());
                ps.executeUpdate();
            }
        }
        String query = "INSERT INTO " + this.tableName + " SET token=?, type=?, dateCreate=NOW(), lastConfirmDate=NOW()";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(++index, token.getToken());
            ps.setInt(++index, token.getType());
            ps.executeUpdate();
            token.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }

    public MobilePushToken getByToken(String token, int type) throws BGException {
        if (2 == type || 1 == type) {
            return (MobilePushToken)((Object)this.get("token=? AND type=?", new Object[]{token, type}));
        }
        return (MobilePushToken)((Object)this.get("token=?", new Object[]{token}));
    }
}

