/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobimoney.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.MobiServiceCode;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.Transaction;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractDao<Transaction> {
    private String serviceCodeTableName;

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "mobi_transaction");
        this.serviceCodeTableName = "mobi_service_code_" + moduleId;
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "end_date");
        this.fields.put("sum", "summ");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        try {
            StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS m.*, c.title FROM " + this.tableName + " AS m");
            query.append(" LEFT JOIN contract AS c ON c.id=m.cid");
            query.append(" WHERE true");
            if (Utils.notBlankString((String)status)) {
                query.append(" AND m.status=?");
            }
            if (contractId > 0) {
                query.append(" AND c.id=?");
            } else if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (period != null && period.getDateFrom() != null) {
                query.append(" AND m.create_date>=?");
            }
            if (period != null && period.getDateTo() != null) {
                query.append(" AND m.create_date<?");
            }
            query.append(this.getSQLOrder(sort, this.fields));
            if (page != null) {
                query.append(page.sqlLimit());
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int index = 1;
            if (Utils.notBlankString((String)status)) {
                ps.setString(index++, status);
            }
            if (contractId > 0) {
                ps.setInt(index++, contractId);
            } else if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            if (period != null && period.getDateFrom() != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
            }
            if (period != null && period.getDateTo() != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
            query = new StringBuilder("SELECT SUM(m.summ) FROM " + this.tableName + " AS m");
            query.append(" LEFT JOIN contract AS c ON c.id=m.cid");
            query.append(" WHERE true");
            if (Utils.notBlankString((String)status)) {
                query.append(" AND m.status=?");
            }
            if (contractId > 0) {
                query.append(" AND m.cid=?");
            } else if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (period != null && period.getDateFrom() != null) {
                query.append(" AND m.create_date>=?");
            }
            if (period != null && period.getDateTo() != null) {
                query.append(" AND m.create_date<?");
            }
            ps = this.con.prepareStatement(query.toString());
            index = 1;
            if (Utils.notBlankString((String)status)) {
                ps.setString(index++, status);
            }
            if (contractId > 0) {
                ps.setInt(index++, contractId);
            } else if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            if (period != null && period.getDateFrom() != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
            }
            if (period != null && period.getDateTo() != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                searchResult.setSum(rs.getBigDecimal(1));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public boolean checkPayment(int contractId, String mobiPaymentId) throws BGException {
        boolean result = false;
        try {
            String query = "SELECT id FROM " + this.tableName + " WHERE cid=? AND mobi_payment_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setString(index++, mobiPaymentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = rs.getInt("id") > 0;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Transaction getTransaction(String mobiPaymentId) throws BGException {
        Transaction result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT m.*, c.title FROM " + this.tableName + " AS m");
            query.append(" LEFT JOIN contract AS c ON c.id=m.cid");
            query.append(" WHERE m.mobi_payment_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(1, mobiPaymentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void addTransaction(Transaction transaction) throws BGException {
        try {
            StringBuilder query = new StringBuilder("INSERT INTO " + this.tableName);
            query.append(" (cid, create_date, summ, status, mobi_payment_id ) VALUES ( ?,NOW(),?,?,? )");
            PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getTransactionId());
            if (ps.executeUpdate() > 0) {
                this.con.commit();
                transaction.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateTransaction(Transaction transaction) throws BGException {
        this.updateImpl(transaction);
    }

    public List<MobiServiceCode> getServiceCodeList() throws BGException {
        ArrayList<MobiServiceCode> list = new ArrayList<MobiServiceCode>();
        try {
            String query = "SELECT * FROM " + this.serviceCodeTableName + " ORDER BY title";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                MobiServiceCode mobiServiceCode = new MobiServiceCode();
                mobiServiceCode.setId(rs.getInt("id"));
                mobiServiceCode.setCode(rs.getInt("code"));
                mobiServiceCode.setTitle(rs.getString("title"));
                list.add(mobiServiceCode);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    public void updateServiceCode(MobiServiceCode mobiServiceCode) throws BGException {
        if (mobiServiceCode != null) {
            try {
                StringBuilder query = new StringBuilder(this.serviceCodeTableName).append(" SET code=").append(mobiServiceCode.getCode()).append(", title=?");
                if (mobiServiceCode.getId() > 0) {
                    query.insert(0, "UPDATE ").append(" WHERE id=").append(mobiServiceCode.getId());
                } else {
                    query.insert(0, "INSERT INTO ");
                }
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setString(1, mobiServiceCode.getTitle());
                ps.executeUpdate();
                ps.close();
                mobiServiceCode.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void deleteServiceCode(List<Integer> ids) throws BGException {
        if (ids != null && !ids.isEmpty()) {
            try {
                String query = "DELETE FROM " + this.serviceCodeTableName + " WHERE id IN ( " + Utils.toString(ids) + " )";
                Statement st = this.con.createStatement();
                st.executeUpdate(query);
                st.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("m.id"))).setContractId(rs.getInt("m.cid"))).setContractTitle(rs.getString("c.title"))).setSum(rs.getBigDecimal("m.summ"))).setCreateDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("m.create_date")))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("m.end_date")))).setStatus(rs.getString("m.status"))).setTransactionId(rs.getString("m.mobi_payment_id"))).build();
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        try {
            StringBuilder query = new StringBuilder("UPDATE " + this.tableName);
            query.append(" SET status=?");
            if (transaction.getTransactionDate() != null) {
                query.append(", end_date=?");
            }
            query.append(" WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int index = 1;
            ps.setString(index++, transaction.getStatus());
            if (transaction.getTransactionDate() != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            }
            ps.setInt(index++, transaction.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

