/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.news.server.bean;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.plugins.news.common.bean.News;
import ru.bitel.bgbilling.plugins.news.common.bean.NewsFilter;
import ru.bitel.bgbilling.plugins.news.common.bean.NewsItem;
import ru.bitel.bgbilling.plugins.news.server.event.NewsModifiedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public final class NewsManager
extends AbstractIdDao<News> {
    private static final Logger logger = LogManager.getLogger();
    private static Boolean needReload = true;
    private static Object mutex = new Object();
    private static List<News> newsDocumentList = new ArrayList<News>();

    public NewsManager(Connection con) {
        super(con, 0, "news");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(int id) throws BGException {
        int result = super.delete(id);
        Object object = mutex;
        synchronized (object) {
            needReload = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImpl(News news) throws BGException, SQLException {
        Document doc;
        if (news.getBody().trim().startsWith("<data") && (doc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(news.getBody())))) == null) {
            throw new BGException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 xml \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442!");
        }
        boolean update = news.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET dt=?, title=?, txt=?, filter_mode=?, filter_data=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)news.getDate()));
            ps.setString(index++, news.getTitle());
            ps.setString(index++, news.getBody());
            ps.setInt(index++, news.getFilter().getCode());
            ps.setString(index++, news.getFilterData());
            if (update) {
                ps.setInt(index++, news.getId());
            }
            ps.executeUpdate();
            Object object = mutex;
            synchronized (object) {
                needReload = true;
            }
            if (!update) {
                news.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<News> getNewsList(List<Integer> labelIds, Page page) throws BGException {
        return super.list(page, null, "dt DESC", new Object[0]).getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<News> getNewsList(Setup setup, Page page, int contractId) {
        if (needReload.booleanValue()) {
            Object object = mutex;
            synchronized (object) {
                if (needReload.booleanValue()) {
                    NewsManager.newsReload(setup);
                    needReload = false;
                }
            }
        }
        ArrayList<News> newsList = new ArrayList<News>();
        try (Connection connection = setup.getDBConnectionFromPool();){
            List contractLabelIds = null;
            List<News> list = newsDocumentList;
            block27: for (News news : list) {
                block10 : switch (news.getFilter()) {
                    case LABEL: {
                        if (contractLabelIds == null) {
                            contractLabelIds = new ContractLabelManager(connection).getContractLabelIds(contractId);
                        }
                        List newsLabelIds = Utils.toIntegerList((String)news.getFilterData());
                        Iterator iterator = contractLabelIds.iterator();
                        while (iterator.hasNext()) {
                            int contractLabelId = (Integer)iterator.next();
                            if (!newsLabelIds.contains(contractLabelId)) continue;
                            newsList.add(news);
                            break block10;
                        }
                        continue block27;
                    }
                    case SQL: {
                        try {
                            Statement st = connection.createStatement();
                            try {
                                ResultSet rs = st.executeQuery("SELECT " + contractId + " IN (" + news.getFilterData() + " )");
                                try {
                                    if (!rs.next() || !rs.getBoolean(1)) continue block27;
                                    newsList.add(news);
                                    continue block27;
                                }
                                finally {
                                    if (rs == null) continue block27;
                                    rs.close();
                                    continue block27;
                                }
                            }
                            finally {
                                if (st == null) continue block27;
                                st.close();
                                continue block27;
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex);
                            break;
                        }
                    }
                    case HANDLER: {
                        break;
                    }
                    default: {
                        newsList.add(news);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        if (page != null) {
            page.setRecordCount(newsList.size());
            if (page.getPageIndex() > 1) {
                int i = page.getPageSize() * (page.getPageIndex() - 1);
                while (i-- > 0) {
                    newsList.remove(0);
                }
            }
            while (newsList.size() > page.getPageSize()) {
                newsList.remove(page.getPageSize());
            }
        }
        return newsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void newsReload(Setup setup) {
        Connection con = setup.getDBConnectionFromPool();
        String query = "SELECT * FROM news WHERE dt <= now() ORDER BY dt DESC";
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            ArrayList<News> list = new ArrayList<News>();
            while (rs.next()) {
                list.add(News.builder().setId(rs.getInt("id")).setFilter(NewsFilter.getNewsFilter((int)rs.getInt("filter_mode"))).setFilterData(rs.getString("filter_data")).setDate((java.util.Date)rs.getTimestamp("dt")).setTitle(rs.getString("title")).setBody(rs.getString("txt")).build());
            }
            newsDocumentList = list;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public List<News> list(Page page) throws BGException {
        return super.list(page, null, "dt DESC", new Object[0]).getList();
    }

    public void search(SearchResult<NewsItem> searchResult) throws BGException {
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        List news = searchResult.getList();
        String query = "SELECT SQL_CALC_FOUND_ROWS id, dt, title FROM " + this.tableName + page.sqlLimit();
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    news.add(this.getNewsItemFromRS(rs));
                }
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected NewsItem getNewsItemFromRS(ResultSet rs) throws SQLException, BGException {
        return NewsItem.builder().setId(rs.getInt("id")).setDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("dt"))).setTitle(rs.getString("title")).build();
    }

    protected News getFromRS(ResultSet rs) throws SQLException, BGException {
        return News.builder().setId(rs.getInt("id")).setDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("dt"))).setFilter(NewsFilter.getNewsFilter((int)rs.getInt("filter_mode"))).setFilterData(rs.getString("filter_data")).setTitle(rs.getString("title")).setBody(rs.getString("txt")).build();
    }

    static {
        try {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<NewsModifiedEvent>(){

                public void notify(NewsModifiedEvent e, EventListenerContext ctx) throws BGException {
                    needReload = true;
                }
            }, NewsModifiedEvent.class);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }
}

