/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import bitel.billing.server.admin.resource.bean.NumberResourceAuditor;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.load.DefaultDataProcess;
import bitel.billing.server.load.ProcessIn;
import bitel.billing.server.load.bean.Source;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import ru.bitel.bgbilling.kernel.base.phone.server.RangeMapCache;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.ItemZoneTrafficCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.phone.server.DBProcessIn;
import ru.bitel.bgbilling.modules.phone.server.FindItemConveyor;
import ru.bitel.bgbilling.modules.phone.server.LogRecord;
import ru.bitel.bgbilling.modules.phone.server.TariffConveyor;
import ru.bitel.bgbilling.modules.phone.server.bean.CalculateClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemFinder;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneServiceCost;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneTariffContext;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneTariffThreadContext;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.Conveyor;
import ru.bitel.common.worker.WorkerTask;

public class DataProcess
extends DefaultDataProcess {
    private String sessionsTableName;
    private String incomingSessionsTableName;
    private PreparedStatement psInsertError;
    private String errorLogTitle = "";
    private StringBuffer errorLogMessage = new StringBuffer(1000);
    private AtomicBoolean gotErrors = new AtomicBoolean(false);
    String lineStart;
    private Writer sessionWriter;
    private ByteArrayOutputStream sessionOutputStream;
    boolean storeIncomingSessions = false;
    Writer incomingSessionWriter;
    private ByteArrayOutputStream incomingSessionOutputStream;
    Set<Integer> cids;
    ClientItemFinder itemFinder;
    ItemZoneTrafficCache itemZoneTrafficCache;
    Preferences moduleSetup;
    ParameterMap sourceSetup;
    int mid;
    Calendar hour;
    private int sourceId;
    private boolean firstSession = true;
    private Calendar startMonth;
    private Calendar endMonth;
    AtomicInteger count = new AtomicInteger();
    AtomicInteger clientSession = new AtomicInteger();
    AtomicInteger clientIncomingSession = new AtomicInteger();
    AtomicInteger operSession = new AtomicInteger();
    private static final long MAX_CACHE_ACTUAL_TIME = 300000L;
    private static int lastSourceId;
    private static Calendar lastHour;
    private static long lastProcessTime;
    private static ClientItemFinder lastMonthFinder;
    private static ClientItemFinder lastFinder;
    private static String lastCIds;
    private static NumberResourceAuditor lastAuditor;
    private static ItemZoneTrafficCache lastItemZoneTrafficCache;
    NumberResourceAuditor auditor;
    private static final ExecutorService inserterPools;
    private static final AtomicInteger insertTaskCount;
    private boolean useCache = true;

    public bitel.billing.server.load.DBProcessIn getDBProcessIn(Setup setup, Source source, Calendar hour, Connection con) {
        return new DBProcessIn(setup, source, hour, con);
    }

    public synchronized PhoneTariffThreadContext newTariffThreadContext() {
        return new PhoneTariffThreadContext((DefaultServerSetup)this.setup, (Calendar)this.startMonth.clone(), (Calendar)this.endMonth.clone());
    }

    public void proccess(ProcessIn processIn, Connection con) {
        this.setup = processIn.getSetup();
        this.con = null;
        this.mid = processIn.getSource().getMid();
        this.sourceId = processIn.getSource().getId();
        this.hour = processIn.getHour();
        this.startMonth = (Calendar)this.hour.clone();
        this.startMonth.set(5, 1);
        this.endMonth = (Calendar)this.hour.clone();
        this.endMonth.set(5, this.hour.getActualMaximum(5));
        this.moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.mid));
        this.sourceSetup = this.moduleSetup.inherit((ParameterMap)new Preferences(processIn.getSource().getConfig(), "\r\n"));
        this.useCache = this.moduleSetup.getBoolean("use.cache", true);
        this.proccessImpl(processIn, con);
    }

    private void proccessImpl(ProcessIn processIn, Connection con) {
        long startTime = System.currentTimeMillis();
        boolean tariffOnlyMonth = this.moduleSetup.getInt("tariff.only.month", 0) > 0;
        long maxCacheActualTime = this.moduleSetup.getLong("cache.actual.time.max", 300000L);
        this.storeIncomingSessions = this.moduleSetup.getInt("store.incoming.calls", 0) > 0;
        logger.info("tariff.only.month=" + tariffOnlyMonth + " store.incoming.calls=" + this.storeIncomingSessions);
        String cids = null;
        StringBuffer report = new StringBuffer("proccess [" + TimeUtils.format((Calendar)processIn.getHour(), (String)"dd-MM-yyyy HH:00:00") + "; mid => " + this.mid + "; param => " + this.sourceId + "] ");
        this.sessionsTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)this.hour.getTime(), (int)this.mid);
        this.incomingSessionsTableName = ServerUtils.getModuleMonthTableName((String)"log_incoming_session", (Date)this.hour.getTime(), (int)this.mid);
        try {
            long processStart = System.currentTimeMillis();
            logger.debug("Clear errors...");
            this.clearErrorLog(con, TimeUtils.convertCalendarToSqlDate((Calendar)this.hour), this.hour.get(11), this.mid, this.sourceId);
            this.psInsertError = this.getInsertErrorLog(con, TimeUtils.convertCalendarToSqlDate((Calendar)this.hour), this.hour.get(11), this.mid, this.sourceId);
            this.errorLogTitle = "(Phone) \u041e\u0448\u0438\u0431\u043a\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043b\u043e\u0433\u043e\u0432 \u0437\u0430 " + TimeUtils.formatDate((Calendar)this.hour) + " (\u0447\u0430\u0441 " + this.hour.get(11) + "). \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f=" + this.mid + ". \u041a\u043e\u0434 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430=" + this.sourceId + ".";
            this.createTables(con);
            this.createWriters();
            long timeBeanCreateStart = System.currentTimeMillis();
            this._cu = new ContractUtils(con);
            if (this.useCache && lastItemZoneTrafficCache != null && lastSourceId == this.sourceId && TimeUtils.hourDelta((Calendar)lastHour, (Calendar)this.hour) == 1 && TimeUtils.monthsDelta((Calendar)lastHour, (Calendar)this.hour) == 0 && processStart - lastProcessTime < maxCacheActualTime) {
                this.itemZoneTrafficCache = lastItemZoneTrafficCache;
                logger.info("Use zone traffic cache..");
            } else {
                logger.info("Create new traffic cache");
                while (insertTaskCount.intValue() != 0) {
                    Thread.sleep(1000L);
                    logger.info("Waiting " + insertTaskCount.intValue() + " insert tasks..");
                }
                this.itemZoneTrafficCache = new ItemZoneTrafficCache();
                this.initItemZoneTraffic(con);
            }
            String categories = new Preferences(processIn.getSource().getConfig(), "\r\n").get("resource.categories", null);
            if (this.useCache && lastMonthFinder != null && (cids == null && lastCIds == null || cids != null && cids.equals(lastCIds)) && lastSourceId == this.sourceId && TimeUtils.monthsDelta((Calendar)lastHour, (Calendar)this.hour) == 0 && processStart - lastProcessTime < maxCacheActualTime) {
                this.itemFinder = lastMonthFinder;
                this.auditor = lastAuditor;
                logger.info("Use month item cache..");
            } else {
                logger.info("Create new month item finder...");
                lastMonthFinder = this.itemFinder = new ClientItemFinder(con, this.mid, this.sourceId, this.startMonth, this.endMonth, cids);
                lastFinder = null;
                lastAuditor = this.auditor = new NumberResourceAuditor(con, this.mid, TimeUtils.convertCalendarToDate((Calendar)this.hour), categories);
            }
            if (this.useCache && lastFinder != null && (cids == null && lastCIds == null || cids != null && cids.equals(lastCIds)) && lastSourceId == this.sourceId && (TimeUtils.dateEqual((Calendar)lastHour, (Calendar)this.hour) || tariffOnlyMonth && TimeUtils.monthsDelta((Calendar)lastHour, (Calendar)this.hour) == 0) && processStart - lastProcessTime < maxCacheActualTime) {
                this.itemFinder = lastFinder;
                logger.info("Use item cache...");
            } else {
                logger.info("Create new item finder...");
                lastFinder = this.itemFinder = this.itemFinder.sub(con, this.mid, processIn.getHour());
            }
            lastSourceId = this.sourceId;
            lastHour = this.hour;
            lastCIds = cids;
            lastItemZoneTrafficCache = this.itemZoneTrafficCache;
            long timeBeanCreateEnd = System.currentTimeMillis();
            logger.info("Item loaded " + this.itemFinder.getItemCount());
            if (logger.isDebugEnabled()) {
                logger.debug(this.itemFinder.getItemDetail());
            }
            RangeMapCache rangeMapCache = RangeMapCache.getInstance((Connection)con, (int)this.mid, (Calendar)this.hour);
            Conveyor.process((String)"data-process-log", (Conveyor)new TariffConveyor((DefaultServerSetup)this.setup, this, con), Arrays.asList(new FindItemConveyor((DefaultServerSetup)this.setup, this, processIn, rangeMapCache), new FindItemConveyor((DefaultServerSetup)this.setup, this, processIn, rangeMapCache)));
            this.insertErrorsToDB();
            this.sessionWriter.close();
            if (this.storeIncomingSessions) {
                this.incomingSessionWriter.flush();
                this.incomingSessionWriter.close();
            }
            Inserter inserter = new Inserter(report.toString());
            inserterPools.execute(inserter);
            insertTaskCount.incrementAndGet();
            this.markProcessed(TimeUtils.convertCalendarToTimestamp((Calendar)this.hour), this.sourceId, con);
            long stopTime = System.currentTimeMillis();
            report.append("; records => ");
            report.append(this.count);
            report.append("; cl_ses => ");
            report.append(this.clientSession);
            report.append("; in_ses => ");
            report.append(this.clientIncomingSession);
            report.append("; op_ses => ");
            report.append(this.operSession);
            report.append("; time => " + (stopTime - startTime) + "/" + (timeBeanCreateEnd - timeBeanCreateStart) + " ms.");
            logger.info(report.toString());
            lastProcessTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createWriters() throws Exception {
        this.sessionOutputStream = new ByteArrayOutputStream(5000000);
        this.sessionWriter = new OutputStreamWriter(this.sessionOutputStream);
        this.lineStart = "0\t" + this.sourceId + "\t" + TimeUtils.format((Calendar)this.hour, (String)"yyyy-MM-dd HH:mm:ss") + "\t";
        this.incomingSessionOutputStream = new ByteArrayOutputStream(5000000);
        this.incomingSessionWriter = new OutputStreamWriter(this.incomingSessionOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertSession(PhoneTariffThreadContext threadCtx, LogRecord record, int itemId, int cid, int serviceId, int sessionTime, PhoneServiceCost clientCostData, PhoneServiceCost operCostData, int dest, int zone, PhoneTariffContext tariffContext) {
        try {
            clientCostData.setTypeAndSourceDefault();
            clientCostData.calculateTimeAndCost(record, sessionTime, null, tariffContext);
            this.itemZoneTrafficCache.addZoneTraffic(Integer.valueOf(itemId), Integer.valueOf(zone), clientCostData.getRoundSessionTime());
            if (operCostData != null) {
                operCostData.setTypeAndSourceDefault();
                operCostData.calculateTimeAndCost(record, sessionTime, record.callOperCost, tariffContext);
            }
            Writer writer = this.sessionWriter;
            synchronized (writer) {
                if (!this.firstSession) {
                    this.sessionWriter.write("\n");
                }
                this.firstSession = false;
                this.sessionWriter.write(this.lineStart);
                this.sessionWriter.write(String.valueOf(record.id));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(TimeUtils.format((Calendar)record.sessionStart, (String)"yyyy-MM-dd HH:mm:ss"));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(String.valueOf(sessionTime));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(String.valueOf(clientCostData.getRoundSessionTime()));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(record.fromNumber);
                this.sessionWriter.write("\t");
                this.sessionWriter.write(record.fromNumber164);
                this.sessionWriter.write("\t");
                this.sessionWriter.write(record.toNumber);
                this.sessionWriter.write("\t");
                this.sessionWriter.write(record.toNumber164);
                this.sessionWriter.write("\t");
                this.sessionWriter.write(String.valueOf(cid));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(String.valueOf(itemId));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(String.valueOf(dest));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(String.valueOf(serviceId));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(threadCtx.sessionDecimalFormat.format(clientCostData.getCost()));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(clientCostData.getSessionCost().toPlainString());
                this.sessionWriter.write("\t");
                this.sessionWriter.write(String.valueOf(zone));
                this.sessionWriter.write("\t");
                this.sessionWriter.write(operCostData != null ? String.valueOf(operCostData.getRoundSessionTime()) : "0");
                this.sessionWriter.write("\t");
                this.sessionWriter.write(operCostData != null ? String.valueOf(operCostData.getCostMapItemId()) : "0");
                this.sessionWriter.write("\t");
                this.sessionWriter.write(operCostData != null ? operCostData.getSessionCost().toPlainString() : "0");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void createTables(Connection con) throws Exception {
        String query = null;
        PreparedStatement ps = null;
        if (ServerUtils.tableExists((Connection)con, (String)this.sessionsTableName)) {
            Statement st;
            if (!ServerUtils.columnExist((Connection)con, (String)this.sessionsTableName, (String)"zone")) {
                query = "ALTER TABLE " + this.sessionsTableName + " ADD zone int NOT NULL";
                ps = con.prepareStatement(query);
                ps.executeUpdate();
                ps.close();
            }
            if (!ServerUtils.columnExist((Connection)con, (String)this.sessionsTableName, (String)"oper_cost")) {
                st = con.createStatement();
                st.executeUpdate("ALTER TABLE " + this.sessionsTableName + " ADD oper_round_session_time int NOT NULL");
                st.executeUpdate("ALTER TABLE " + this.sessionsTableName + " ADD oper_cost decimal(10," + this.moduleSetup.getInt("session.oper.cost.scale", 5) + ") NOT NULL");
                st.executeUpdate("ALTER TABLE " + this.sessionsTableName + " ADD KEY sid(sid)");
                st.close();
            }
            if (!ServerUtils.columnExist((Connection)con, (String)this.sessionsTableName, (String)"oper_cost_map_item_id")) {
                st = con.createStatement();
                st.executeUpdate("ALTER TABLE " + this.sessionsTableName + " ADD oper_cost_map_item_id int NOT NULL DEFAULT 0 AFTER oper_round_session_time");
                st.close();
            }
        } else {
            query = "CREATE TABLE " + this.sessionsTableName + "( id int NOT NULL auto_increment PRIMARY KEY,source_id int NOT NULL,hour datetime NOT NULL,cdr_id int(11) NOT NULL,session_start datetime NOT NULL,session_time int(11) NOT NULL,round_session_time int(11) NOT NULL,from_number varchar(20) NOT NULL,from_number_164 varchar(20) NOT NULL,to_number varchar(20) NOT NULL,to_number_164 varchar(20) NOT NULL,cid int(11) NOT NULL,item_id int(11) NOT NULL,dest_id int(11) NOT NULL,sid int(11) NOT NULL,min_cost float(10,5) NOT NULL,cost decimal(10," + this.moduleSetup.getInt("session.call.cost.scale", 2) + ") NOT NULL,zone int NOT NULL, oper_round_session_time int NOT NULL,oper_cost_map_item_id int NOT NULL DEFAULT 0, oper_cost decimal(10," + this.moduleSetup.getInt("session.oper.cost.scale", 5) + ") NOT NULL,KEY session_start (session_start),KEY log (source_id, hour),KEY cid (cid),KEY sid (sid),KEY item_id (item_id) )";
            ServerUtils.checkAndCreatePeriodicTableName((Connection)con, (String)this.sessionsTableName, (String)query);
        }
        if (this.storeIncomingSessions && !ServerUtils.tableExists((Connection)con, (String)this.incomingSessionsTableName)) {
            query = "CREATE TABLE " + this.incomingSessionsTableName + "( id int NOT NULL DEFAULT 0, source_id int NOT NULL,hour datetime NOT NULL,cdr_id int(11) NOT NULL,session_start datetime NOT NULL,session_time int(11) NOT NULL,from_number varchar(20) NOT NULL,from_number_164 varchar(20) NOT NULL,to_number varchar(20) NOT NULL,to_number_164 varchar(20) NOT NULL,cid int(11) NOT NULL,item_id int(11) NOT NULL,KEY session_start (session_start),KEY log (source_id, hour),KEY cid (cid),KEY item_id (item_id) )";
            ServerUtils.checkAndCreatePeriodicTableName((Connection)con, (String)this.incomingSessionsTableName, (String)query);
        }
    }

    private void deleteProcessingSessions(Connection con) throws Exception {
        String query = "DELETE FROM " + this.sessionsTableName + " WHERE source_id=? AND hour=?";
        if (this.cids != null) {
            query = query + " AND cid IN (" + Utils.toString(this.cids) + ")";
        }
        PreparedStatement ps = con.prepareStatement(query);
        ps.setInt(1, this.sourceId);
        ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)this.hour));
        ps.executeUpdate();
        ps.close();
        if (this.storeIncomingSessions) {
            query = "DELETE FROM " + this.incomingSessionsTableName + " WHERE source_id=? AND hour=?";
            if (this.cids != null) {
                query = query + " AND cid IN (" + Utils.toString(this.cids) + ")";
            }
            ps = con.prepareStatement(query);
            ps.setInt(1, this.sourceId);
            ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)this.hour));
            ps.executeUpdate();
            ps.close();
        }
    }

    void addError(String title, CalculateClientItem item, LogRecord record, TariffRequest req) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append("\n\n");
        if (item != null) {
            sb.append("Contract: ");
            sb.append(item.contract.title);
            sb.append("\t");
            sb.append("itemId: ");
            sb.append(item.itemId);
            sb.append("\n");
        }
        sb.append("StartTime=");
        sb.append(TimeUtils.format((Calendar)record.sessionStart, (String)"dd.MM.yyyy HH:mm:ss"));
        sb.append(" SessionTime=");
        sb.append(record.sessionTime);
        sb.append(" PORT_FROM=");
        sb.append(record.fromPort);
        sb.append(" PORT_TO=");
        sb.append(record.toPort);
        sb.append(" NUM_FROM=");
        sb.append(record.fromNumber);
        sb.append(" NUM_FROM_164=");
        sb.append(record.fromNumber164);
        sb.append(" NUM_TO=");
        sb.append(record.toNumber);
        sb.append(" NUM_TO_164=");
        sb.append(record.toNumber164);
        sb.append(" ConnectTime=");
        sb.append(record.connectTime);
        sb.append(" CallClientCost=");
        sb.append(Utils.maskNull((BigDecimal)record.callClientCost));
        if (req != null) {
            sb.append("\n");
            sb.append(req.toString());
        }
        sb.append("\n\n-------------------------------------\n\n");
        this.errorLogMessage.append((CharSequence)sb);
        this.gotErrors.set(true);
    }

    private void insertErrorsToDB() {
        try {
            if (this.gotErrors.get()) {
                this.psInsertError.setString(4, this.errorLogTitle);
                this.psInsertError.setString(5, this.errorLogMessage.toString());
                this.psInsertError.executeUpdate();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private int initItemZoneTraffic(Connection con) {
        int result = 0;
        if (this.hour.get(5) != 1 || this.hour.get(11) != 0) {
            try {
                String query = "SELECT item_id, zone, SUM(round_session_time) FROM " + this.sessionsTableName + " WHERE session_start<?";
                if (this.cids != null) {
                    query = query + " AND cid IN (" + Utils.toString(this.cids) + ")";
                }
                query = query + " GROUP BY item_id, zone";
                PreparedStatement psSelectZoneTraffic = con.prepareStatement(query);
                psSelectZoneTraffic.setTimestamp(1, TimeUtils.convertCalendarToTimestamp((Calendar)this.hour));
                ResultSet rs = psSelectZoneTraffic.executeQuery();
                while (rs.next()) {
                    this.itemZoneTrafficCache.addZoneTraffic(Integer.valueOf(rs.getInt(1)), Integer.valueOf(rs.getInt(2)), rs.getInt(3));
                }
                rs.close();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        List<String> s = Arrays.asList("725(2-4)", "7255", "72", "72(2-4)", "73");
        Collections.sort(s);
        System.out.println(s);
        System.out.println(40);
        System.out.println(48);
        System.out.println("71".compareTo("725"));
        System.out.println("722".compareTo("725"));
        System.out.println("722".compareTo("7255"));
        System.out.println("722".compareTo("72"));
        System.out.println("722".compareTo("72"));
        System.out.println("722".compareTo("73"));
        System.out.println("73".compareTo("725"));
    }

    static {
        inserterPools = WorkerTask.newBlockingFixedThreadPool((String)"inserter", null, null, (int)2, (int)2);
        insertTaskCount = new AtomicInteger();
    }

    private class Inserter
    implements Runnable {
        private String reportPrefix;

        public Inserter(String reportPrefix) {
            this.reportPrefix = reportPrefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection con = DataProcess.this.setup.getDBConnectionFromPool();
            try {
                int index;
                Object query = "";
                if (DataProcess.this.storeIncomingSessions && !ServerUtils.columnExist((Connection)con, (String)DataProcess.this.incomingSessionsTableName, (String)"id")) {
                    query = "ALTER TABLE " + DataProcess.this.incomingSessionsTableName + " ADD COLUMN `id` int NOT NULL DEFAULT 0 FIRST";
                    PreparedStatement ps = con.prepareStatement((String)query);
                    ps.executeUpdate();
                    ps.close();
                }
                long timeInsertStart = System.currentTimeMillis();
                PreparedStatement psLock = null;
                query = DataProcess.this.storeIncomingSessions ? "LOCK TABLES " + DataProcess.this.sessionsTableName + " WRITE, " + DataProcess.this.incomingSessionsTableName + " WRITE" : "LOCK TABLES " + DataProcess.this.sessionsTableName + " WRITE";
                psLock = con.prepareStatement((String)query);
                psLock.executeUpdate();
                psLock.close();
                logger.debug("Deleting processing sessions...");
                DataProcess.this.deleteProcessingSessions(con);
                query = "INSERT INTO " + DataProcess.this.sessionsTableName + " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                try (PreparedStatement psInsertSessions = con.prepareStatement((String)query);){
                    for (String cdr : new String(DataProcess.this.sessionOutputStream.toByteArray(), "UTF-8").split("\n")) {
                        index = 1;
                        for (String field : cdr.split("\t")) {
                            psInsertSessions.setString(index++, field);
                        }
                        if (index != 22) continue;
                        psInsertSessions.executeUpdate();
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (DataProcess.this.storeIncomingSessions) {
                    query = "INSERT INTO " + DataProcess.this.incomingSessionsTableName + " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                    try (PreparedStatement psInsertIncomingSessions = con.prepareStatement((String)query);){
                        for (String cdr : new String(DataProcess.this.incomingSessionOutputStream.toByteArray(), "UTF-8").split("\n")) {
                            logger.trace("cdr = {}", (Object)cdr);
                            index = 1;
                            for (String field : cdr.split("\t")) {
                                psInsertIncomingSessions.setString(index++, field);
                            }
                            if (index != 13) continue;
                            psInsertIncomingSessions.executeUpdate();
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                long timeInsertEnd = System.currentTimeMillis();
                try {
                    query = "UNLOCK TABLES";
                    PreparedStatement psUnLock = con.prepareStatement((String)query);
                    psUnLock.executeUpdate();
                    psUnLock.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                logger.info(this.reportPrefix + " session inserted => " + (timeInsertEnd - timeInsertStart) + " ms.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                insertTaskCount.decrementAndGet();
                ServerUtils.closeConnection((Connection)con);
            }
        }
    }
}

