/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class OptionTariffTreeNode
extends TariffTreeNode<TvTariffRequest, TvTariffContext, TreeContext, TvTariffWorkerContext> {
    private final Set<Integer> options;
    private final boolean modeOr;

    public OptionTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.options = new HashSet<Integer>(Utils.toIntegerList((String)parameterMap.get("options", "")));
        this.modeOr = parameterMap.getInt("mode", 0) == 0;
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest req, TvTariffContext ctx, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        if (this.options.size() == 0) {
            Set acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        long millis = req.getTarifficationTimeMillis(ctx);
        Map options = req.getTariffOptionMap(millis);
        if (options == null) {
            return 0;
        }
        if (this.modeOr) {
            if (this.options.size() > options.size()) {
                for (Integer o : options.keySet()) {
                    if (!this.options.contains(o)) continue;
                    Set acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
                    acceptedSet.add(parentTreeNodeId);
                    return 1;
                }
            } else {
                for (Integer o : this.options) {
                    if (!options.containsKey(o)) continue;
                    Set acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
                    acceptedSet.add(parentTreeNodeId);
                    return 1;
                }
            }
        } else if (options.keySet().containsAll(this.options)) {
            Set acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
            acceptedSet.add(parentTreeNodeId);
            return 1;
        }
        return 0;
    }
}

