/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneCostMapItem;
import ru.bitel.common.dao.AbstractIdDao;

public class VoiceZoneCostMapDao
extends AbstractIdDao<VoiceZoneCostMap> {
    private final String TABLE_VOICE_ZONE_COST_MAP_ITEM;

    public VoiceZoneCostMapDao(Connection con, int moduleId) {
        super(con, moduleId, "voice_zone_cost_map");
        this.TABLE_VOICE_ZONE_COST_MAP_ITEM = "voice_zone_cost_map_item_" + moduleId;
    }

    public List<VoiceZoneCostMap> list() throws BGException {
        return super.list("", "title", new Object[0]);
    }

    protected VoiceZoneCostMap getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceZoneCostMap result = new VoiceZoneCostMap();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    public List<VoiceZoneCostMapItem> getCosts(int voiceZoneCostMapId) throws BGException {
        ArrayList<VoiceZoneCostMapItem> costs = new ArrayList<VoiceZoneCostMapItem>();
        String querySelect = "SELECT * FROM " + this.TABLE_VOICE_ZONE_COST_MAP_ITEM + " WHERE `zone_cost_map_id`=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);){
            psSelect.setInt(1, voiceZoneCostMapId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    VoiceZoneCostMapItem item = new VoiceZoneCostMapItem();
                    item.setVoiceZoneId(rs.getInt("zone_id"));
                    item.setCost(rs.getBigDecimal("cost"));
                    item.setCostSecond(rs.getInt("cost_second"));
                    costs.add(item);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return costs;
    }

    protected void updateImpl(VoiceZoneCostMap voiceZoneCostMap) throws BGException, SQLException {
        Objects.requireNonNull(voiceZoneCostMap);
        this.ormUpdateImpl(voiceZoneCostMap);
        this.deleteItems(voiceZoneCostMap.getId());
        String queryInsert = "INSERT INTO " + this.TABLE_VOICE_ZONE_COST_MAP_ITEM + " SET `zone_cost_map_id`=?, `zone_id`=?, `cost`=?, cost_second=?";
        try (PreparedStatement psInsert = this.con.prepareStatement(queryInsert);){
            psInsert.setInt(1, voiceZoneCostMap.getId());
            if (voiceZoneCostMap.getCosts() != null) {
                for (VoiceZoneCostMapItem item : voiceZoneCostMap.getCosts()) {
                    psInsert.setInt(2, item.getVoiceZoneId());
                    psInsert.setBigDecimal(3, item.getCost());
                    psInsert.setInt(4, item.getCostSecond());
                    psInsert.executeUpdate();
                }
            }
        }
    }

    private void deleteItems(int voiceZoneCostMapId) throws BGException, SQLException {
        String queryDelete = "DELETE FROM " + this.TABLE_VOICE_ZONE_COST_MAP_ITEM + " WHERE `zone_cost_map_id`=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
            psDelete.setInt(1, voiceZoneCostMapId);
            psDelete.executeUpdate();
        }
    }
}

