/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceOperatorModifiedEvent;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceOperatorDao;
import ru.bitel.common.model.Id;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService")
public class VoiceOperatorServiceImpl
extends AbstractService
implements VoiceOperatorService {
    private VoiceOperatorDao operatorDao;

    @PostConstruct
    private void init() {
        this.operatorDao = new VoiceOperatorDao(this.getConnection(), this.moduleId);
    }

    public List<VoiceOperator> voiceOperatorList() throws BGException {
        return this.operatorDao.list();
    }

    public VoiceOperator voiceOperatorGet(int id) throws BGException {
        return (VoiceOperator)this.operatorDao.get(id);
    }

    public int voiceOperatorUpdate(VoiceOperator operator) throws BGException {
        VoiceOperator oldOperator = (VoiceOperator)this.operatorDao.getAndUpdate((Id)operator);
        this.operatorDao.update(operator);
        this.context.publishAfterCommit((Event)new VoiceOperatorModifiedEvent(this.moduleId, this.userId, oldOperator, operator));
        return operator.getId();
    }

    public int voiceOperatorDelete(int id) throws BGException {
        VoiceOperator oldOperator = (VoiceOperator)this.operatorDao.getAndDelete(id);
        this.context.publishAfterCommit((Event)new VoiceOperatorModifiedEvent(this.moduleId, this.userId, oldOperator, null));
        return this.operatorDao.delete(id);
    }
}

