/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.math.MathContext;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperatorRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOptionRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.CostMapCache;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.GeoCodeCache;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.ZoneCostMapCache;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.ZoneMapCache;
import ru.bitel.bgbilling.modules.voice.server.tariff.range.VoiceRangeManager;
import ru.bitel.common.TimeUtils;

public class VoiceTariffContext
extends TariffContext {
    private final CostMapCache costMapCache;
    private final ZoneMapCache zoneMapCache;
    private final ZoneCostMapCache zoneCostMapCache;
    private final VoiceOptionRuntimeMap optionRuntimeMap;
    private final VoiceOperatorRuntimeMap operatorRuntimeMap;
    boolean isRuntime = true;

    public VoiceTariffContext(Date fromTime, int moduleId, Connection con) throws BGException {
        super(MathContext.DECIMAL32, fromTime, false, moduleId);
        this.costMapCache = CostMapCache.getInstance(con, moduleId, fromTime);
        this.zoneCostMapCache = ZoneCostMapCache.getInstance(con, moduleId);
        this.zoneMapCache = ZoneMapCache.getInstance(con, moduleId);
        this.optionRuntimeMap = VoiceOptionRuntimeMap.getInstance(con, moduleId);
        this.operatorRuntimeMap = VoiceOperatorRuntimeMap.getInstance(con, moduleId);
    }

    protected void initTrafficRangeManager(int moduleId, boolean realtime) throws BGException {
        Date month = TimeUtils.getStartMonth((Date)this.fromTime);
        this.rangedTrafficManager = new VoiceRangeManager(moduleId, month, TimeUtils.convertDateToCalendar((Date)this.fromTime).get(5));
    }

    public CostMapCache getCostMapCache() {
        return this.costMapCache;
    }

    public ZoneMapCache getZoneMapCache() {
        return this.zoneMapCache;
    }

    public ZoneCostMapCache getZoneCostMapCache() {
        return this.zoneCostMapCache;
    }

    protected VoiceOptionRuntimeMap getOptionRuntimeMap() {
        return this.optionRuntimeMap;
    }

    public VoiceGeographicCode findCode(String number, int moduleId, int operatorId, Connection con) throws BGException {
        if (operatorId > 0) {
            VoiceOperator operator = this.operatorRuntimeMap.getOperatorById(operatorId);
            if (operator == null) {
                throw new BGException("Operator is nul for id " + operatorId);
            }
            if (!operator.isUseCustomGeoDict()) {
                operatorId = 0;
            }
        }
        return GeoCodeCache.findCode(number, moduleId, operatorId, con);
    }

    public boolean isRuntime() {
        return this.isRuntime;
    }

    public void setRuntime(boolean isRuntime) {
        this.isRuntime = isRuntime;
    }
}

