/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.action.web;

import bitel.billing.server.ActionBase;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.common.bean.Transaction;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.bgbilling.modules.assist.server.bean.TransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionPayList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        AssistPaymentRecurringManager prm;
        AssistPaymentRecurring recurringAlreadyHas;
        if (this.cid <= 0 && this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Calendar now = Calendar.getInstance();
        int mm = this.getIntParameter("month", now.get(2) + 1);
        int yy = this.getIntParameter("year", now.get(1));
        TransactionManager transactionManager = new TransactionManager(this.con, this.mid);
        GregorianCalendar from = new GregorianCalendar(yy, mm - 1, 1);
        Calendar until = (Calendar)((Calendar)from).clone();
        until.add(2, 1);
        List<Transaction> paymentList = transactionManager.getPaymentList(this.cid, from.getTime(), until.getTime(), Arrays.asList(TransactionStatus.NEW.getCode(), TransactionStatus.OK.getCode(), TransactionStatus.FAIL.getCode()));
        Element assistru = this.createElement(this.rootNode, "assist");
        for (Transaction payment : paymentList) {
            Element paymentEl = this.createElement(assistru, "payment");
            paymentEl.setAttribute("number", String.valueOf(payment.getId()));
            paymentEl.setAttribute("time", TimeUtils.format((Date)payment.getCreateDate(), (String)"yyyy.MM.dd HH:mm:ss"));
            paymentEl.setAttribute("card_number", payment.getPan());
            paymentEl.setAttribute("card_text", payment.getCardText());
            paymentEl.setAttribute("card_holder", payment.getCardholderName());
            paymentEl.setAttribute("summ", Utils.formatCost((BigDecimal)payment.getSum()));
            paymentEl.setAttribute("status", String.valueOf(payment.getStatus()));
            paymentEl.setAttribute("billnumber", String.valueOf(payment.getBillnumber()));
            paymentEl.setAttribute("cardtype", payment.getCardtype());
            paymentEl.setAttribute("cardsubtype", payment.getCardsubtype());
            paymentEl.setAttribute("comment", payment.getComment());
            paymentEl.setAttribute("ipaddress", payment.getIpaddress());
            paymentEl.setAttribute("name", payment.getName());
            paymentEl.setAttribute("responsecode", payment.getResponseCode() != null ? payment.getResponseCode().toString() : "");
            paymentEl.setAttribute("recurringParentId", String.valueOf(payment.getRecurringParentId()));
        }
        this.rootNode.setAttribute("year", String.valueOf(yy));
        this.rootNode.setAttribute("month", String.valueOf(mm));
        TransactionStatus result = (TransactionStatus)this.getEnumParameter("result", TransactionStatus.class, null);
        if (result != null) {
            int ordernumber = this.getIntParameter("ordernumber", -1);
            String billnumber = this.getParameter("billnumber");
            Transaction transaction = (Transaction)transactionManager.get(ordernumber);
            String message = null;
            if (transaction == null) {
                log.error("Assist: \u0412 \u0411\u0414 \u043d\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435: ordernumber=" + ordernumber + ",cid=" + this.cid);
                message = "\u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u043b\u0430\u0442\u0435\u0436\u0430 #" + ordernumber + " \u0432 \u0432\u0430\u0448\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u043d\u0435\u0442!";
                result = TransactionStatus.FAIL;
            } else if (transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                result = (TransactionStatus)TransactionStatus.ALL.getStatusByCode(transaction.getStatus());
                message = "\u0421\u0442\u0430\u0442\u0443\u0441 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 (\u043f\u043b\u0430\u0442\u0451\u0436 #" + ordernumber + ") \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d:\n";
                switch (result) {
                    case OK: {
                        message = message + "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0431\u044b\u043b\u0430 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e ";
                        break;
                    }
                    case FAIL: {
                        message = message + "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0431\u044b\u043b\u0430 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0430 \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439 ";
                        break;
                    }
                    default: {
                        message = message + "\u0412 \u0411\u0414 \u0431\u044b\u043b \u0437\u0430\u043d\u0435\u0441\u0451\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 ";
                    }
                }
                message = message + TimeUtils.format((Date)transaction.getCreateDate(), (String)"dd.MM.yyyy HH:mm:ss");
            } else {
                message = "\u041f\u043b\u0430\u0442\u0451\u0436 #" + ordernumber + " \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0441\u044f \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0435 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u043c\u0438\u043d\u0443\u0442.\n";
                message = message + "\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 assist: " + billnumber + "\n";
                message = message + "\u041f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + result.getTitle().toLowerCase() + ".";
            }
            this.rootNode.setAttribute("result", String.valueOf(result));
            this.createElement(this.rootNode, "resultmessage").setTextContent(message);
        }
        if ((recurringAlreadyHas = (prm = new AssistPaymentRecurringManager(this.con, this.mid)).getRecurring(this.cid)) != null) {
            Element recurringEl = this.createElement(this.rootNode, "recurring");
            XMLUtils.setAttribute((Element)recurringEl, (String)"billnumber", (String)String.valueOf(recurringAlreadyHas.getBillnumber()));
            XMLUtils.setAttribute((Element)recurringEl, (String)"ordernumber", (String)String.valueOf(recurringAlreadyHas.getOrdernumber()));
            XMLUtils.setAttribute((Element)recurringEl, (String)"Date", (String)TimeUtils.formatFullDate((Date)recurringAlreadyHas.getDate()));
            XMLUtils.setAttribute((Element)recurringEl, (String)"Amount", (String)recurringAlreadyHas.getAmount().toPlainString());
            XMLUtils.setAttribute((Element)recurringEl, (String)"RecurringMinAmount", (String)recurringAlreadyHas.getRecurringMinAmount().toPlainString());
            XMLUtils.setAttribute((Element)recurringEl, (String)"RecurringMaxAmount", (String)recurringAlreadyHas.getRecurringMaxAmount().toPlainString());
            XMLUtils.setAttribute((Element)recurringEl, (String)"RecurringPeriod", (String)String.valueOf(recurringAlreadyHas.getRecurringPeriod()));
            XMLUtils.setAttribute((Element)recurringEl, (String)"RecurringMaxDate", (String)TimeUtils.formatDate((Date)recurringAlreadyHas.getRecurringMaxDate()));
        }
    }
}

