/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Utils;

public class ActionBillUpdateXml
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("codes", -1);
        String type = this.getParameter("type");
        String xml = this.getParameter("xml");
        if (this.mid <= 0 || id <= 0 || Utils.isBlankString((String)type)) {
            throw new BGIllegalArgumentException();
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionBillUpdateXml", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            try (AbstractManager pbm = type.equals("bill") ? new BillManager(this.con, this.mid) : new InvoiceManager(this.con, this.mid);){
                BillDoc doc = pbm.getBillDocInfo(id);
                if (doc != null) {
                    LocalDate month = LocalDate.of(doc.getYy(), doc.getMm() + 1, 1);
                    ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)month, (LocalDate)month);
                }
            }
        }
        String table = (type.equals("bill") ? "bill_data_" : "bill_invoice_data_") + this.mid;
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + table + " SET xml=? WHERE id=" + id);){
            ps.setBytes(1, xml.getBytes());
            ps.executeUpdate();
        }
    }
}

