/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOptionData;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusBalance;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusCharge;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusContractProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusDetailCharge;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPaymentType;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgramSpecification;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.bgbilling.plugins.bonus.server.dao.BonusDao;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.bonus.common.service.BonusService")
@XmlSeeAlso(value={BonusPaymentType.class})
public class BonusServiceImpl
extends AbstractService
implements BonusService {
    private BonusDao bonusDao;
    private Preferences setup;
    @Resource
    private TariffOptionService tariffOptionService;

    @PostConstruct
    void init() {
        this.bonusDao = new BonusDao(this.getConnection());
    }

    private Preferences getBonusSetup() {
        if (this.setup == null) {
            Map pluginsMap = BGPluginManagerServer.getManager().getPluginsMap();
            this.setup = ((BGPluginServer)pluginsMap.get("ru.bitel.bgbilling.plugins.bonus")).getSetup();
        }
        return this.setup;
    }

    public List<BonusPaymentType> paymentTypeList(boolean usedOnly) throws BGException {
        return this.bonusDao.getPaymentTypeList(usedOnly);
    }

    public List<BonusPayment> paymentsNotActiveNow(int cid) throws BGException {
        return this.bonusDao.getPaymentsToActiveInFuture(cid, new Date());
    }

    public void paymentTypeUpdate(BonusPaymentType paymentType) throws BGException {
        this.bonusDao.updatePaymentType(paymentType);
    }

    public boolean paymentTypeDelete(int paymentId) throws BGException {
        boolean result = this.bonusDao.isUsePaymentType(paymentId);
        if (!result) {
            this.bonusDao.deletePaymentType(paymentId);
        }
        return !result;
    }

    public List<BonusPayment> paymentList(int contractId, Date dateFrom, Date dateTo) throws BGException {
        return this.bonusDao.getPaymentList(contractId, dateFrom, dateTo);
    }

    public List<BonusCharge> chargeList(int contractId, Date dateFrom, Date dateTo) throws BGException {
        return this.bonusDao.getChargeList(contractId, dateFrom, dateTo);
    }

    public void paymentUpdate(int contractId, BonusPayment payment) throws BGException {
        List<BonusDetailCharge> chargeDetailList;
        int id = payment.getId();
        this.bonusDao.updatePayment(this.userId, contractId, payment);
        if (id < 1 && BonusDao.flagBalanceCanBeNegative && (chargeDetailList = this.bonusDao.getDetailsChargeList(-1)).size() > 0) {
            BigDecimal remainderSum = payment.getSum();
            for (BonusDetailCharge bonusCharge : chargeDetailList) {
                if (remainderSum.compareTo(BigDecimal.ZERO) <= 0) break;
                if (remainderSum.compareTo(bonusCharge.getSum()) >= 0) {
                    remainderSum = remainderSum.subtract(bonusCharge.getSum());
                    this.bonusDao.updateDetailsCharge(bonusCharge.getId(), payment.getId(), bonusCharge.getSum());
                    continue;
                }
                BigDecimal remainderChargeSum = bonusCharge.getSum().subtract(remainderSum);
                this.bonusDao.updateDetailsCharge(bonusCharge.getId(), payment.getId(), remainderSum);
                this.bonusDao.addDetailsItem(bonusCharge.getBonusChargeId(), -1, remainderChargeSum);
                remainderSum = BigDecimal.ZERO;
                break;
            }
        }
    }

    public boolean chargeUpdate(int contractId, BonusCharge bonusCharge) throws BGException {
        boolean result = false;
        boolean commitFlag = false;
        try {
            commitFlag = this.getConnection().getAutoCommit();
            this.getConnection().setAutoCommit(false);
            BonusCharge oldCharge = null;
            if (bonusCharge.getId() > 0 && bonusCharge.getContractChargeId() > 0) {
                oldCharge = this.bonusDao.getCharge(bonusCharge.getContractChargeId());
                this.chargeDeleteByContractChargeId(bonusCharge.getContractChargeId());
            }
            HashMap<Integer, BigDecimal> sumMap = new HashMap<Integer, BigDecimal>();
            List<BonusPayment> bonusPaymentList = this.bonusDao.getPaymentsActiveAndPositive(contractId, bonusCharge.getDate(), sumMap);
            ArrayList<Integer> listIdPayment = new ArrayList<Integer>();
            BigDecimal lastSum = null;
            BigDecimal deltaSum = bonusCharge.getSum().setScale(2);
            boolean enough = false;
            for (BonusPayment bonusPayment : bonusPaymentList) {
                BigDecimal paymentSum = sumMap.get(bonusPayment.getId());
                if (paymentSum.subtract(deltaSum).compareTo(BigDecimal.ZERO) >= 0) {
                    lastSum = deltaSum;
                    enough = true;
                    listIdPayment.add(bonusPayment.getId());
                    break;
                }
                listIdPayment.add(bonusPayment.getId());
                deltaSum = deltaSum.subtract(paymentSum);
            }
            if (!enough && BonusDao.flagBalanceCanBeNegative) {
                listIdPayment.add(-1);
                lastSum = deltaSum;
                enough = true;
            }
            if (enough) {
                this.bonusDao.addCharge(this.userId, contractId, bonusCharge);
                if (bonusCharge.getId() > 0) {
                    for (int i = 0; i < listIdPayment.size() - 1; ++i) {
                        int paymentId = (Integer)listIdPayment.get(i);
                        this.bonusDao.addDetailsItem(bonusCharge.getId(), paymentId, sumMap.get(paymentId));
                    }
                    int paymentId = (Integer)listIdPayment.get(listIdPayment.size() - 1);
                    this.bonusDao.addDetailsItem(bonusCharge.getId(), paymentId, lastSum);
                    result = true;
                }
            }
            if (!result && oldCharge != null) {
                this.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        finally {
            try {
                this.getConnection().setAutoCommit(commitFlag);
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
        return result;
    }

    public int activateTO(int contractId, int tariffOptionId, int tariffOptionActivateModeId) throws Exception {
        if (!this.pluginInclude(contractId)) {
            throw new BGMessageException("\u041f\u043b\u0430\u0433\u0438\u043d \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d \u0443 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!");
        }
        TariffOptionActivateMode mode = this.tariffOptionService.tariffOptionActivateModeGet(tariffOptionId, tariffOptionActivateModeId);
        if (mode == null) {
            throw new BGMessageException("\u0417\u0430\u0434\u0430\u043d \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
        }
        if (mode.getChargeSumma().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGMessageException("\u0426\u0430\u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430 \u0440\u0430\u0432\u043d\u0430 0");
        }
        BigDecimal bonusBalance = this.balance(contractId, new Date());
        if (bonusBalance.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGMessageException("\u0414\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u043e\u043d\u0443\u0441\u043d\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441!");
        }
        boolean payOnlyBonus = Utils.toIntegerSet((String)this.getBonusSetup().get("tariffOptionsPaymentOnlyWithBonuses")).contains(tariffOptionId);
        BigDecimal maxBonusRealSumMayBePay = payOnlyBonus ? mode.getChargeSumma() : this.bonusSummaMaxAdvanced(contractId, mode.getChargeTypeId(), mode.getChargeSumma(), false, null);
        ContractTariffOptionData optionActivate = new ContractTariffOptionData();
        optionActivate.setContractId(contractId);
        optionActivate.setOptionId(tariffOptionId);
        optionActivate.setModeId(tariffOptionActivateModeId);
        optionActivate.setChargeSum(mode.getChargeSumma().subtract(maxBonusRealSumMayBePay));
        optionActivate.setWeb(true);
        int chargeContrId = this.tariffOptionService.contractTariffOptionActivateWhithSum(optionActivate);
        BonusCharge charge = new BonusCharge(0, new Date(), maxBonusRealSumMayBePay.multiply(new BigDecimal(this.rate())), chargeContrId);
        if (!this.chargeUpdate(contractId, charge)) {
            throw new BGMessageException("\u041d\u0435 \u0445\u0432\u0430\u0442\u0438\u043b\u043e \u0431\u043e\u043d\u0443\u0441\u043e\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438");
        }
        return charge.getId();
    }

    public boolean paymentDelete(int paymentId) throws BGException {
        if (!this.bonusDao.isUsePaymentsInDetailsTable(paymentId)) {
            this.bonusDao.deletePayment(paymentId);
            return true;
        }
        return false;
    }

    public void chargeDeleteByContractChargeId(int contractChargeId) throws BGException {
        if (contractChargeId > 0) {
            this.bonusDao.deleteChargeAccordingToContractChargeId(contractChargeId);
        }
    }

    public List<BonusPayment> paymentDetailsList(int chargeId) throws BGException {
        return this.bonusDao.getPaymentDetailsList(chargeId);
    }

    public List<BonusCharge> chargeDetailsList(int paymentId) throws BGException {
        return this.bonusDao.getChargeDetailsList(paymentId);
    }

    public List<BonusBalance> balanceList(int contractId, Date date) throws BGException {
        HashMap<Integer, BigDecimal> residueSumMap = new HashMap<Integer, BigDecimal>();
        List<BonusPayment> paymentList = this.bonusDao.getPaymentsActiveToDate(contractId, date, residueSumMap);
        List<BonusCharge> chargeList = this.bonusDao.getChargesLinkedPayments(contractId, paymentList, date);
        ArrayList<BonusBalance> balanceList = new ArrayList<BonusBalance>();
        HashMap<Integer, BonusPayment> paymentMap = new HashMap<Integer, BonusPayment>();
        if (paymentList != null) {
            for (BonusPayment payment : paymentList) {
                balanceList.add(new BonusBalance(payment.getId(), 1, payment.getSum(), residueSumMap.get(payment.getId()), payment.getDate()));
                paymentMap.put(payment.getId(), payment);
            }
        }
        if (chargeList != null) {
            for (BonusCharge charge : chargeList) {
                BonusBalance chargeBalance = new BonusBalance(charge.getId(), 2, charge.getSum(), BigDecimal.ZERO, charge.getDate());
                List<BonusPayment> detList = this.bonusDao.getPaymentDetailsList(charge.getId());
                BigDecimal debitSum = BigDecimal.ZERO;
                for (BonusPayment paym : detList) {
                    if (paymentMap.get(paym.getId()) == null) continue;
                    debitSum = debitSum.add(paym.getSum());
                }
                chargeBalance.setDebitSum(debitSum);
                balanceList.add(chargeBalance);
            }
        }
        Comparator<BonusBalance> comparer = new Comparator<BonusBalance>(){

            @Override
            public int compare(BonusBalance bal1, BonusBalance bal2) {
                return bal1.getDate().compareTo(bal2.getDate());
            }
        };
        Collections.sort(balanceList, comparer);
        BigDecimal lastSum = new BigDecimal(0);
        for (BonusBalance balance : balanceList) {
            lastSum = balance.getTypeId() == 1 ? lastSum.add(balance.getSum()) : lastSum.subtract(balance.getDebitSum());
            balance.setRest(lastSum);
        }
        return balanceList;
    }

    public BigDecimal balance(int cid, Date date) throws BGException {
        return this.bonusDao.getBalance(cid, date, null, false);
    }

    public BigDecimal balanceAdvanced(int cid, Date date, Integer chargeId, boolean withFutureCharge) throws BGException {
        return this.bonusDao.getBalance(cid, date, chargeId, withFutureCharge);
    }

    public BigDecimal balanceNotActive(int cid, Date date) throws BGException {
        return this.bonusDao.getNotActiveBalanceStill(cid, date);
    }

    public boolean pluginInclude(int contractId) throws BGException {
        return this.bonusDao.pluginInclude(contractId);
    }

    public void updatePluginInclude(int cid, boolean include) throws BGException {
        this.bonusDao.updatePluginInclude(cid, include);
    }

    public int percentOfBonus(int contractChargeId) {
        int percent = this.getBonusSetup().getInt("charge.percentDefault", 0);
        List chargeList = this.getBonusSetup().getIntegerList("charge", null);
        if (chargeList != null && chargeList.indexOf(contractChargeId) > -1) {
            percent = this.getBonusSetup().getInt("charge.percent." + contractChargeId, 0);
        }
        if (percent < 0) {
            percent = 0;
        }
        if (percent > 100) {
            percent = 100;
        }
        return percent;
    }

    public BonusCharge chargeBonus(int contractChargeId) throws BGException {
        return this.bonusDao.getCharge(contractChargeId);
    }

    public int rate() {
        Map pluginsMap = BGPluginManagerServer.getManager().getPluginsMap();
        return Utils.parseInt((String)((BGPluginServer)pluginsMap.get("ru.bitel.bgbilling.plugins.bonus")).getSetup().get("rate"), (int)1);
    }

    public BigDecimal roundBigDecimal(BigDecimal value) {
        return value.setScale(0, RoundingMode.DOWN);
    }

    public BigDecimal bonusSummaMax(int cid, int contractChargeId, BigDecimal chargeSum, boolean bonusSum) throws BGException {
        return this.bonusSummaMaxAdvanced(cid, contractChargeId, chargeSum, bonusSum, null);
    }

    public BigDecimal bonusSummaMaxAdvanced(int cid, int contractChargeId, BigDecimal chargeSum, boolean bonusSum, BigDecimal maxSum) throws BGException {
        if (this.pluginInclude(cid) && chargeSum.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal balanceBonus = this.balanceAdvanced(cid, new Date(), null, true);
            BigDecimal percent = new BigDecimal(contractChargeId > 0 ? this.percentOfBonus(contractChargeId) : 100);
            BigDecimal maxBonusRealSum = chargeSum.multiply(percent.divide(new BigDecimal(100)), new MathContext(0, RoundingMode.DOWN));
            BigDecimal rate = new BigDecimal(this.rate());
            BigDecimal compareSum = null;
            if (maxSum != null) {
                compareSum = maxSum;
                if (bonusSum) {
                    compareSum = maxSum.divide(rate);
                }
            } else {
                compareSum = balanceBonus.divide(rate, 3, RoundingMode.DOWN);
                if (compareSum.compareTo(BigDecimal.ZERO) < 0) {
                    compareSum = BigDecimal.ZERO;
                }
            }
            if (maxBonusRealSum.compareTo(compareSum) == 1) {
                maxBonusRealSum = compareSum;
            }
            if (bonusSum) {
                return maxBonusRealSum.multiply(rate);
            }
            return maxBonusRealSum;
        }
        return BigDecimal.ZERO;
    }

    public String treeNodeTitle(int contractId) throws BGException {
        BigDecimal balanceNow = this.balance(contractId, new Date()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal balanceNotActiveNow = this.balanceNotActive(contractId, new Date()).setScale(2, RoundingMode.HALF_UP);
        if (balanceNow != null && balanceNotActiveNow != null) {
            return Utils.formatBigDecimalSumm((BigDecimal)balanceNow) + "/+" + Utils.formatBigDecimalSumm((BigDecimal)balanceNotActiveNow);
        }
        return "";
    }

    public MapHolder<String, String> programTypeMap() throws BGException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Integer.toString(1), "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439");
        for (String className : Utils.toList((String)this.getBonusSetup().get("dinamicBonusPrograms", ""))) {
            BonusProgramSpecification specification = this.bonusDao.getProgramSpecificationForDynamicProgram(className = className.trim());
            if (specification == null) continue;
            String title = specification.getTitle();
            map.put(className, title);
        }
        return new MapHolder(map);
    }

    public List<BonusProgram> programList(Date date) throws BGException {
        return this.bonusDao.getProgramList(date, 0);
    }

    public void programUpdate(BonusProgram program) throws BGException {
        this.bonusDao.updateProgram(program);
    }

    public List<BonusContractProgram> programContractList(int cid) throws BGException {
        return this.bonusDao.getProgramCotractList(cid);
    }

    public void programContractUpdate(BonusContractProgram contractProgram) throws BGException, BGMessageException {
        Period period = contractProgram.getPeriod();
        BonusProgram bonusProgram = this.bonusDao.getProgram(contractProgram.getProgram().getId());
        if (period.getDateTo() != null && bonusProgram.getPeriod().getDateTo() != null && period.getDateTo().compareTo(bonusProgram.getPeriod().getDateTo()) > 0) {
            throw new BGMessageException("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0447\u0435\u043c \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0430\u043c\u043e\u0439 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b");
        }
        if (period.getDateFrom().compareTo(bonusProgram.getPeriod().getDateFrom()) < 0) {
            throw new BGMessageException("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0447\u0435\u043c \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0430\u043c\u043e\u0439 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b");
        }
        this.bonusDao.updateProgramContract(contractProgram);
    }

    public boolean checkProgramPeriodOnCrossing(BonusProgram bonusProgram) throws BGException {
        return this.bonusDao.checkProgramPeriodOnCrossing(bonusProgram);
    }

    public List<Integer> programInContractList(int idProgram, Date date) throws BGException {
        return this.bonusDao.getContractsOfThisProgram(idProgram, date);
    }

    public void programDelete(int programId) throws BGException {
        this.bonusDao.deleteProgram(programId);
    }

    public void updateProgramAndPluginIncludeGroupOperation(List<BonusProgram> programs, String cids, Period period, boolean include) throws BGException {
        if (Utils.notBlankString((String)cids)) {
            List cidList = Utils.toIntegerList((String)cids);
            for (Integer cid : cidList) {
                if (programs != null) {
                    for (BonusProgram program : programs) {
                        this.bonusDao.updateProgramContract(new BonusContractProgram(cid.intValue(), program, period));
                    }
                }
                this.bonusDao.updatePluginInclude(cid, include);
            }
        }
    }

    public void extendPaymentsGroupOperation(String cids, Period paymentPeriod, Set<Integer> paymentTypeSet, int extendType, String valueExtend, boolean onlyActive) throws BGException {
        if (Utils.notBlankString((String)cids)) {
            if (paymentPeriod == null || paymentPeriod.getDateFrom() == null || paymentPeriod.getDateTo() == null) {
                throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0435\u0440\u0438\u043e\u0434 \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u043c\u044b\u0445 \u0431\u043e\u043d\u0443\u0441\u043d\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439!");
            }
            if (extendType != 1 && extendType != 2) {
                throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f!");
            }
            if (Utils.isBlankString((String)valueExtend)) {
                throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f!");
            }
            if (paymentTypeSet != null && paymentTypeSet.size() == 0) {
                throw new BGMessageException("\u041f\u0443\u0441\u0442\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439!");
            }
            Date day = null;
            int days = -1;
            if (extendType == 1) {
                day = TimeUtils.parseDate((String)valueExtend, (String)"dd.MM.yyyy");
                if (day == null || TimeUtils.dateBeforeOrEq((Date)day, (Date)new Date())) {
                    throw new BGMessageException("\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u0430 \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0434\u0430\u0442\u0430 \u0434\u043e \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c!");
                }
            } else {
                days = Utils.parseInt((String)valueExtend, (int)-1);
                if (days < 1) {
                    throw new BGMessageException("\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u043e \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439 \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c!");
                }
            }
            Date now = new Date();
            List cidList = Utils.toIntegerList((String)cids);
            for (Integer cid : cidList) {
                if (!this.bonusDao.pluginInclude(cid)) continue;
                for (BonusPayment payment : this.bonusDao.getPaymentList(cid, paymentPeriod.getDateFrom(), paymentPeriod.getDateTo())) {
                    if (paymentTypeSet != null && !paymentTypeSet.contains(payment.getTypeId()) || onlyActive && TimeUtils.dateBefore((Date)payment.getDateTo(), (Date)now)) continue;
                    BigDecimal sumPayment = payment.getSum();
                    for (BonusDetailCharge charge : this.bonusDao.getDetailsChargeList(payment.getId())) {
                        sumPayment = sumPayment.subtract(charge.getSum());
                    }
                    if (sumPayment.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (extendType == 1) {
                        if (TimeUtils.dateBefore((Date)day, (Date)payment.getDateTo())) continue;
                        payment.setDateTo(day);
                    } else {
                        Calendar calendar = TimeUtils.convertDateToCalendar((Date)payment.getDateTo());
                        calendar.add(6, days);
                        Date date = TimeUtils.convertCalendarToDate((Calendar)calendar);
                        if (TimeUtils.dateBeforeOrEq((Date)date, (Date)now)) continue;
                        payment.setDateTo(date);
                    }
                    this.bonusDao.updatePayment(this.userId, cid, payment);
                }
            }
        }
    }

    public String getDataProgramOfContract(int programId, int contractId) throws BGException, BGMessageException {
        return Utils.toString(new BonusDao(this.getConnection()).getDataProgramOfContract(programId, contractId), (String)"\n");
    }
}

