package ru.bitel.bgbilling.modules.botmanager.dyn.auth;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;
import ru.bitel.common.Utils;

public class CheckPassword
    implements DialogProcessing
{
    private final static Logger logger = LogManager.getLogger();

    /**
     * id диалога, который будет показан в случае совпадения пароля договора с переданным пользователем
     */
    private final int NEXT_DIALOG = 10;

    @Override
    public void preDialog( ServerContext serverContext, JSONObject botData )
    {

    }

    @Override
    public void processDialog( ServerContext serverContext,
                               JSONObject botData,
                               String inputTextOfUser )
    {
        int contractId = botData.optInt( CONTRACT_ID, -1 );
        if( Utils.notBlankString(inputTextOfUser) && contractId > 0 )
        {
            try( ContractManager contractManager = new ContractManager( serverContext.getConnection() ) )
            {
                Contract contract = contractManager.getContractById( contractId );
                if( contract != null && contract.getPswd().equals( inputTextOfUser ) )
                {
                    //отправляем на диалог с данными пользователя
                    botData.put( NEXT_DIALOG_ID, NEXT_DIALOG );
                    botData.put( CONTRACT_ID, contract.getId() );
                }
                else
                {
                    if( contract == null )
                    {
                        logger.error( "Contract is null!" );
                    }
                    else
                    {
                        //говорим, что пароль не верный
                        botData.put( ERROR_MESSAGE, "Вы указали не верный пароль" );
                        if( logger.isDebugEnabled() )
                        {
                            logger.debug( "Password for contract=" + contractId + " is not valid" );
                        }
                    }
                }
            }
        }
        else
        {
            //говорим, что не верный пароль
            botData.put( ERROR_MESSAGE, "Вы указали не верный пароль" );
            if( logger.isDebugEnabled() )
            {
                logger.debug( "Password for contract=" + contractId + " is not valid" );
            }
        }
    }

    @Override
    public String title()
    {
        return "Проверка пароля";
    }
}
