/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.IntTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.client.UserCardFilterPanel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardPacketService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.PacketService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class UserCardCinemaEditor
extends BGUPanel {
    private boolean init = false;
    private CardPacket cardPacketId;
    private BGUTable table;
    private BGTableModel<CardPacket> model;
    private CardLayout mainCard = new CardLayout();
    private JPanel mainPanel = new JPanel(new GridBagLayout());
    private CardLayout bottomCard = new CardLayout();
    private JPanel bottomPanel = new JPanel();
    private BGUComboBox<Packet> packetCB = new BGUComboBox();
    private BGControlPanelDateNoB statusDate = new BGControlPanelDateNoB();
    private IntTextField hours = new IntTextField();
    private UserCardFilterPanel filterPanel = new UserCardFilterPanel(this);

    protected String getTableHeader() {
        this.model = new BGTableModel<CardPacket>("CardPacket"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u041a\u0430\u0440\u0442\u0430", 0, 0, 0, "card", false);
                this.addColumn("\u041a\u0438\u043d\u043e\u0437\u0430\u043b", 150, 150, -1, "packetTitle", false);
                this.addColumn("\u0421 \u0447\u0430\u0441\u0430", String.class, 100, 120, -1, "date1", false);
                this.addColumn("\u041f\u043e \u0447\u0430\u0441", String.class, 100, 120, -1, "date2", false);
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", String.class, 80, 100, -1, "cost", false);
            }

            public Object getValue(CardPacket val, int column) throws BGException {
                if (column == 3) {
                    return TimeUtils.format((Date)val.getDateFrom(), (String)"dd.MM.yyyy HH:mm");
                }
                if (column == 4) {
                    return TimeUtils.format((Date)val.getDateTo(), (String)"dd.MM.yyyy HH:mm");
                }
                if (column == 5) {
                    return val.getCost() != null ? Utils.formatCost((BigDecimal)val.getCost()) : "?";
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        return "user_card_cinema";
    }

    public UserCardCinemaEditor() {
        this.getTableHeader();
        this.build();
    }

    protected void jbInit() throws Exception {
        this.setLayout(this.mainCard);
        this.add(this.mainPanel, "editor");
        this.mainPanel.add((Component)((Object)this.filterPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.bottomPanel.setLayout(this.bottomCard);
        this.mainPanel.add((Component)this.bottomPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addEditorPanels();
    }

    protected void addEditorPanels() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new GridBagLayout());
        this.bottomPanel.add((Component)statusPanel, "status");
        statusPanel.setBorder((Border)new BGTitleBorder("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"));
        JPanel topStatusPanel = new JPanel();
        topStatusPanel.setLayout(new GridBagLayout());
        topStatusPanel.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0438\u043d\u043e\u0437\u0430\u043b: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        topStatusPanel.add((Component)this.packetCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        topStatusPanel.add((Component)new JLabel(" \u043e\u0442: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        topStatusPanel.add((Component)this.statusDate, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.hours.setColumns(3);
        this.hours.setMaxValue(23L);
        this.hours.setMinValue(0L);
        topStatusPanel.add((Component)this.hours, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        topStatusPanel.add((Component)new JLabel("\u0447\u0430\u0441\u043e\u0432"), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        JButton okButton = new JButton("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        topStatusPanel.add((Component)okButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        statusPanel.add((Component)topStatusPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserCardCinemaEditor.this.performAction("updateStatus");
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.init) {
                this.init = true;
                List list = ((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).packetList(Boolean.valueOf(true));
                this.packetCB.setData(list);
            }
            this.filterPanel.refresh();
            UserCard cardItem = (UserCard)this.filterPanel.getCardFilterCB().getSelectedItem();
            List list = ((CardPacketService)((ClientContext)this.getContext()).getPort(CardPacketService.class)).cardPacketTable(((ClientContext)this.getContext()).getObjectId(), cardItem != null ? cardItem.getId() : -1, this.filterPanel.getDateFilter().getDate(), true, ((ClientContext)this.getContext()).getContractId());
            this.model.setData(list);
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            this.cardPacketId = (CardPacket)this.model.getSelectedRow();
            if (this.cardPacketId != null && ClientUtils.confirmDelete((Object)"\u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0438\u043d\u043e\u0437\u0430\u043b")) {
                ((CardPacketService)((ClientContext)this.getContext()).getPort(CardPacketService.class)).deleteCardPacket(((ClientContext)this.getContext()).getContractId(), this.cardPacketId.getId(), true);
                this.performAction("refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("updateStatus", "updateStatus"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                UserCard cardItem = (UserCard)UserCardCinemaEditor.this.filterPanel.getCardFilterCB().getSelectedItem();
                if (cardItem == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u0443!");
                    return;
                }
                Packet packetItem = (Packet)UserCardCinemaEditor.this.packetCB.getSelectedItem();
                if (packetItem == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442!");
                    return;
                }
                CardPacket cardPacket = new CardPacket();
                cardPacket.setId(UserCardCinemaEditor.this.cardPacketId != null ? UserCardCinemaEditor.this.cardPacketId.getId() : 0);
                cardPacket.setContractId(((ClientContext)UserCardCinemaEditor.this.getContext()).getContractId());
                cardPacket.setUsercardId(cardItem.getId());
                cardPacket.setDateFrom(UserCardCinemaEditor.this.statusDate.getDate());
                cardPacket.setPacketId(packetItem.getId());
                ((CardPacketService)((ClientContext)UserCardCinemaEditor.this.getContext()).getPort(CardPacketService.class)).updateCardPacket(cardPacket, true, (int)UserCardCinemaEditor.this.hours.getValue());
                UserCardCinemaEditor.this.performAction("refresh");
            }
        };
    }
}

