/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class PacketTariffTreeNode
extends DefaultTariffTreeNode {
    private JLabel view = new JLabel();
    private BGComboBox<IdTitle> packetCB;
    private String packetTitle;
    private Directory packetDir;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view.setIcon(ClientUtils.getIcon((String)"package.png"));
        this.packetDir = this.getDirManager().getDirectory("packets");
    }

    protected JPanel getEditorPanel() {
        JPanel editorPanel = new JPanel();
        this.packetCB = new BGComboBox(this.packetDir.getItems());
        editorPanel.add(new JLabel("\u041f\u0430\u043a\u0435\u0442 "));
        editorPanel.add((Component)this.packetCB);
        return editorPanel;
    }

    public Component getView() {
        return this.view;
    }

    protected void loadData() {
        Map data = this.getDataInHash();
        String packet = (String)data.get("packet");
        this.setDirectoryItemSelection((JComboBox)this.packetCB, Utils.parseInt((String)packet));
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("packet", String.valueOf(this.getIdFromDirectoryCombo((JComboBox)this.packetCB)));
        this.setDataInHash(data);
        this.updateView();
    }

    private void updateView() {
        this.extractData();
        StringBuffer sb = new StringBuffer(60);
        sb.append("\u041f\u0430\u043a\u0435\u0442 ");
        sb.append(this.packetTitle);
        this.view.setText(sb.toString());
    }

    public void setData(String data) {
        super.setData(data);
        this.updateView();
    }

    private void extractData() {
        Map data = this.getDataInHash();
        String packet = (String)data.get("packet");
        this.packetTitle = packet != null ? this.packetDir.getValue(Utils.parseInt((String)packet, (int)0)) : "";
    }
}

