/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import jakarta.xml.ws.BindingProvider;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.administration.CaClientAdministrationServiceEndpoint;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.administration.CaClientAdministrationWebService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.administration.UpdateCaPinToDefaultValueRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.administration.UpdateCaPinToGivenValueRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.messaging.AbstractResponseType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.messaging.CaClientIds;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.messaging.SendBarkMessageToClientRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.messaging.SendBarkMessageToClientsRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.messaging.SendMailboxMessageToClientRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.messaging.SendMailboxMessageToClientsRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.messaging.UserTextMessagingServiceEndpoint;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.messaging.UserTextMessagingWebService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.pairing.CreatePairingRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.pairing.GetPairingStatusForCardRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.pairing.PairingServiceEndpoint;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.pairing.PairingStatusResponseType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.pairing.PairingStatusType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.pairing.PairingWebService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.AddSubscriptionsRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.CancelSubscriptionsRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.EmmDeliveryType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.GetActiveSubscriptionsRequestType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.SubscriptionPeriodType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.SubscriptionServiceEndpoint;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.SubscriptionStatusResponseType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.SubscriptionStatusType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.SubscriptionType;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.SubscriptionWebService;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.security.EyelessHostnameVerifier;
import ru.bitel.common.security.EyelessSSLSocketFactory;

public class Conax4ServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private Map<Integer, Con> connections = new HashMap<Integer, Con>();
    static final int MAX_MESSAGE_CARDCOUNT = 512;

    private static void setupws(Object endpoint, String urlparamname, ParameterMap connectionSetup) throws BGException {
        String ws_user = connectionSetup.get("user", null);
        String ws_password = connectionSetup.get("password", null);
        String ws_url = connectionSetup.get(urlparamname, null);
        Map requestContext = ((BindingProvider)endpoint).getRequestContext();
        if (ws_user != null) {
            requestContext.put("jakarta.xml.ws.security.auth.username", ws_user);
        }
        if (ws_password != null) {
            requestContext.put("jakarta.xml.ws.security.auth.password", ws_password);
        }
        if (ws_url == null) {
            throw new BGException("url for webservice \"" + urlparamname + "\" undefined");
        }
        requestContext.put("jakarta.xml.ws.service.endpoint.address", ws_url);
        requestContext.put("com.sun.xml.ws.transport.https.client.hostname.verifier", EyelessHostnameVerifier.INSTANCE);
        requestContext.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", EyelessSSLSocketFactory.INSTANCE);
        requestContext.put("com.sun.xml.ws.connect.timeout", 10000);
        log.info("succesfull setup webservice " + urlparamname + ": " + endpoint);
    }

    private Con getConnection(Integer serverId, UserCard userCard) throws BGException {
        Con con = this.connections.get(serverId);
        if (con == null) {
            ParameterMap moduleSetup = this.getModuleSetup(userCard);
            try {
                ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
                con = new Con();
                con.subscription = new SubscriptionWebService().getSubscriptionServiceEndpointPort();
                Conax4ServiceActivator.setupws(con.subscription, "subscription", connectionSetup);
                con.messaging = new UserTextMessagingWebService().getUserTextMessagingServiceEndpointPort();
                Conax4ServiceActivator.setupws(con.messaging, "messaging", connectionSetup);
                con.administration = new CaClientAdministrationWebService().getCaClientAdministrationServiceEndpointPort();
                Conax4ServiceActivator.setupws(con.administration, "administration", connectionSetup);
                con.pairing = new PairingWebService().getPairingServiceEndpointPort();
                Conax4ServiceActivator.setupws(con.pairing, "pairing", connectionSetup);
                con.osdDuration = connectionSetup.getInt("osdDuration", 30);
                con.emmDeliveryMethod = connectionSetup.get("emmDeliveryMethod", "OVER_AIR");
                con.withoutDateMode = connectionSetup.getBoolean("withoutDateMode", false);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
            this.connections.put(serverId, con);
        }
        return con;
    }

    public Conax4ServiceActivator(ParameterMap moduleSetup, Connection conMaster, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, conMaster, conSlave, mid, time);
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.subscription.AbstractResponseType response) {
        if ("OK".equalsIgnoreCase(response.getTransactionStatus().getStatusCode())) {
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(false, response.getTransactionStatus().getStatusCode() + ": " + response.getTransactionStatus().getMessage());
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(AbstractResponseType response) {
        if ("OK".equalsIgnoreCase(response.getTransactionStatus().getStatusCode())) {
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(false, response.getTransactionStatus().getStatusCode() + ": " + response.getTransactionStatus().getMessage());
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.administration.AbstractResponseType response) {
        if ("OK".equalsIgnoreCase(response.getTransactionStatus().getStatusCode())) {
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(false, response.getTransactionStatus().getStatusCode() + ": " + response.getTransactionStatus().getMessage());
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.pairing.AbstractResponseType response) {
        if ("OK".equalsIgnoreCase(response.getTransactionStatus().getStatusCode())) {
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(false, response.getTransactionStatus().getStatusCode() + ": " + response.getTransactionStatus().getMessage());
    }

    private static String formatDate(Date date) {
        return date != null ? new SimpleDateFormat("YYYY-MM-dd").format(date) : null;
    }

    private static SubscriptionType buildSubscriptionType(long cardNumber, String packetCode, Date date1, Date date2) {
        SubscriptionType subscription = new SubscriptionType();
        subscription.setCaClientId(String.valueOf(cardNumber));
        subscription.setProductId(packetCode);
        SubscriptionPeriodType period = null;
        if (date1 != null || date2 != null) {
            Date prepDate1 = TimeUtils.getStartMonth((Date)new Date());
            Date prepDate2 = date2 != null ? TimeUtils.getEndMonth((Date)date2) : null;
            log.info(String.format("buildSubscriptionType: prepare dates %s-%s -> %s-%s", Conax4ServiceActivator.formatDate(date1), Conax4ServiceActivator.formatDate(date2), Conax4ServiceActivator.formatDate(prepDate1), Conax4ServiceActivator.formatDate(prepDate2)));
            period = new SubscriptionPeriodType();
            period.setStartDate(Conax4ServiceActivator.formatDate(prepDate1));
            period.setEndDate(Conax4ServiceActivator.formatDate(prepDate2));
        }
        subscription.setSubscriptionPeriod(period);
        return subscription;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        log.info("Modify card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        try {
            Con con = this.getConnection(0, card);
            if (con.withoutDateMode) {
                return this._modifyWithoutDate(con, card, cardPacketList);
            }
            return this._modifyWithDate(con, card, cardPacketList);
        }
        catch (Exception ex) {
            log.error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    private DigitalTVServiceActivator.ServiceActivationResult _modifyWithoutDate(Con con, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        List<DigitalTVServiceActivator.CardPacketCodePair> cpcl = this.getCardPacketCodePairList(cardPacketList, false, true);
        return this.smartSynchronize(con, card.getNumber(), cpcl);
    }

    private DigitalTVServiceActivator.ServiceActivationResult smartSynchronize(Con con, long cardNumber, List<DigitalTVServiceActivator.CardPacketCodePair> billingSubscription) {
        Object subscriptions;
        ArrayList<Subscr> casSubscription = new ArrayList<Subscr>();
        DigitalTVServiceActivator.ServiceActivationResult result = Conax4ServiceActivator._getActiveSubscriptions(con, cardNumber, casSubscription);
        if (result != DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) {
            return result;
        }
        ArrayList<DigitalTVServiceActivator.CardPacketCodePair> toAdd = new ArrayList<DigitalTVServiceActivator.CardPacketCodePair>();
        ArrayList toCancel = new ArrayList();
        Conax4ServiceActivator.subscribeEqualizer(billingSubscription, casSubscription, toAdd, toCancel, new Conax4SubscriptionInfoWithoutDateComparator());
        if (!toCancel.isEmpty()) {
            CancelSubscriptionsRequestType cancelSubscriptionsRequest = new CancelSubscriptionsRequestType();
            cancelSubscriptionsRequest.setEmmDeliveryMethod(EmmDeliveryType.fromValue(con.emmDeliveryMethod));
            subscriptions = new CancelSubscriptionsRequestType.Subscriptions();
            for (Subscr s : toCancel) {
                log.debug("cancel packetCode=" + s.packet);
                ((CancelSubscriptionsRequestType.Subscriptions)subscriptions).getSubscription().add(Conax4ServiceActivator.buildSubscriptionType(cardNumber, s.packet, null, null));
            }
            cancelSubscriptionsRequest.setSubscriptions((CancelSubscriptionsRequestType.Subscriptions)subscriptions);
            result = Conax4ServiceActivator.checkAnswer(con.subscription.cancelSubscriptions(cancelSubscriptionsRequest));
            if (result != DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) {
                return result;
            }
        }
        if (!toAdd.isEmpty()) {
            AddSubscriptionsRequestType addSubscriptionsRequest = new AddSubscriptionsRequestType();
            addSubscriptionsRequest.setEmmDeliveryMethod(EmmDeliveryType.fromValue(con.emmDeliveryMethod));
            subscriptions = new AddSubscriptionsRequestType.Subscriptions();
            for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : toAdd) {
                log.debug("add packetCode=" + pairCardPacketPacketCode.packetCode);
                ((AddSubscriptionsRequestType.Subscriptions)subscriptions).getSubscription().add(Conax4ServiceActivator.buildSubscriptionType(pairCardPacketPacketCode.cardnumber, pairCardPacketPacketCode.packetCode, null, null));
            }
            addSubscriptionsRequest.setSubscriptions((AddSubscriptionsRequestType.Subscriptions)subscriptions);
            result = Conax4ServiceActivator.checkAnswer(con.subscription.addSubscriptions(addSubscriptionsRequest));
            if (result != DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) {
                return result;
            }
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    private DigitalTVServiceActivator.ServiceActivationResult _modifyWithDate(Con con, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        DigitalTVServiceActivator.ServiceActivationResult result = Conax4ServiceActivator._cancelAllSubscriptions(con, card.getNumber());
        if (result != DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) {
            return result;
        }
        AddSubscriptionsRequestType addSubscriptionsRequest = new AddSubscriptionsRequestType();
        addSubscriptionsRequest.setEmmDeliveryMethod(EmmDeliveryType.fromValue(con.emmDeliveryMethod));
        AddSubscriptionsRequestType.Subscriptions subscriptions = new AddSubscriptionsRequestType.Subscriptions();
        for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : this.getCardPacketCodePairList(cardPacketList, false, true)) {
            CardPacket cardPacket = pairCardPacketPacketCode.cardpacket;
            Date date1 = cardPacket.getDateFrom();
            Date date2 = cardPacket.getDateTo();
            subscriptions.getSubscription().add(Conax4ServiceActivator.buildSubscriptionType(pairCardPacketPacketCode.cardnumber, pairCardPacketPacketCode.packetCode, date1, date2));
        }
        if (subscriptions.getSubscription().isEmpty()) {
            log.debug("empty subscriptions list, return ok");
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        addSubscriptionsRequest.setSubscriptions(subscriptions);
        return Conax4ServiceActivator.checkAnswer(con.subscription.addSubscriptions(addSubscriptionsRequest));
    }

    private static DigitalTVServiceActivator.ServiceActivationResult _cancelAllSubscriptions(Con con, long cardNumber) {
        log.info("cancelAllSubscriptions card: " + cardNumber);
        ArrayList<Subscr> list = new ArrayList<Subscr>();
        DigitalTVServiceActivator.ServiceActivationResult result = Conax4ServiceActivator._getActiveSubscriptions(con, cardNumber, list);
        if (result != DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) {
            return result;
        }
        CancelSubscriptionsRequestType cancelSubscriptionsRequest = new CancelSubscriptionsRequestType();
        cancelSubscriptionsRequest.setEmmDeliveryMethod(EmmDeliveryType.fromValue(con.emmDeliveryMethod));
        CancelSubscriptionsRequestType.Subscriptions subscriptions = new CancelSubscriptionsRequestType.Subscriptions();
        for (Subscr s : list) {
            log.info("add packetCode=" + s.packet);
            subscriptions.getSubscription().add(Conax4ServiceActivator.buildSubscriptionType(cardNumber, s.packet, null, null));
        }
        if (subscriptions.getSubscription().isEmpty()) {
            log.info("empty subscriptions list, return ok");
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        cancelSubscriptionsRequest.setSubscriptions(subscriptions);
        return Conax4ServiceActivator.checkAnswer(con.subscription.cancelSubscriptions(cancelSubscriptionsRequest));
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        log.info("Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        try {
            Con con = this.getConnection(0, card);
            return Conax4ServiceActivator._cancelAllSubscriptions(con, card.getNumber());
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardCode) throws BGException {
        log.info("Closing card " + cardCode);
        try {
            Con con = this.getConnection(0, null);
            return Conax4ServiceActivator._cancelAllSubscriptions(con, cardCode);
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) throws BGException {
        try {
            return this.sendMessage2(cardNumbers, message, ismail);
        }
        catch (Exception ex) {
            log.error("Exception sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    private DigitalTVServiceActivator.ServiceActivationResult sendMessage2(List<Long> cardNumbers, String message, boolean ismail) throws BGException {
        ArrayList<String> caClientIds = new ArrayList<String>();
        if (cardNumbers == null) {
            caClientIds.addAll(this.userCardManager.getListByDate(Calendar.getInstance()).stream().map(f -> String.valueOf(f.getNumber())).collect(Collectors.toList()));
        } else {
            for (Long cardNumber : cardNumbers) {
                String caClientId = String.valueOf(cardNumber);
                caClientIds.add(caClientId);
            }
        }
        if (ismail) {
            for (String caClientId : caClientIds) {
                userCard = this.userCardManager.getUserCard((long)Long.valueOf(caClientId), Calendar.getInstance());
                Con con = this.getConnection(0, userCard);
                log.debug("send mail message to card: " + caClientId);
                SendMailboxMessageToClientRequestType sendMailboxMessageToClientRequest = new SendMailboxMessageToClientRequestType();
                sendMailboxMessageToClientRequest.setCaClientId(caClientId);
                sendMailboxMessageToClientRequest.setMessage(message);
                DigitalTVServiceActivator.ServiceActivationResult result = Conax4ServiceActivator.checkAnswer(con.messaging.sendMailboxMessageToClient(sendMailboxMessageToClientRequest));
                if (result == DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) continue;
                return result;
            }
        } else {
            for (String caClientId : caClientIds) {
                userCard = this.userCardManager.getUserCard((long)Long.valueOf(caClientId), Calendar.getInstance());
                Con con = this.getConnection(0, userCard);
                log.debug("send osd message to card: " + caClientId);
                SendBarkMessageToClientRequestType sendBarkMessageToClientRequest = new SendBarkMessageToClientRequestType();
                sendBarkMessageToClientRequest.setCaClientId(caClientId);
                sendBarkMessageToClientRequest.setMessage(message);
                sendBarkMessageToClientRequest.setDisplayDurationInSeconds(con.osdDuration);
                DigitalTVServiceActivator.ServiceActivationResult result = Conax4ServiceActivator.checkAnswer(con.messaging.sendBarkMessageToClient(sendBarkMessageToClientRequest));
                if (result == DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) continue;
                return result;
            }
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    private DigitalTVServiceActivator.ServiceActivationResult sendMessage1(long cardNumber, String message, boolean mail) throws BGException {
        UserCard userCard = this.userCardManager.getUserCard(cardNumber, Calendar.getInstance());
        Con con = this.getConnection(0, userCard);
        ArrayList<CaClientIds> caClientIdsList = new ArrayList<CaClientIds>();
        if (cardNumber == -1L) {
            List allcardnumbers = this.userCardManager.getListByDate(Calendar.getInstance()).stream().map(f -> String.valueOf(f.getNumber())).collect(Collectors.toList());
            for (int ps = 0; ps < allcardnumbers.size() / 512 + 1; ++ps) {
                List sublist = allcardnumbers.subList(ps * 512, Math.min((ps + 1) * 512, allcardnumbers.size()));
                CaClientIds caClientIds = new CaClientIds();
                caClientIds.getCaClientId().addAll(sublist);
                caClientIdsList.add(caClientIds);
            }
        } else {
            CaClientIds caClientIds = new CaClientIds();
            caClientIds.getCaClientId().add(String.valueOf(cardNumber));
            caClientIdsList.add(caClientIds);
        }
        if (mail) {
            for (CaClientIds caClientIds : caClientIdsList) {
                log.debug("send mail message to " + caClientIds.getCaClientId().size() + " cards: " + Utils.toString(caClientIds.getCaClientId()));
                SendMailboxMessageToClientsRequestType sendMailboxMessageToClientsRequest = new SendMailboxMessageToClientsRequestType();
                sendMailboxMessageToClientsRequest.setCaClientIds(caClientIds);
                sendMailboxMessageToClientsRequest.setMessage(message);
                result = Conax4ServiceActivator.checkAnswer(con.messaging.sendMailboxMessageToClients(sendMailboxMessageToClientsRequest));
                if (result == DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) continue;
                return result;
            }
        } else {
            for (CaClientIds caClientIds : caClientIdsList) {
                log.debug("send osd message to " + caClientIds.getCaClientId().size() + " cards: " + Utils.toString(caClientIds.getCaClientId()));
                SendBarkMessageToClientsRequestType sendBarkMessageToClientsRequest = new SendBarkMessageToClientsRequestType();
                sendBarkMessageToClientsRequest.setCaClientIds(caClientIds);
                sendBarkMessageToClientsRequest.setMessage(message);
                sendBarkMessageToClientsRequest.setDisplayDurationInSeconds(con.osdDuration);
                result = Conax4ServiceActivator.checkAnswer(con.messaging.sendBarkMessageToClients(sendBarkMessageToClientsRequest));
                if (result == DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) continue;
                return result;
            }
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    private static DigitalTVServiceActivator.ServiceActivationResult _getActiveSubscriptions(Con con, long cardNumber, List<Subscr> list) {
        log.info("getActiveSubscriptions card: " + cardNumber);
        GetActiveSubscriptionsRequestType getActiveSubscriptionsRequest = new GetActiveSubscriptionsRequestType();
        getActiveSubscriptionsRequest.setCaClientId(String.valueOf(cardNumber));
        getActiveSubscriptionsRequest.setIncludeEmmDeliveryStatus(true);
        SubscriptionStatusResponseType response = con.subscription.getActiveSubscriptions(getActiveSubscriptionsRequest);
        DigitalTVServiceActivator.ServiceActivationResult result = Conax4ServiceActivator.checkAnswer(response);
        if (result != DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) {
            return result;
        }
        log.info("getActiveSubscriptions subscription items: " + response.getSubscriptionStatuses().getSubscriptionStatus().size());
        for (SubscriptionStatusType sst : response.getSubscriptionStatuses().getSubscriptionStatus()) {
            Subscr cp = new Subscr();
            cp.card = sst.getSubscription().getCaClientId();
            cp.packet = sst.getSubscription().getProductId();
            cp.date1 = sst.getSubscription().getSubscriptionPeriod().getStartDate();
            cp.date2 = sst.getSubscription().getSubscriptionPeriod().getEndDate();
            cp.emmstatus = sst.getEmmDeliveryAggregatedStatus();
            list.add(cp);
            log.info("subscr: " + cp.toString());
        }
        return result;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getSubscribeInfoImpl(long cardNumber) throws BGException {
        StringBuilder infotext = new StringBuilder(64);
        String logline1 = "get subscribe card: " + cardNumber;
        log.info(logline1);
        infotext.append(logline1).append("\n");
        try {
            for (int serverCode : this.serversManager.getServerCodes()) {
                UserCard userCard = this.userCardManager.getUserCard(cardNumber, Calendar.getInstance());
                Con con = this.getConnection(serverCode, userCard);
                infotext.append("server #").append(serverCode).append(":\n");
                ArrayList<Subscr> list = new ArrayList<Subscr>();
                DigitalTVServiceActivator.ServiceActivationResult result = Conax4ServiceActivator._getActiveSubscriptions(con, cardNumber, list);
                if (result != DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) {
                    infotext.append("Incorrect response status: ").append(result.getMessage()).append("\n");
                    continue;
                }
                if (list.size() == 0) {
                    infotext.append("none\n");
                }
                for (Subscr sst : list) {
                    infotext.append(sst.toString()).append("\n");
                }
            }
        }
        catch (Exception ex) {
            log.error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, infotext.toString(), null, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult parentalPinCodeImpl(long cardNumber, String pinCode) {
        log.info("pin code card: " + cardNumber);
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, Calendar.getInstance());
            Con con = this.getConnection(0, userCard);
            if (Utils.notBlankString((String)pinCode)) {
                UpdateCaPinToGivenValueRequestType updateCaPinToGivenValueRequest = new UpdateCaPinToGivenValueRequestType();
                updateCaPinToGivenValueRequest.setCaClientId(String.valueOf(cardNumber));
                updateCaPinToGivenValueRequest.setCaPin(pinCode);
                return Conax4ServiceActivator.checkAnswer(con.administration.updateCaPinToGivenValue(updateCaPinToGivenValueRequest));
            }
            UpdateCaPinToDefaultValueRequestType updateCaPinToDefaultValueRequest = new UpdateCaPinToDefaultValueRequestType();
            updateCaPinToDefaultValueRequest.setCaClientId(String.valueOf(cardNumber));
            return Conax4ServiceActivator.checkAnswer(con.administration.updateCaPinToDefaultValue(updateCaPinToDefaultValueRequest));
        }
        catch (Exception ex) {
            log.error("Exception parentalPinCodeImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getPairingImpl(long cardNumber) throws BGException {
        log.info("get pairing card: " + cardNumber);
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, Calendar.getInstance());
            Con con = this.getConnection(0, userCard);
            GetPairingStatusForCardRequestType getPairingStatusForCardRequest = new GetPairingStatusForCardRequestType();
            getPairingStatusForCardRequest.setCaClientId(String.valueOf(cardNumber));
            PairingStatusResponseType response = con.pairing.getPairingStatusForCard(getPairingStatusForCardRequest);
            DigitalTVServiceActivator.ServiceActivationResult result = Conax4ServiceActivator.checkAnswer(response);
            if (result != DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) {
                if ("PAIRING_NOT_FOUND".equalsIgnoreCase(response.getTransactionStatus().getStatusCode())) {
                    return new DigitalTVServiceActivator.ServiceActivationResult(true, null, null, null);
                }
                return result;
            }
            String pairingModule = null;
            PairingStatusType pairingStatus = response.getPairingStatus();
            List<String> pairingModuleIds = pairingStatus.getPairingModules().getPairingModuleId();
            if (!pairingModuleIds.isEmpty()) {
                if (pairingModuleIds.size() > 1) {
                    log.warn("pairing card " + cardNumber + " have multiple modules: " + Utils.toString(pairingModuleIds));
                }
                if ((pairingModule = pairingModuleIds.get(0)).length() < 11) {
                    pairingModule = String.format("%11s", pairingModule).replace(' ', '0');
                }
            }
            return new DigitalTVServiceActivator.ServiceActivationResult(true, pairingModule, null, null);
        }
        catch (Exception ex) {
            log.error("Exception getPairingImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 pairing \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult setPairingImpl(long cardNumber, String pairingModule) throws BGException {
        log.info("set pairing card: " + cardNumber + ":" + pairingModule);
        try {
            if (pairingModule == null) {
                log.debug("ignore clear pairing card: " + cardNumber);
                return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
            }
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, Calendar.getInstance());
            Con con = this.getConnection(0, userCard);
            CreatePairingRequestType createPairingRequest = new CreatePairingRequestType();
            CreatePairingRequestType.SmartCards smartcards = new CreatePairingRequestType.SmartCards();
            smartcards.getCaClientId().add(String.valueOf(cardNumber));
            CreatePairingRequestType.PairingModules pairingmodules = new CreatePairingRequestType.PairingModules();
            pairingmodules.getPairingModuleId().add(pairingModule);
            createPairingRequest.setSmartCards(smartcards);
            createPairingRequest.setPairingModules(pairingmodules);
            createPairingRequest.setEmmDeliveryMethod(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax4.ws.pairing.EmmDeliveryType.fromValue(con.emmDeliveryMethod));
            return Conax4ServiceActivator.checkAnswer(con.pairing.createPairing(createPairingRequest));
        }
        catch (Exception ex) {
            log.error("Exception setPairingImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 pairing \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    private class Con {
        SubscriptionServiceEndpoint subscription;
        UserTextMessagingServiceEndpoint messaging;
        CaClientAdministrationServiceEndpoint administration;
        PairingServiceEndpoint pairing;
        int osdDuration;
        String emmDeliveryMethod;
        boolean withoutDateMode;

        private Con() {
        }
    }

    private static class Conax4SubscriptionInfoWithoutDateComparator
    implements DigitalTVServiceActivator.SubscriptionComparatorForEqualizer<Subscr> {
        private Conax4SubscriptionInfoWithoutDateComparator() {
        }

        @Override
        public boolean subscriptionEquals(DigitalTVServiceActivator.CardPacketCodePair bgCardpacket, Subscr casPacket) {
            return bgCardpacket.packetCode.trim().equals(casPacket.packet);
        }
    }

    private static class Subscr {
        String card;
        String packet;
        String date1;
        String date2;
        String emmstatus;

        private Subscr() {
        }

        public String toString() {
            String date1 = this.date1 != null ? this.date1 : "...";
            String date2 = this.date2 != null ? this.date2 : "...";
            return String.format("card: %s, packet: %s, period: %s-%s, emmstatus: %s", this.card, this.packet, date1, date2, this.emmstatus);
        }
    }
}

