/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.server.finder;

import java.sql.Connection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.GetIndexPoint;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrHouse;
import ru.bitel.bgbilling.plugins.cladr.server.dao.CladrStreetDAO;
import ru.bitel.common.Utils;

public class IndexFinder
implements GetIndexPoint {
    private static int LEVEL_1 = 1;
    private static int LEVEL_2 = 2;
    private static int LEVEL_3 = 3;
    private static int LEVEL_4 = 4;
    private static int LEVEL_NONE = -11;

    public String getIndex(Connection con, Logger log, int streetId, int house, String frac) {
        String curIndex = "";
        try {
            CladrStreetDAO streetDAO = new CladrStreetDAO(con, log);
            String code = streetDAO.getStreetCode(streetId);
            if (code == null) {
                return "";
            }
            List<CladrHouse> houses = streetDAO.getHouseByCode(code);
            int curLevel = 100;
            for (CladrHouse houseItem : houses) {
                String[] addresses;
                for (String address : addresses = houseItem.getName().split(",")) {
                    int level = this.findInsert(address, house, frac);
                    if (level == LEVEL_NONE) continue;
                    if (level < curLevel) {
                        curIndex = houseItem.getIndex();
                    }
                    if (level != LEVEL_1) continue;
                    return curIndex;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return curIndex;
    }

    private int findInsert(String address, int house, String frac) {
        int level = LEVEL_NONE;
        level = this.chetNechet(address, house);
        if (level != LEVEL_NONE) {
            return level;
        }
        level = this.diapazon(address, house);
        if (level != LEVEL_NONE) {
            return level;
        }
        level = this.number(address, house);
        if (level != LEVEL_NONE) {
            return level;
        }
        level = this.numberFrac(address, house, frac);
        return level;
    }

    private int chetNechet(String address, int house) {
        String regex = null;
        regex = house % 2 == 0 ? "\u0427" : "\u041d";
        if (address.matches(regex)) {
            return LEVEL_4;
        }
        return LEVEL_NONE;
    }

    private int diapazon(String address, int house) {
        Pattern pattern;
        Matcher m;
        boolean flag = false;
        String regex = "\\d+-\\d+";
        if (address.matches(regex)) {
            flag = true;
        }
        if (address.matches(regex = house % 2 == 0 ? "\u0427\\(\\d+-\\d+\\)" : "\u041d\\(\\d+-\\d+\\)")) {
            flag = true;
        }
        if (flag && (m = (pattern = Pattern.compile("(\\d+)-(\\d+)")).matcher(address)).find()) {
            if (m.groupCount() < 2) {
                return LEVEL_NONE;
            }
            int first = Utils.parseInt((String)m.group(1));
            int second = Utils.parseInt((String)m.group(2));
            if (house >= first) {
                if (second == 999) {
                    return LEVEL_3;
                }
                if (house <= second) {
                    return LEVEL_3;
                }
            }
        }
        return LEVEL_NONE;
    }

    private int number(String address, int house) {
        int num;
        String regex = "\\d+";
        if (address.matches(regex) && (num = Utils.parseInt((String)address)) == house) {
            return LEVEL_2;
        }
        return LEVEL_NONE;
    }

    private int numberFrac(String address, int house, String frac) {
        String houseStr;
        String regex = "(\\d+)/*(\\w+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(address);
        if (m.find()) {
            if (m.groupCount() < 2) {
                return LEVEL_NONE;
            }
            int num = Utils.parseInt((String)m.group(1));
            String fracAddr = m.group(2);
            if (num == house && fracAddr.equals(frac)) {
                return LEVEL_1;
            }
        }
        if (!Utils.isEmptyString((String)frac) && address.equals(houseStr = house + frac)) {
            return LEVEL_1;
        }
        return LEVEL_NONE;
    }
}

