/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.edo.common.bean.Signatory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.CollectionMapConverter;
import ru.bitel.common.model.Pair;

public class SignatoryDao
extends AbstractIdDao<Signatory> {
    public SignatoryDao(Connection con) {
        super(con, 0, "edo_signatory");
    }

    public List<Signatory> getListAll() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public Map<Integer, Signatory> getMapAll() throws BGException {
        return new CollectionMapConverter<Signatory, Integer, Signatory>(){

            protected Pair<Integer, Signatory> convert(Signatory f) {
                return new Pair((Object)f.getId(), (Object)f);
            }
        }.getMap(this.getListAll());
    }

    protected Signatory getFromRS(ResultSet rs) throws SQLException, BGException {
        Signatory document = new Signatory();
        document.setId(rs.getInt(this.tableName + ".id"));
        document.setTitle(rs.getString(this.tableName + ".title"));
        document.setConfig(rs.getString(this.tableName + ".config"));
        return document;
    }

    protected void updateImpl(Signatory b) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (b.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (title, config) VALUES (?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET title=?, config=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(3, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setString(2, b.getConfig());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }
}

