/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ServiceConfigManager
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private BGControlPanelPeriodNoB filterPeriodPanel = new BGControlPanelPeriodNoB();
    private BGSelectFilePanel fileSelect = new BGSelectFilePanel();
    private BGControlPanelDateNoB dateFullPanel = new BGControlPanelDateNoB();
    private BGControlPanelPeriodNoB dateDiffPeriodPanel = new BGControlPanelPeriodNoB();
    private BGComboBox<ComboBoxItem> tagFullCB = new BGComboBox();
    private BGComboBox<ComboBoxItem> tagDiffCB = new BGComboBox();

    public ServiceConfigManager() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "register");
        Calendar now = new GregorianCalendar();
        this.filterPeriodPanel.setDateCalendar2(now);
        now = (Calendar)now.clone();
        now.add(6, -1);
        this.filterPeriodPanel.setDateCalendar1(now);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridBagLayout());
        filterPanel.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        filterPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.filterPeriodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add(Box.createHorizontalStrut(1), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        JButton doFilterButton = new JButton(">>>");
        filterPanel.add((Component)doFilterButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        doFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigManager.this.setData();
            }
        });
        topPanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel fullPanel = new JPanel();
        fullPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0435\u0441\u0442\u0440 7"));
        fullPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)fullPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        fullPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        fullPanel.add((Component)this.dateFullPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        fullPanel.add((Component)new JLabel("\u0442\u0435\u0433: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        fullPanel.add((Component)this.tagFullCB, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JButton doFullButton = new JButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        doFullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigManager.this.createFullRegister();
            }
        });
        fullPanel.add((Component)doFullButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel diffPanel = new JPanel();
        diffPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0435\u0441\u0442\u0440\u044b 3 \u0438 9"));
        diffPanel.setLayout(new GridBagLayout());
        diffPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        diffPanel.add((Component)this.dateDiffPeriodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        diffPanel.add((Component)new JLabel("\u0442\u0435\u0433: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        diffPanel.add((Component)this.tagDiffCB, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JButton doDiffButton = new JButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        doDiffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigManager.this.createDiffRegister();
            }
        });
        diffPanel.add((Component)doDiffButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        topPanel.add((Component)diffPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel savePanel = new JPanel();
        savePanel.setBorder((Border)new BGTitleBorder("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0435\u0441\u0442\u0440"));
        savePanel.setLayout(new GridBagLayout());
        savePanel.add((Component)this.fileSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        JButton saveButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigManager.this.saveRegister();
            }
        });
        savePanel.add((Component)saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        topPanel.add((Component)savePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane tableScroll = new JScrollPane();
        tableScroll.setViewportView((Component)this.table);
        this.add(tableScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void createFullRegister() {
        String date = this.dateFullPanel.getDateString();
        if (Utils.isEmptyString((String)date)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
            return;
        }
        ComboBoxItem tag = (ComboBoxItem)this.tagFullCB.getSelectedItem();
        if (tag == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0435\u0433");
            return;
        }
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("CreateFullRegister");
        req.setAttribute("date", date);
        req.setAttribute("tag", tag.getObject());
        if (ClientUtils.checkStatus((Document)this.getDocument(req))) {
            this.setData();
        }
    }

    private void createDiffRegister() {
        String date1 = this.dateDiffPeriodPanel.getDateString1();
        String date2 = this.dateDiffPeriodPanel.getDateString2();
        if (Utils.isEmptyString((String)date1) || Utils.isEmptyString((String)date2)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u044b");
            return;
        }
        ComboBoxItem tag = (ComboBoxItem)this.tagDiffCB.getSelectedItem();
        if (tag == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0435\u0433");
            return;
        }
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("CreateDiffRegister");
        req.setAttribute("date1", date1);
        req.setAttribute("date2", date2);
        req.setAttribute("tag", tag.getObject());
        if (ClientUtils.checkStatus((Document)this.getDocument(req))) {
            this.setData();
        }
    }

    private void saveRegister() {
        File file = this.fileSelect.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f");
            return;
        }
        String id = ClientUtils.getRowId((BGTable)this.table);
        if (id != null) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("GetRegister");
            request.setAttribute("id", id);
            request.setAttribute("contentType", "binary");
            byte[] data = this.getBytes(request);
            if (data != null && data.length > 0) {
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(data);
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setData() {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("RegisterTable");
        req.setAttribute("date1", this.filterPeriodPanel.getDateString1());
        req.setAttribute("date2", this.filterPeriodPanel.getDateString2());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData((Node)XMLUtils.getElement((Document)doc, (String)"table"));
        }
    }

    private void init() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("TagGetList");
        req.setAttribute("mode", 20);
        req.setModuleId(this.getModuleId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element directory = XMLUtils.selectElement((Node)doc, (String)"/data/table/data");
            ClientUtils.buildComboBox(this.tagFullCB, (Node)directory, (String)"");
            ClientUtils.buildComboBox(this.tagDiffCB, (Node)directory, (String)"");
        }
    }
}

