/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.hd.server.bean.Period;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class PeriodManager {
    private Connection con;
    private String tableName;

    public PeriodManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_period_" + mid;
    }

    public Period getPeriod(int id) {
        Period result = null;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getPeriodFromRS(rs);
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Period getPeriodFromRS(ResultSet rs) throws SQLException {
        Period result = new Period();
        result.setId(rs.getInt("id"));
        result.setTimeCol(rs.getInt("time_col"));
        result.setTimeType(rs.getInt("time_type"));
        result.setTitle(rs.getString("title"));
        result.setType(rs.getInt("type"));
        return result;
    }

    public List<Period> getPeriodList(int type) {
        ArrayList<Period> result = new ArrayList<Period>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE type=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getPeriodFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Period> getPeriodList() {
        ArrayList<Period> result = new ArrayList<Period>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getPeriodFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Period> getPeriodList(String idList) {
        ArrayList<Period> result = new ArrayList<Period>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + idList + ") ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getPeriodFromRS(rs));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, Period> getPeriodMap() {
        HashMap<Integer, Period> result = new HashMap<Integer, Period>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Period period = this.getPeriodFromRS(rs);
                result.put(period.getId(), period);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updatePeriod(Period p) {
        try {
            PreparedStatement ps;
            if (p.getId() <= 0) {
                ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (time_col, time_type, title, type) VALUES (?,?,?,?)");
            } else {
                ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET time_col=?, time_type=?, title=?, type=? WHERE id=?");
                ps.setInt(5, p.getId());
            }
            ps.setInt(1, p.getTimeCol());
            ps.setInt(2, p.getTimeType());
            ps.setString(3, p.getTitle());
            ps.setInt(4, p.getType());
            ps.executeUpdate();
            if (p.getId() <= 0) {
                p.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

