/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.hd.common.bean.ZoneUtils;
import ru.bitel.bgbilling.modules.hd.common.bean.ZoneWhois;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ZoneWhoisDao
extends AbstractIdDao<ZoneWhois> {
    public ZoneWhoisDao(Connection con, int moduleId) {
        super(con, moduleId, "hd_zone");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("zone", "zone");
        this.fields.put("registrar", "whois_registrar");
        this.fields.put("freeDate", "free_date");
        this.fields.put("whoisLastUpdate", "whois_last_update");
    }

    public void searchZoneWhoisList(SearchResult<ZoneWhois> searchResult, String zoneMask, boolean actualy) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            String[] sortFields = searchResult.getSort();
            List list = searchResult.getList();
            try {
                String query = "SELECT zw.id, contract_id, zone, whois, whois_last_update, whois_registrar, date_from, date_to, free_date, c.title FROM " + this.tableName + " AS zw LEFT JOIN contract AS c ON zw.contract_id=c.id  WHERE  true" + (actualy ? " AND ( date_from IS NULL OR date_from < ? ) AND ( date_to IS NULL OR date_to > ? )" : "") + (Utils.notBlankString((String)zoneMask) ? " AND zone LIKE ?" : "") + this.getSQLOrder(sortFields, this.fields) + page.sqlLimit();
                int parameterIndex = 1;
                java.sql.Date date = TimeUtils.convertDateToSqlDate((Date)new Date());
                PreparedStatement ps = this.con.prepareStatement(query);
                this.setWhere(actualy, zoneMask, ps, parameterIndex, date);
                ResultSet resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    ZoneWhois zoneWhois = this.getFromRS(resultSet);
                    zoneWhois.setContractTitle(resultSet.getString("c.title"));
                    list.add(zoneWhois);
                }
                resultSet.close();
                ps.close();
                query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE  true" + (actualy ? " AND ( date_from IS NULL OR date_from < ? ) AND ( date_to IS NULL OR date_to > ? )" : "") + (Utils.notBlankString((String)zoneMask) ? " AND zone LIKE ?" : "");
                ps = this.con.prepareStatement(query);
                this.setWhere(actualy, zoneMask, ps, parameterIndex, date);
                resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    page.setRecordCount(resultSet.getInt(1));
                }
                resultSet.close();
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    private void setWhere(boolean actualy, String zoneMask, PreparedStatement ps, int parameterIndex, java.sql.Date date) throws SQLException {
        if (actualy) {
            ps.setDate(parameterIndex++, date);
            ps.setDate(parameterIndex++, date);
        }
        if (Utils.notBlankString((String)zoneMask)) {
            ps.setString(parameterIndex++, zoneMask.replace('*', '%'));
        }
    }

    protected ZoneWhois getFromRS(ResultSet rs) throws SQLException, BGException {
        ZoneWhois zoneWhois = new ZoneWhois();
        zoneWhois.setId(rs.getInt("id"));
        zoneWhois.setContractId(rs.getInt("contract_id"));
        zoneWhois.setZone(rs.getString("zone"));
        zoneWhois.setLoadWhois(rs.getBoolean("whois"));
        zoneWhois.setWhoisLastUpdate((Date)rs.getTimestamp("whois_last_update"));
        zoneWhois.setFreeDate((Date)rs.getDate("free_date"));
        zoneWhois.setRegistrar(rs.getString("whois_registrar"));
        zoneWhois.setPeriod(this.getPeriod(rs));
        return zoneWhois;
    }

    protected void updateImpl(ZoneWhois zoneWhois) throws BGException, SQLException {
    }

    public String getWhoisData(int zoneId) throws BGException {
        String whoisData = null;
        String query = "SELECT config FROM " + this.tableName + " WHERE id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, zoneId);
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                whoisData = ZoneUtils.getConfigValue((String)resultSet.getString(1), (String)"whois");
            }
            resultSet.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return whoisData;
    }
}

