/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action;

import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.common.Utils;

public class ActionUpdateMessage
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        String id = this.getParameter("id");
        if (id == null) {
            throw new BGIllegalArgumentException();
        }
        String body = this.getParameter("body");
        int topicId = this.getIntParameter("topicId", 0);
        if (id.equals("new") && topicId <= 0) {
            throw new BGIllegalArgumentException();
        }
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Message message = null;
        message = id.equals("new") ? Message.builder().setTopicId(topicId).setUserIdFrom(this.userId.intValue()).setDateFrom(new Date()).build() : topicManager.getMessage(Utils.parseInt((String)id, (int)0));
        if (message != null) {
            message.setBody(body);
            topicManager.updateMessage(id, message);
            List fileIds = Utils.toIntegerList((String)this.getParameter("fileIds"));
            if (!fileIds.isEmpty()) {
                int messageId = message.getId();
                HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
                Iterator iterator = fileIds.iterator();
                while (iterator.hasNext()) {
                    int fileId = (Integer)iterator.next();
                    BGServerFile serverFile = fileStorage.getFileById(fileId);
                    serverFile.setOwnerId(messageId);
                    fileStorage.updateFile(serverFile);
                }
            }
            Topic topic = topicManager.getTopic(message.getTopicId());
            if ("new".equals(id)) {
                topicManager.sendNotification(topic, message);
            }
            Element messageEl = this.createElement(this.rootNode, "message");
            messageEl.setAttribute("topicId", String.valueOf(message.getTopicId()));
            messageEl.setAttribute("id", String.valueOf(message.getId()));
            messageEl.setAttribute("userMy", topic.getUserId() == -1 ? "none" : (topic.getUserId() == this.userId.intValue() ? "my" : "notmy"));
        }
    }
}

