/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.service;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.system.HelpDeskMessageForContractEvent;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.ChangeManager;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.FileInfo;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.common.dto.ContractModeDTO;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.HelpDeskDirectoryManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ManagerChangeManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ParamManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.event.TopicWillBeCreated;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.plugins.helpdesk.server.mail.MailMessageNotification;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.EmailNotification;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.TelegramNotification;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService")
public class HelpdeskServiceImpl
extends AbstractService
implements HelpdeskService {
    private static BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
    @Resource
    private ReserveService reserveService;
    private BalanceDao balanceDao;
    private TopicManager topicManager;
    private ContractDao contractDao;

    private TopicManager getTopicManager() {
        if (this.topicManager == null) {
            this.topicManager = new TopicManager(this.getConnection(), BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk"));
        }
        return this.topicManager;
    }

    private BalanceDao getBalanceDao() {
        if (this.balanceDao == null) {
            this.balanceDao = new BalanceDao(this.getConnection());
        }
        return this.balanceDao;
    }

    private ContractDao getContractDao() {
        if (this.contractDao == null) {
            this.contractDao = new ContractDao(this.getConnection(), this.userId);
        }
        return this.contractDao;
    }

    @PreDestroy
    private void destroy() {
        try {
            if (this.contractDao != null) {
                this.contractDao.close();
                this.contractDao = null;
            }
            if (this.balanceDao != null) {
                this.balanceDao.close();
                this.balanceDao = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public int reservStatusUpdate(int topicId, int reserveStatus) throws BGException, BGMessageException {
        Topic topic = this.getTopicManager().getTopic(topicId);
        if (topic.isClosed()) {
            throw new BGMessageException("\u0423 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0435\u043c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430.");
        }
        Reserve reserveOld = this.getTopicManager().getReserveOnTopic(topicId);
        int reserveStatusOld = this.getTopicManager().getReserveStatus(topicId);
        if (reserveStatusOld == reserveStatus && reserveOld != null && reserveOld.getSum().compareTo(topic.getCost()) == 0 || reserveOld == null && reserveStatusOld == reserveStatus && (reserveStatus == 0 || reserveStatus == 1)) {
            return 0;
        }
        if (!(ReserveDao.flagReserve || reserveStatus != 2 && reserveStatus != 1)) {
            throw new BGMessageException("\u0412\u043b\u0438\u044f\u043d\u0438\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e! \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
        }
        if (reserveStatus == 2) {
            Contract contract = (Contract)this.getContractDao().get(topic.getContractId());
            if (contract.isDependSub()) {
                contract = (Contract)this.getContractDao().get(contract.getSuperCid());
            }
            Calendar calendar = Calendar.getInstance();
            BigDecimal balance = this.getBalanceDao().getBalance(contract.getId(), calendar.get(1), calendar.get(2) + 1);
            BigDecimal sumChange = reserveOld != null ? topic.getCost().subtract(reserveOld.getSum()) : topic.getCost();
            if (contract.getBalanceLimit().compareTo(balance.subtract(sumChange)) == -1) {
                Reserve reserve;
                if (reserveOld != null) {
                    reserveOld.setSum(topic.getCost());
                    reserve = reserveOld;
                } else {
                    int reserveTypeId = this.getSetup().getInt("topic.reserve.type.id", -1);
                    if (reserveTypeId < 1) {
                        List list = this.reserveService.reserveTypeList(true);
                        int n = reserveTypeId = list.size() > 0 ? ((ReserveType)list.get(0)).getId() : -1;
                    }
                    if (reserveTypeId < 1) {
                        throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0440\u0435\u0437\u0435\u0440\u0432\u0430 \u0434\u043b\u044f \u0442\u0435\u043c\u044b \u0438 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u044e\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0442\u0438\u043f\u044b \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432");
                    }
                    reserve = new Reserve(0, topic.getContractId(), reserveTypeId, null, null, topic.getCost(), "\u0421\u043e\u0437\u0434\u0430\u043d \u0432 \u0442\u0435\u043c\u0435 - \"" + topic.getTitle() + "\" c \u043d\u043e\u043c\u0435\u0440\u043e\u043c - " + topic.getId());
                }
                return this.getTopicManager().updateTopicReservStatus(topicId, reserveStatus, this.reserveService.updateReserve(reserve));
            }
            reserveStatus = 1;
        }
        if (reserveStatus == 1 || reserveStatus == 0) {
            if (reserveOld != null) {
                String statusStr = reserveStatus == 1 ? "\"\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435\"" : "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
                reserveOld.setComment(reserveOld.getComment() + " || \u0417\u0430\u043a\u0440\u044b\u0442 \u043f\u043e \u043f\u0440\u0438\u0447\u0438\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043d\u0430 " + statusStr);
                this.reserveService.updateReserve(reserveOld);
                this.reserveService.closeReserve(reserveOld.getId());
            }
            return this.getTopicManager().updateTopicReservStatus(topicId, reserveStatus, null);
        }
        return 0;
    }

    public int reserveStatusGet(int topicId) throws BGException {
        return this.getTopicManager().getReserveStatus(topicId);
    }

    public int topicCostUpdate(int topicId, BigDecimal sum) throws BGException {
        if (sum.compareTo(BigDecimal.ZERO) == -1) {
            throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
        }
        Topic topic = this.getTopicManager().getTopic(topicId);
        BigDecimal oldSum = topic.getCost();
        if (oldSum.compareTo(sum) == 0) {
            return 0;
        }
        topic.setCost(sum);
        return this.getTopicManager().updateTopic(topic);
    }

    public int topicNotificationUpdate(int topicId, int mode, String value) throws BGException {
        Topic topic = this.getTopicManager().getTopic(topicId);
        topic.setComm(mode);
        topic.setCommValue(value);
        return this.getTopicManager().updateTopic(topic);
    }

    public void fileDelete(int fileId) throws BGException {
        if (fileId <= 0) {
            throw new BGIllegalArgumentException();
        }
        new HelpdeskFileStorage(this.getConnection()).deleteFile(fileId);
    }

    public FileDto fileDownload(int fileId, int contractId) throws BGException {
        if (fileId <= 0) {
            throw new BGIllegalArgumentException();
        }
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.getConnection());
        BGServerFile serverFile = fileStorage.getFileById(fileId);
        if (serverFile == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (1)");
        }
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Message message = topicManager.getMessage(serverFile.getOwnerId());
        if (message != null) {
            serverFile.setContractId(topicManager.getTopicOwnerId(message.getTopicId()));
        }
        if (serverFile.getContractId() != contractId) {
            throw new BGException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 OwnerId \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442! fileId = " + fileId + "; contractId = " + contractId + "; file_contractId = " + serverFile.getContractId());
        }
        try {
            FileDto fileDto = FileDto.fromDataSource((DataSource)fileStorage.getDataSource(fileId));
            fileDto.setServerFile(serverFile);
            return fileDto;
        }
        catch (FileNotFoundException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).\n" + e.getLocalizedMessage());
        }
    }

    public FileInfo fileUpload(String ownerId, String uuid, String filename, long size, Holder<DataHandler> inclusion) throws BGException {
        int iownerId = Utils.parseInt((String)ownerId, (int)-1);
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.getConnection());
        BGServerFile messageFile = new BGServerFile();
        messageFile.setOwnerId(iownerId);
        messageFile.setTitle(filename);
        messageFile.setSize(size);
        messageFile.setComment("");
        messageFile.setUuid(uuid);
        messageFile.setDate(new Date());
        messageFile.setUserId(this.userId);
        fileStorage.updateFile(messageFile);
        if (messageFile.getId() > 0) {
            try {
                fileStorage.saveStream(messageFile.getId(), ((DataHandler)inclusion.value).getInputStream());
                FileInfo fileInfo = new FileInfo();
                fileInfo.setId(messageFile.getId());
                fileInfo.setTitle(messageFile.getTitle());
                fileInfo.setSize(new BigDecimal(messageFile.getSize()));
                return fileInfo;
            }
            catch (Exception e) {
                fileStorage.deleteFile(messageFile.getId());
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n\u0418\u043b\u0438 \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0438\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u0430.\n" + e.getMessage());
            }
        }
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0411\u0414");
    }

    public int messageUpdate(Message message) throws BGException {
        if (Utils.isBlankString((String)message.getBody())) {
            throw new BGIllegalArgumentException();
        }
        Topic topic = this.topicGet(0, message.getTopicId(), false);
        if (topic.isClosed() && message.getUserIdFrom() == 0) {
            throw new BGMessageException("\u0422\u0435\u043c\u0430 \u0443\u0436\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0430", "topic.closed");
        }
        this.getTopicManager().updateMessage(message.getId() > 0 ? String.valueOf(message.getId()) : "new", message);
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(connection);
        List files = fileStorage.getFilesListByOwner(-1, message.getUuid());
        this.setMessageAsOwnerOfTopicFiles((FileStorage)fileStorage, message, files);
        if (message.getId() <= 0) {
            return message.getId();
        }
        if (message.getUserIdFrom() == 0) {
            this.sendNotificationToUser(topic, message, files);
        } else {
            this.sendNotificationToAbonent(topic, message);
        }
        return message.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendNotificationToUser(Topic topic, Message message, List<BGServerFile> files) throws BGException {
        int userId = topic.getUserId();
        if (userId > 0) {
            try (UserManager userManager = new UserManager(this.getConnection());){
                User user = (User)userManager.get(userId);
                if (user == null) return;
                EmailNotification.sendMessage(user.getConfigSetup().get("helpdesk.mail", null), topic, message.getBody());
                TelegramNotification.sendMessage(user.getConfigSetup().get("telegram.user.id", null), user.getId(), topic, message, TelegramNotification.getMessageText(topic, message, files, true));
                return;
            }
        } else {
            TelegramNotification.sendMessage(topic, message, TelegramNotification.getMessageText(topic, message, files, false));
        }
    }

    private void sendNotificationToAbonent(Topic topic, Message message) throws BGException {
        boolean notificationIsEnable;
        int commMode = topic.getComm();
        String commValue = topic.getCommValue();
        boolean bl = notificationIsEnable = commValue != null && commValue.trim().length() > 0;
        if (!notificationIsEnable) {
            return;
        }
        String msgTitle = plugin.getSetup().get("default.comm.email.subject", "HelpDesk => \u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0412\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0432 \u0442\u0435\u043c\u0435: [{id}] {title}");
        msgTitle = msgTitle.replaceAll("\\{id\\}", String.valueOf(topic.getId()));
        msgTitle = msgTitle.replaceAll("\\{title\\}", topic.getTitle());
        if (commMode == 2) {
            String text = message.getBody();
            String url = plugin.getSetup().get("url.reference.topic", null);
            if (url != null && !url.equals("")) {
                StringBuilder sb = new StringBuilder();
                sb.append("ID: ");
                sb.append(topic.getId());
                sb.append("\n\u0422\u0435\u043c\u0430: ");
                sb.append(topic.getTitle());
                sb.append("\n\n");
                sb.append(message.getBody());
                sb.append("\n\n\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0442\u0435\u043c\u0443 \u0432 HelpDesk: ");
                sb.append(url);
                sb.append("action=HelpDeskAJAX&module=ru.bitel.bgbilling.plugins.helpdesk&mid=0&topicId=");
                sb.append(message.getTopicId());
                sb.append("&contractId=");
                sb.append(topic.getContractId());
                text = sb.toString();
            }
            try {
                new MailMsg((Preferences)this.getSetup()).sendMessage(new MailMessageNotification().setRecipients(commValue).setSubject(msgTitle).addTextPart("text", text));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        } else if (commMode == 4) {
            SendMessage sendMessage = new SendMessage();
            sendMessage.setText(msgTitle + "\n\n" + message.getBody());
            TelegramNotification.sendMessage(commValue.trim(), 0, topic, message, sendMessage);
        }
        HelpDeskMessageForContractEvent event = new HelpDeskMessageForContractEvent(plugin.getPluginUID(), topic.getContractId(), this.userId);
        event.setTopicId(message.getTopicId());
        event.setMsgTitle(msgTitle);
        event.setMessageId(message.getId());
        event.setBody(message.getBody());
        EventProcessor.getInstance().request((QueueEvent)event);
    }

    private void setMessageAsOwnerOfTopicFiles(FileStorage fileStorage, Message message, List<BGServerFile> topicFiles) throws BGException {
        for (BGServerFile topicFile : topicFiles) {
            topicFile.setOwnerId(message.getId());
            fileStorage.updateFile(topicFile);
        }
    }

    public Topic topicGet(int contractId, int id, boolean loadMessages) throws BGException {
        Topic topic = this.getTopicManager().getTopic(id, loadMessages);
        if (topic == null) {
            return null;
        }
        if (contractId > 0 && topic.getContractId() != contractId) {
            return null;
        }
        try {
            HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.getConnection());
            StringBuilder sb = new StringBuilder();
            if (topic.getMessages() != null) {
                for (Message message : topic.getMessages()) {
                    message.setBody(HelpdeskServiceImpl.escapeXmlNotValid(sb, message.getBody()));
                    message.setFileList(fileStorage.getFilesListByOwner(message.getId(), null));
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
        return topic;
    }

    private static String escapeXmlNotValid(StringBuilder buf, String value) {
        boolean was = false;
        buf.setLength(0);
        for (int j = 0; j < value.length(); ++j) {
            char ch = value.charAt(j);
            char ich = ch;
            if (ich >= ' ' && ich <= '\ud7ff' || ich == '\t' || ich == '\n' || ich == '\r' || ich >= '\ue000' && ich <= '\ufffd' || ich >= '\u10000' && ich <= '\u10ffff') {
                if (!was) continue;
                buf.append(ch);
                continue;
            }
            if (!was) {
                was = true;
                buf.append(value, 0, j);
            }
            buf.append("\\u");
            buf.append((int)ich);
        }
        if (!was) {
            return value;
        }
        return buf.toString();
    }

    public Result<Topic> topicList(int contractId, int id, Boolean history, Date dateFrom, Date dateTo, String title, String message, Page page) {
        TopicManager topicManager = this.getTopicManager();
        TopicListFilter filter = new TopicListFilter();
        filter.setContractId(contractId);
        filter.setTopicId(id);
        filter.setClosed(history);
        if (dateFrom != null || dateTo != null) {
            Period period = new Period(dateFrom, dateTo);
            filter.setPeriod(period);
        }
        filter.setTitle(title);
        filter.setMessage(message);
        filter.setPage(page);
        filter.setNewManagerMessage(true);
        List<Topic> list = topicManager.getTopicList(filter);
        if (page != null) {
            page.setRecordCount(topicManager.getTopicCount(filter));
        }
        return new Result(list, page);
    }

    public MapHolder<IdTitle, List<IdTitle>> categoryMapForContract(int contractId) throws BGException {
        HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.getConnection(), plugin);
        int groupId = manager.getContractGroupId(contractId);
        HashMap<IdTitle, List<IdTitle>> result = new HashMap<IdTitle, List<IdTitle>>();
        Map<Integer, List<Integer>> map = manager.getSubCategoryIds(groupId);
        for (Map.Entry<Integer, List<Integer>> entry : map.entrySet()) {
            int idCategory = entry.getKey();
            List<IdTitle> subList = manager.getSubcategory((Collection<Integer>)entry.getValue());
            subList.sort(Comparator.comparing(IdTitle::getTitle));
            result.put(new IdTitle(idCategory, manager.getCategoryTitle(idCategory)), subList);
        }
        return new MapHolder(result);
    }

    public void topicMarkReadByCustomer(int contractId, int topicId) throws BGException {
        Topic topic = this.getTopicManager().getTopic(topicId);
        if (topic == null || topic.getContractId() != contractId) {
            throw new BGIllegalArgumentException();
        }
        this.getTopicManager().setTopicClientRead(topicId);
    }

    public void topicUpdateState(int contractId, int id, boolean stateClosed) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Topic topic = topicManager.getTopic(id);
        if (topic.getContractId() != contractId) {
            throw new BGIllegalArgumentException();
        }
        int stateMode = plugin.getSetup().getInt("state.mode", 1);
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        Properties properties = paramManager.getProperties(contractId);
        String currentId = properties.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "on"));
        boolean packetMode = currentId.equals("package");
        if (topic.getStatus() <= 0 && stateClosed && (stateMode == 1 || currentId.equals("package"))) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0442\u0435\u043c\u0443, \u0443 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441!", "state.close.noStatus");
        }
        if (topic.isClosed() == stateClosed) {
            throw new BGMessageException("\u0422\u0435\u043c\u0430 \u0443\u0436\u0435 " + (stateClosed ? "\u0437\u0430\u043a\u0440\u044b\u0442\u0430" : "\u043e\u0442\u043a\u0440\u044b\u0442\u0430"), stateClosed ? "state.close.already" : "state.open.already");
        }
        topicManager.setTopicClosed(id, stateClosed, packetMode, this.userId);
    }

    public int[] topicCreate(Topic topic, Message message) throws BGException {
        if (topic.getId() > 0) {
            throw new BGIllegalArgumentException();
        }
        int contractId = topic.getContractId();
        if (Utils.isBlankString((String)topic.getTitle())) {
            throw new BGException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0435\u043c\u0443 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f.", "topic.title.empty");
        }
        if (Utils.isBlankString((String)message.getBody())) {
            throw new BGException("C\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.", "message.empty");
        }
        MapHolder<IdTitle, List<IdTitle>> categoryMap = this.categoryMapForContract(contractId);
        if (categoryMap.getMap() == null || categoryMap.getMap().size() == 0) {
            if (topic.getCategoryId() > 0) {
                throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            }
        } else {
            if (topic.getCategoryId() <= 0) {
                throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            }
            List subCategoryList = (List)categoryMap.getMap().get(new IdTitle(topic.getCategoryId(), ""));
            if (subCategoryList == null) {
                throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            }
            if (subCategoryList.size() == 0 ? topic.getCategoryId() > 0 : !subCategoryList.contains(new IdTitle(topic.getSubcategoryId(), ""))) {
                throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            }
        }
        String packageMode = this.getContractCurrentMode(contractId);
        PackageManager packageManager = new PackageManager(this.getConnection(), plugin);
        boolean packageEnabled = "package".equals(packageMode);
        if (packageEnabled && !packageManager.hasActivePackage(contractId)) {
            throw new BGException("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.", "package.activeNotFound");
        }
        BigDecimal cost = plugin.getSetup().getBigDecimal("topic.default.cost." + contractId, null);
        if (cost == null) {
            cost = plugin.getSetup().getBigDecimal("topic.default.cost", new BigDecimal("0.00"));
        }
        topic.setCost(cost);
        topic.setAutoClose(plugin.getSetup().getBoolean("topic.avto.closed.default", false));
        topic.setClosed(false);
        topic.setDate(new Date());
        TopicWillBeCreated event = new TopicWillBeCreated(topic, 2, plugin.getPluginUID(), message.getBody());
        if (!event.isAllowCreate()) {
            throw new BGException(event.getErrorMessage() != null ? event.getErrorMessage() : "\u0421\u043a\u0440\u0438\u043f\u0442 \u043d\u0435 \u0434\u0430\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0435\u043c\u0443");
        }
        this.getTopicManager().updateTopic(topic);
        while (packageEnabled) {
            PackageContract pkg = packageManager.getActivePackageContract(contractId);
            if (pkg == null) {
                throw new BGException("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.", "package.activeNotFound");
            }
            if (packageManager.updatePackageContractCount(pkg.getId(), pkg.getCountUse(), 1) != 1) continue;
            this.getTopicManager().updateTopicPackage(topic.getId(), pkg.getId());
            break;
        }
        message.setTopicId(topic.getId());
        message.setDateFrom(new Date());
        this.messageUpdate(message);
        return new int[]{topic.getId(), message.getId()};
    }

    public int messageNewCount() throws BGException, BGMessageException {
        return new TopicManager(this.getConnection(), plugin).getClientNewMessageCount();
    }

    public SearchResult<Topic> topicSearch(int topicId, String title, String message, int status, String userSelect, boolean onlynew, boolean closed, Period period, Page page) throws BGException, BGMessageException {
        SearchResult searchResult = new SearchResult(period, page);
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        TopicListFilter topicListFilter = new TopicListFilter();
        topicListFilter.setContractId(-1);
        topicListFilter.setClosed(closed);
        topicListFilter.setPeriod(period);
        topicListFilter.setTitle(title);
        topicListFilter.setPage(page);
        topicListFilter.setOnlyNew(onlynew);
        topicListFilter.setUserselect(userSelect);
        topicListFilter.setUserId(this.userId);
        topicListFilter.setTopicId(topicId);
        topicListFilter.setMessage(message);
        topicListFilter.setStatus(status);
        searchResult.getList().addAll(topicManager.getTopicList(topicListFilter));
        page.setRecordCount(topicManager.getTopicCount(topicListFilter));
        return searchResult;
    }

    public List<IdTitle> topicStatusList() throws BGException, BGMessageException {
        ArrayList<IdTitle> statusList = new ArrayList<IdTitle>();
        statusList.add(new IdTitle(0, "\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"));
        String query = "SELECT id, title FROM helpdesk_topic_statuses_" + plugin.getPluginUID() + " ORDER BY title";
        try (Statement st = this.getConnection().createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                statusList.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return statusList;
    }

    public List<IdTitle> categoryList() throws BGException, BGMessageException {
        SearchResult searchResult = new SearchResult(new Page());
        HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.getConnection(), plugin);
        manager.getCategoryList((SearchResult<IdTitle>)searchResult);
        return searchResult.getList();
    }

    public List<IdTitle> subcategoryList() throws BGException, BGMessageException {
        SearchResult searchResult = new SearchResult(new Page());
        HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.getConnection(), plugin);
        manager.getSubCategoryList((SearchResult<IdTitle>)searchResult);
        return searchResult.getList();
    }

    public List<String> categorySubcategoryIdsForGroup(int contractId) throws BGException, BGMessageException {
        ArrayList<String> list = new ArrayList<String>();
        HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.getConnection(), plugin);
        manager.getSubCategoryIds(manager.getContractGroupId(contractId)).forEach((a, b) -> list.add(a + "," + Utils.toString((Iterable)b)));
        return list;
    }

    public List<IdTitle> managerList() throws BGException, BGMessageException {
        ArrayList<IdTitle> managers = new ArrayList<IdTitle>();
        UserMap.getMap().values().forEach(a -> managers.add(new IdTitle(a.getId(), a.getName() + " [" + a.getLogin() + "]")));
        Collections.sort(managers, new Comparator<IdTitle>(){

            @Override
            public int compare(IdTitle o1, IdTitle o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        return managers;
    }

    public List<ChangeManager> topicManagerChangeList(int topicId) throws BGException, BGMessageException {
        return new ManagerChangeManager(this.getConnection(), plugin).getListOfChange(topicId);
    }

    public void topicManagerChange(int topicId, int managerId, String comment) throws BGException, BGMessageException {
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        topicManager.setBindTopic(topicId, managerId, comment);
        try (UserManager userManager = new UserManager(this.getConnection());){
            User user = (User)userManager.get(managerId);
            if (user != null) {
                Topic topic = topicManager.getTopic(topicId);
                String email = user.getConfigSetup().get("helpdesk.mail", null);
                String text = topic.getMessages() != null && topic.getMessages().size() > 0 ? ((Message)topic.getMessages().get(0)).getBody() : "";
                EmailNotification.sendMessage(email, topic, "HelpDesk => \u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0430 \u0442\u0435\u043c\u0430: [{id}] {title}", text);
            }
        }
    }

    public void topicCategorySubcategoryUpdate(int topicId, int categoryId, int subcategoryId) throws BGException, BGMessageException {
        HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.getConnection(), plugin);
        if (categoryId > -1 && subcategoryId > -1 && topicId > -1) {
            manager.setCategorySubcategory(categoryId, subcategoryId, topicId);
        }
    }

    public void topicStatusUpdate(int topicId, int status) throws BGException, BGMessageException {
        new TopicManager(this.getConnection(), plugin).setTopicStatus(topicId, status);
    }

    public void topicStateUpdate(int topicId, boolean state, boolean packageMode) throws BGException, BGMessageException {
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Topic topic = topicManager.getTopic(topicId);
        int stateMode = plugin.getSetup().getInt("state.mode", 1);
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        Properties properties = paramManager.getProperties(topic.getContractId());
        String currentId = properties.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "on"));
        if (topic.getStatus() <= 0 && state && (stateMode == 1 || currentId.equals("package"))) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0442\u0435\u043c\u0443, \u0443 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441!");
        }
        if (topic.isClosed() == state) {
            throw new BGMessageException("\u0422\u0435\u043c\u0430 \u0443\u0436\u0435 " + (state ? "\u0437\u0430\u043a\u0440\u044b\u0442\u0430" : "\u043e\u0442\u043a\u0440\u044b\u0442\u0430"));
        }
        topicManager.setTopicClosed(topicId, state, packageMode, this.userId);
    }

    public void topicBindSet(int topicId, String userId) throws BGException, BGMessageException {
        new TopicManager(this.getConnection(), plugin).setBindTopic(topicId, "me".equals(userId) ? this.userId : Utils.parseInt((String)userId, (int)-1), null);
    }

    public void topicAutocloseUpdate(int topicId, boolean autoclose) throws BGException, BGMessageException {
        new TopicManager(this.getConnection(), plugin).setTopicAutoclose(topicId, autoclose);
    }

    public void messageCommentUpdate(int messageId, String comment) throws BGException, BGMessageException {
        new TopicManager(this.getConnection(), plugin).updateMessageComment(messageId, comment);
    }

    public void messageAdminReadSet(int messageId) throws BGException, BGMessageException {
        new TopicManager(this.getConnection(), plugin).setMessageAdminRead(messageId, this.userId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void topicPackageStateSet(int contractId, int topicId, Boolean include) throws BGException, BGMessageException {
        String mode = this.getMode(contractId);
        if (!"package".equals(mode)) {
            throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u043d\u0435\u043f\u0430\u043a\u0435\u0442\u043d\u043e\u043c \u0440\u0435\u0436\u0438\u043c\u0435.");
        }
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Topic topic = topicManager.getTopic(topicId);
        if (topic == null || topic.getContractId() != contractId) return;
        PackageManager packageManager = new PackageManager(this.getConnection(), plugin);
        if (include.booleanValue() && topic.getContractPackageId() < 1) {
            PackageContract packageContract = packageManager.getActivePackageContract(contractId);
            if (packageContract == null) throw new BGMessageException("\u041d\u0435\u0442 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0439 \u0432 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u0430\u0445");
            int updateRows = packageManager.updatePackageContractCount(packageContract.getId(), packageContract.getCountUse(), 1);
            if (updateRows <= 0) return;
            topicManager.updateTopicPackage(topicId, packageContract.getId());
            return;
        } else {
            if (include.booleanValue() || topic.getContractPackageId() <= 0) return;
            PackageContract packageContract = packageManager.getPackageContract(topic.getContractPackageId());
            if (packageContract != null) {
                int updateRows = packageManager.updatePackageContractCount(packageContract.getId(), packageContract.getCountUse(), -1);
                if (updateRows <= 0) return;
                topicManager.updateTopicPackage(topicId, -1);
                return;
            } else {
                topicManager.updateTopicPackage(topicId, -1);
            }
        }
    }

    public ContractModeDTO contractModeGet(int contractId) throws BGException, BGMessageException {
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        ContractModeDTO contractModeDTO = new ContractModeDTO();
        contractModeDTO.getModeList().addAll(paramManager.getModeList());
        contractModeDTO.setCurrentMode(paramManager.getContractCurrentMode(contractId));
        return contractModeDTO;
    }

    public void contractModeUpdate(int contractId, String currentModeId) throws BGException, BGMessageException {
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        Properties properties = paramManager.getProperties(contractId);
        properties.setProperty("mode.id", currentModeId != null ? currentModeId : properties.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "off")));
        paramManager.setProperties(contractId, properties);
    }

    public MapHolder<String, String> getParams(int contractId) throws BGException {
        HashMap<String, String> map = new HashMap<String, String>();
        ParamManager paramManager = new ParamManager(this.getConnection(), BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk"));
        Properties properties = paramManager.getProperties(contractId);
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return new MapHolder(map);
    }

    public void setParams(int contractId, MapHolder<String, String> _params) throws BGException {
        String trueStr = "true";
        Map params = _params.getMap();
        int mode = Utils.parseInt((String)((String)params.get("comm.mode")), (int)0);
        if (!"true".equals(plugin.getSetup().get("default.comm.telegram.enable", "true"))) {
            params.remove("comm.telegram.value");
            if (mode == 4) {
                mode = 0;
            }
        }
        if (!"true".equals(plugin.getSetup().get("default.comm.phone.enable", "true"))) {
            params.remove("comm.phone.value");
            if (mode == 1) {
                mode = 0;
            }
        }
        if (!"true".equals(plugin.getSetup().get("default.comm.email.enable", "true"))) {
            params.remove("comm.email.value");
            if (mode == 2) {
                mode = 0;
            }
        }
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                mode = 0;
            }
        }
        params.put("comm.mode", String.valueOf(mode));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)params);
        this.getParamManager().setProperties(contractId, properties);
    }

    public List<KeyValue> getModeList() throws BGException {
        return this.getParamManager().getModeList();
    }

    public String getContractCurrentMode(int contractId) throws BGException {
        return this.getParamManager().getContractCurrentMode(contractId);
    }

    public SearchResult<IdTitle> getGroupList(boolean groupForDirectory, int contractId, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        HelpDeskDirectoryManager groupManager = new HelpDeskDirectoryManager(this.getConnection(), plugin);
        groupManager.getGroupList((SearchResult<IdTitle>)searchResult);
        if (!groupForDirectory && contractId > 0) {
            int selectGroupId = -2;
            try {
                if (groupManager.hasContractGroup(contractId)) {
                    selectGroupId = groupManager.getContractGroupId(contractId);
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            searchResult.setAttribute("selectGroupId", String.valueOf(selectGroupId));
        }
        return searchResult;
    }

    public void updateGroup(IdTitle idTitle) throws BGException {
        try {
            new HelpDeskDirectoryManager(this.getConnection(), plugin).updateGroupTitle(idTitle);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateCategory(IdTitle idTitle) throws BGException {
        try {
            new HelpDeskDirectoryManager(this.getConnection(), plugin).updateCategoryTitle(idTitle);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateSubCategory(IdTitle idTitle) throws BGException {
        try {
            new HelpDeskDirectoryManager(this.getConnection(), plugin).updateSubCategoryTitle(idTitle);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public Message messageGet(int contractId, int topicId, int messageId) throws BGException {
        Message message = null;
        if (topicId > 0 && messageId > 0) {
            TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
            Topic topic = topicManager.getTopic(topicId, false);
            message = topicManager.getMessage(messageId);
            if (topic != null && message != null) {
                if (topic.getId() != message.getTopicId()) {
                    message = null;
                } else {
                    message.setFileList(new HelpdeskFileStorage(this.getConnection()).getFilesListByOwner(message.getId()));
                }
            } else {
                message = null;
            }
        }
        return message;
    }

    public SearchResult<Message> searchTopicMessages(int contractId, int topicId, String[] sort, Page page) throws BGException {
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Topic topic = topicManager.getTopic(topicId, false);
        if (topic.getContractId() != contractId) {
            topic = null;
        }
        SearchResult searchResult = null;
        if (topic != null) {
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
            }
            searchResult = new SearchResult(page, sort);
            topicManager.searchTopicMessages((SearchResult<Message>)searchResult, topicId);
        }
        return searchResult;
    }

    public List<FileInfo> getMessageFileList(int messageId) throws BGException {
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        List messageFileList = new HelpdeskFileStorage(this.getConnection()).getFilesListByOwner(messageId);
        for (BGServerFile messageFile : messageFileList) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setId(messageFile.getId());
            fileInfo.setTitle(messageFile.getTitle());
            fileInfo.setSize(new BigDecimal(messageFile.getSize()));
            list.add(fileInfo);
        }
        return list;
    }

    private ParamManager getParamManager() {
        return new ParamManager(this.getConnection(), BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk"));
    }

    private String getMode(int contractId) throws BGException {
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        Properties properties = paramManager.getProperties(contractId);
        return properties.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "on"));
    }

    public void subcategoryToCategoryAdd(int groupId, Set<Integer> categoriesIds, Set<Integer> subCategoriesIds) throws BGException, BGMessageException {
        HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.getConnection(), plugin);
        for (Integer categoryId : categoriesIds) {
            for (Integer subCategoryId : subCategoriesIds) {
                manager.addSubcategoryToCategory(groupId, categoryId, subCategoryId);
            }
        }
    }

    public void subcategoryToCategoryDelete(int groupId, Set<Integer> categoriesIds, Set<Integer> subCategoriesIds) throws BGException, BGMessageException {
        HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.getConnection(), plugin);
        for (Integer categoryId : categoriesIds) {
            for (Integer subCategoryId : subCategoriesIds) {
                manager.deleteSubcategoryToCategory(groupId, categoryId, subCategoryId);
            }
        }
    }
}

