/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access.sa;

import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivator;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorDeviceWorker;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.RangeUtils;

public class ServiceActivatorSet
extends ReentrantLock {
    private static final Logger logger = LogManager.getLogger();
    private final ServiceActivatorHolder[] serviceActivators;
    private volatile boolean alive = true;

    public ServiceActivatorSet(ServiceActivatorHolder[] serviceActivators) {
        this.serviceActivators = serviceActivators;
    }

    public boolean isAlive() {
        return this.alive;
    }

    private boolean checkResult(Object result) throws BGException {
        if (result != null) {
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return true;
        }
        return true;
    }

    private Boolean checkResult(ServiceActivatorDeviceWorker device, ServiceActivatorEvent event, Object result) throws BGException {
        boolean res;
        if (result != null) {
            if (result instanceof Boolean) {
                res = (Boolean)result;
            } else if (result instanceof Future) {
                if (event.futures == null) {
                    event.futures = new ArrayList(4);
                }
                event.futures.add((Future)result);
                res = true;
            } else {
                res = true;
            }
        } else {
            res = true;
        }
        if (res) {
            if (event.doAsync) {
                int deviceId = event.consumed ? 0 : device.getDeviceId();
                try {
                    device.putLast(new ServiceActivatorDeviceWorker.AsyncEventHolder(event.event, deviceId));
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (event.consumed) {
                return Boolean.TRUE;
            }
            return null;
        }
        return Boolean.FALSE;
    }

    public void destroy() {
        this.alive = false;
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            try {
                this.serviceActivators[i].serviceActivator.destroy();
                continue;
            }
            catch (Throwable e) {
                logger.error("Device:" + this.serviceActivators[i].deviceId + " - " + e.getMessage(), e);
            }
        }
    }

    public Object connect() throws BGException {
        logger.debug("Connecting to device");
        long millis = System.currentTimeMillis();
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            try {
                ServiceActivatorHolder holder = this.serviceActivators[i];
                if (!holder.omEnabled) {
                    logger.info("Skip device:" + holder.deviceId + " with disabled ServiceActivator");
                    holder.enabled = false;
                    continue;
                }
                if (!RangeUtils.inRange((long)millis, (long)millis, (long)holder.timeFromMillis, (long)holder.timeToMillis)) {
                    logger.info("Skip device:" + holder.deviceId + " with closed period");
                    holder.enabled = false;
                    continue;
                }
                holder.enabled = true;
                if (this.checkResult(holder.serviceActivator.connect())) continue;
                return false;
            }
            catch (Throwable e) {
                throw new BGException(e);
            }
        }
        return true;
    }

    public void disconnect() throws BGException {
        logger.debug("Disconnecting from device");
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            try {
                ServiceActivatorHolder holder = this.serviceActivators[i];
                if (!holder.enabled) continue;
                holder.serviceActivator.disconnect();
                continue;
            }
            catch (Exception e) {
                logger.error("Device:" + this.serviceActivators[i].deviceId + " - " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean connectionClose(ServiceActivatorDeviceWorker device, ServiceActivatorEvent event) throws Exception {
        logger.debug("Invoking connectionClose");
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            Boolean result;
            ServiceActivatorHolder holder = this.serviceActivators[i];
            if (!holder.enabled || event.processDeviceId != 0 && event.processDeviceId != holder.deviceId || (result = this.checkResult(device, event, holder.serviceActivator.connectionClose(event))) == null) continue;
            return result;
        }
        return true;
    }

    public boolean connectionModify(ServiceActivatorDeviceWorker device, ServiceActivatorEvent event) throws Exception {
        logger.debug("Invoking connectionModify");
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            Boolean result;
            ServiceActivatorHolder holder = this.serviceActivators[i];
            if (logger.isDebugEnabled()) {
                logger.debug("holder.serviceActivator = {}", (Object)holder.serviceActivator.getClass().getName());
                logger.debug("holder.enabled = {}; event.processDeviceId = {}; holder.deviceId = {}", (Object)holder.enabled, (Object)event.processDeviceId, (Object)holder.deviceId);
            }
            if (!holder.enabled || event.processDeviceId != 0 && event.processDeviceId != holder.deviceId || (result = this.checkResult(device, event, holder.serviceActivator.connectionModify(event))) == null) continue;
            return result;
        }
        return true;
    }

    public boolean onAccountingStart(ServiceActivatorDeviceWorker device, ServiceActivatorEvent event) throws Exception {
        logger.debug("Invoking onAccountingStart");
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            Boolean result;
            ServiceActivatorHolder holder = this.serviceActivators[i];
            if (!holder.enabled || event.processDeviceId != 0 && event.processDeviceId != holder.deviceId || (result = this.checkResult(device, event, holder.serviceActivator.onAccountingStart(event))) == null) continue;
            return result;
        }
        return true;
    }

    public boolean onAccountingStop(ServiceActivatorDeviceWorker device, ServiceActivatorEvent event) throws Exception {
        logger.debug("Invoking onAccountingStop");
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            Boolean result;
            ServiceActivatorHolder holder = this.serviceActivators[i];
            if (!holder.enabled || event.processDeviceId != 0 && event.processDeviceId != holder.deviceId || (result = this.checkResult(device, event, holder.serviceActivator.onAccountingStop(event))) == null) continue;
            return result;
        }
        return true;
    }

    public boolean serviceCancel(ServiceActivatorDeviceWorker device, ServiceActivatorEvent event) throws Exception {
        logger.debug("Invoking serviceCancel");
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            Boolean result;
            ServiceActivatorHolder holder = this.serviceActivators[i];
            if (!holder.enabled || event.processDeviceId != 0 && event.processDeviceId != holder.deviceId || (result = this.checkResult(device, event, holder.serviceActivator.serviceCancel(event))) == null) continue;
            return result;
        }
        return true;
    }

    public boolean serviceCreate(ServiceActivatorDeviceWorker device, ServiceActivatorEvent event) throws Exception {
        logger.info("Invoking serviceCreate");
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            Boolean result;
            ServiceActivatorHolder holder = this.serviceActivators[i];
            if (!holder.enabled || event.processDeviceId != 0 && event.processDeviceId != holder.deviceId || (result = this.checkResult(device, event, holder.serviceActivator.serviceCreate(event))) == null) continue;
            return result;
        }
        return true;
    }

    public boolean serviceModify(ServiceActivatorDeviceWorker device, ServiceActivatorEvent event) throws Exception {
        logger.info("Invoking serviceModify");
        for (int i = 0; i < this.serviceActivators.length; ++i) {
            Boolean result;
            ServiceActivatorHolder holder = this.serviceActivators[i];
            if (!holder.enabled || event.processDeviceId != 0 && event.processDeviceId != holder.deviceId || (result = this.checkResult(device, event, holder.serviceActivator.serviceModify(event))) == null) continue;
            return result;
        }
        return true;
    }

    public static class ServiceActivatorHolder {
        public final int deviceId;
        public final ServiceActivator serviceActivator;
        public final long timeFromMillis;
        public final long timeToMillis;
        public boolean enabled = true;
        public boolean omEnabled = true;

        public ServiceActivatorHolder(int deviceId, ServiceActivator serviceActivator, long timeFromMillis, long timeToMillis, boolean omEnabled) {
            this.deviceId = deviceId;
            this.serviceActivator = serviceActivator;
            this.timeFromMillis = timeFromMillis;
            this.timeToMillis = timeToMillis;
            this.omEnabled = omEnabled;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("deviceId = ").append(this.deviceId);
            stringBuilder.append("; serviceActivator = ").append(this.serviceActivator != null ? this.serviceActivator.getClass().getName() : "");
            stringBuilder.append("; timeFromMillis = ").append(this.timeFromMillis);
            stringBuilder.append("; timeToMillis = ").append(this.timeToMillis);
            stringBuilder.append("; enabled = ").append(this.enabled);
            stringBuilder.append("; omEnabled = ").append(this.omEnabled);
            return stringBuilder.toString();
        }
    }
}

