/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.action.pub;

import bitel.billing.server.ActionBase;
import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.inet.IpAddress;

public class ActionConnectionError
extends ActionBase {
    public void doAction() throws SQLException, BGException, UnknownHostException {
        String address = ServletUtils.getIpFromHeader((HttpServletRequest)this.request, (Setup)this.setup);
        String xsl = "inet_connection_error.xsl";
        this.rootNode.setAttribute("xslt", "inet_connection_error.xsl");
        this.rootNode.setAttribute("moduleId", String.valueOf(this.mid));
        if (!ServerUtils.tableExists((Connection)this.con, (String)("inet_connection_" + this.mid))) {
            this.rootNode.setAttribute("accessCode", String.valueOf(-2));
        }
        InetAddress inetAddress = InetAddress.getByName(address);
        PreparedStatement ps = this.con.prepareStatement("SELECT serv.contractId, connection.accessCode FROM inet_connection_" + this.mid + " as connection LEFT JOIN inet_serv_" + this.mid + " as serv ON serv.id=connection.servId WHERE connection.ipAddress=? AND connection.status=?");
        ps.setBytes(1, inetAddress.getAddress());
        ps.setInt(2, 1);
        int contractId = -1;
        int accessCode = -1;
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            contractId = rs.getInt(1);
            accessCode = rs.getInt(2);
        }
        rs.close();
        ps.close();
        if (accessCode == -1) {
            ps = this.con.prepareStatement("SELECT serv.contractId, serv.accessCode, serv.addressFrom FROM inet_serv_" + this.mid + " as serv WHERE (serv.addressFrom IS NOT NULL AND ((serv.addressTo IS NOT NULL AND serv.addressFrom<=? AND serv.addressTo>=?) OR (serv.addressTo IS NULL AND serv.addressFrom=?))) AND serv.addressFrom!=? AND serv.addressFrom!=? AND (serv.dateFrom IS NULL OR serv.dateFrom<=?) AND (serv.dateTo IS NULL OR serv.dateTo>=?)");
            ps.setBytes(1, inetAddress.getAddress());
            ps.setBytes(2, inetAddress.getAddress());
            ps.setBytes(3, inetAddress.getAddress());
            ps.setBytes(4, IpAddress.ZERO_ADDRESS.address);
            ps.setBytes(5, IpAddress.IPV6_ZERO_ADDRESS.address);
            Date sqlDate = TimeUtils.convertDateToSqlDate((java.util.Date)new java.util.Date());
            ps.setDate(6, sqlDate);
            ps.setDate(7, sqlDate);
            rs = ps.executeQuery();
            if (rs.next()) {
                contractId = rs.getInt(1);
                accessCode = rs.getInt(2);
            }
            rs.close();
            ps.close();
        }
        this.rootNode.setAttribute("accessCode", String.valueOf(accessCode));
        if (contractId > 0 && accessCode > 0 && accessCode != AccessCode.INVALID_ACCOUNT.getCode()) {
            try {
                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                XMLStreamWriter w = factory.createXMLStreamWriter(new DOMResult(this.rootNode));
                new ContractUtils(this.con).addContractXML(contractId, w, true);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

