/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.action.web;

import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLink;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLinkRule;
import ru.bitel.bgbilling.modules.inet.common.service.AccountingPeriodService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

@WebAction(title="Inet")
public class ActionInet
extends AbstractAction {
    @Resource
    InetServService inetServService;
    @Resource
    InetSessionService inetSessionService;
    @Resource
    AccountingPeriodService accountingPeriodService;

    public ActionInet() {
        super("inet");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432")
    public void accountList() throws BGException {
        List periodList = this.accountingPeriodService.periodList(this.contractId);
        if (!periodList.isEmpty()) {
            this.setResultParam("inetAccountingPeriod", periodList.get(0));
        }
        this.setResultParam("inetServList", this.inetServService.inetServList(this.contractId, "dateTo, dateFrom"));
        this.requestDispatcher(this.moduleName, "accounts");
    }

    @WebOperation(title="\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c")
    public void sessionReport() throws BGException {
        InetServ inetServ = this.inetServService.inetServGet(this.req.getInt("accountId", 0));
        if (inetServ != null && inetServ.getContractId() == this.contractId) {
            this.setResultParam("inetServ", inetServ);
        }
        this.requestDispatcher(this.moduleName, "report_session");
    }

    @WebOperation(title="\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0442\u0440\u0430\u0444\u0438\u043a\u0430\u043c")
    public void trafficReport() throws BGException {
        LocalDate now;
        String mmyyyy = this.req.get("mmyyyy");
        LocalDate from = now = LocalDate.now().withDayOfMonth(1);
        if (Utils.notBlankString((String)mmyyyy) && mmyyyy.matches("^\\d{2}\\.\\d{4}$")) {
            from = TimeUtils.parseLocalDate((String)("01." + mmyyyy), (String)"dd.MM.yyyy");
            from = from.isAfter(now) ? now : from;
        }
        LocalDate prev = from.minusMonths(1L);
        LocalDate next = from.isBefore(now) ? from.plusMonths(1L) : null;
        InetServ inetServ = this.inetServService.inetServGet(this.req.getInt("accountId", 0));
        if (inetServ != null && inetServ.getContractId() == this.contractId) {
            Period period = new Period(from, from.plusMonths(1L).minusDays(1L));
            List result = this.inetSessionService.inetSessionTraffic(this.contractId, Collections.singleton(inetServ.getId()), 0, null, period, 0x100000L, true, true);
            HashMap<Integer, Long> inetAmountMap = new HashMap<Integer, Long>();
            List<TrafficType> trafficTypes = this.getTrafficTypes(inetServ);
            long max = 0L;
            for (TrafficAmount trafficAmount : result) {
                Map trafficMap = trafficAmount.getTrafficMap();
                for (TrafficType trafficType : trafficTypes) {
                    int typeId = trafficType.getId();
                    long amount = trafficMap.getOrDefault(typeId, 0L);
                    max = Math.max(max, amount);
                    if (!trafficMap.containsKey(typeId)) {
                        trafficMap.put(typeId, 0L);
                    }
                    inetAmountMap.put(typeId, inetAmountMap.getOrDefault(typeId, 0L) + amount);
                }
            }
            HashMap<Integer, String> inetColorMap = new HashMap<Integer, String>();
            String[] colors = new String[]{"#c00", "#0c0", "#00c", "#cc0", "#0cc", "#c0c", "#ccc"};
            for (int i = 0; i < trafficTypes.size(); ++i) {
                inetColorMap.put(trafficTypes.get(i).getId(), colors[i]);
            }
            this.setResultParam("inetSessionTrafficMax", max);
            this.setResultParam("inetSessionTraffic", result);
            this.setResultParam("trafficTypes", trafficTypes);
            this.setResultParam("inetServ", inetServ);
            this.setResultParam("inetColorMap", inetColorMap);
            this.setResultParam("inetAmountMap", inetAmountMap);
            this.setResultParam("itetSessionPeriodPrev", TimeUtils.convertLocalDateToDate((LocalDate)prev));
            this.setResultParam("itetSessionPeriod", period.getDateFrom());
            if (next != null) {
                this.setResultParam("itetSessionPeriodNext", TimeUtils.convertLocalDateToDate((LocalDate)next));
            }
        }
        this.requestDispatcher(this.moduleName, "report_traffic");
    }

    @WebOperation(title="\u0421\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f")
    public void changePassword() throws BGException {
        int accountId = this.req.getInt("accountId", -1);
        InetServ inetServ = this.inetServService.inetServGet(accountId);
        if (inetServ != null && inetServ.getContractId() == this.contractId) {
            String pswd0 = this.context.getRequest().getParameter("pswd0");
            if (pswd0 == null) {
                InetServType inetServType = this.inetServService.inetServTypeGet(inetServ.getTypeId());
                if (inetServType != null && inetServType.isNeedLogin()) {
                    this.setResultParam("account", inetServ);
                }
                this.requestDispatcher(this.moduleName, "password");
            } else {
                String error;
                ActionMessage message = new ActionMessage("inetRoot", "accountList", "inetQuery", "\u041f\u0430\u0440\u043e\u043b\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d");
                String pswd1 = this.req.get("pswd1");
                String pswd2 = this.req.get("pswd2");
                if (Utils.isEmptyString((String)pswd0) || Utils.isEmptyString((String)pswd1) || Utils.isEmptyString((String)pswd2)) {
                    message.setOnClose("close");
                    message.setError("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0432\u0441\u0435 \u043f\u043e\u043b\u044f");
                }
                if (!"close".equals(message.getOnClose()) && !pswd0.equals(inetServ.getPassword())) {
                    message.setOnClose("close");
                    message.setError("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u0441\u0442\u0430\u0440\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                }
                if (!"close".equals(message.getOnClose()) && (error = ContractUtils.checkPassword((ParameterMap)this.moduleSetup, (String)pswd1, (String)pswd2)) != null) {
                    message.setOnClose("close");
                    message.setText(error);
                }
                if (!"close".equals(message.getOnClose())) {
                    inetServ.setPassword(pswd1);
                    this.inetServService.inetServUpdate(inetServ, this.inetServService.inetServOptionList(accountId), false, false, 0L);
                }
                this.setResultParam("message", message);
                this.requestDispatcher("include", "popup_message");
            }
        } else {
            this.execute();
        }
    }

    private List<TrafficType> getTrafficTypes(InetServ inetServ) throws BGException {
        InetServType servType = this.inetServService.inetServTypeGet(inetServ.getTypeId());
        TrafficTypeLink trafficTypeLink = this.inetServService.trafficTypeLinkGet(servType.getTrafficTypeLinkId());
        HashSet<Integer> servTypeTrafficTypeIds = new HashSet<Integer>();
        if (trafficTypeLink != null) {
            for (TrafficTypeLinkRule rule : trafficTypeLink.getTrafficTypeLinkRuleList()) {
                servTypeTrafficTypeIds.add(rule.trafficTypeId);
            }
        }
        List trafficTypes = this.inetServService.trafficTypeList();
        Iterator iter = trafficTypes.iterator();
        while (iter.hasNext()) {
            TrafficType trafficType = (TrafficType)iter.next();
            int trafficTypeId = trafficType.getId();
            if (trafficTypeId != 0 && servTypeTrafficTypeIds.contains(trafficTypeId) && trafficType.getUnit() != 20000) continue;
            iter.remove();
        }
        return trafficTypes;
    }
}

