/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import bitel.billing.server.ActionBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ActionDispathTrafficIpn
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        String date1 = this.getParameter("date1");
        this.traffic(TimeUtils.parseCalendar((String)date1, (String)"dd.MM.yyyy"));
    }

    public void traffic(Calendar d1) {
        if (this.cid < 0 || d1 == null) {
            log.error("Error in params ActionContractBalanceAll::balance()");
            return;
        }
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            Contract contract;
            String xslUrl = this.moduleSetup.get("ipn.xslt", null);
            if (xslUrl != null) {
                this.rootNode.setAttribute("xslt", xslUrl);
            }
            if ((contract = (Contract)contractDao.get(this.cid)) != null) {
                this.rootNode.setAttribute("contractTitle", contract.getTitle());
                this.rootNode.setAttribute("comment", contract.getComment());
            }
            this.rootNode.setAttribute("date1", TimeUtils.format((Calendar)d1, (String)"dd.MM.yyyy"));
            List serviceList = ModuleCache.getInstance().getModuleServicesList(this.mid);
            AddressRangeManager man = new AddressRangeManager(this.con, this.mid);
            List<AddressRange> addrList = man.getContractAddressRange(this.cid);
            for (Service srv : serviceList) {
                Element service = this.createElement(this.rootNode, "service");
                long all = 0L;
                for (AddressRange ar : addrList) {
                    long val = this.fillData(this.cid, "" + ar.getId(), "" + srv.getId(), d1);
                    all += val;
                    Element address = this.createElement(service, "address");
                    address.setAttribute("traffic", "" + val);
                    address.setAttribute("value", String.valueOf(ar.getId()));
                    address.setAttribute("title", ar.toShortString());
                    service.appendChild(address);
                }
                service.setAttribute("all", "" + all);
                service.setAttribute("title", srv.getTitle());
                service.setAttribute("value", String.valueOf(srv.getId()));
                this.rootNode.appendChild(service);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private long fillData(int cid, String aids, String sids, Calendar dt) throws SQLException {
        long value = 0L;
        if (sids == null || "".equals(sids)) {
            sids = "0";
        }
        if (aids != null && "".equals(aids)) {
            aids = null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        int month = dt.get(2) + 1;
        int date = dt.get(5);
        int year = dt.get(1);
        String mon = month < 10 ? "0" + month : "" + month;
        String tableName = null;
        StringBuffer whereFilter = new StringBuffer();
        whereFilter.append(" AND sid in ( ");
        whereFilter.append(sids);
        whereFilter.append(" )");
        if (aids != null) {
            whereFilter.append(" AND aid IN ( ");
            whereFilter.append(aids);
            whereFilter.append(" ) ");
        }
        if (month > 0 && date > 0) {
            tableName = "ipn_contract_data_" + this.mid + "_" + year + mon;
            GregorianCalendar dayDate = new GregorianCalendar();
            dayDate.set(1, year);
            dayDate.set(2, month - 1);
            dayDate.set(5, date);
            StringBuilder query = new StringBuilder();
            query.append("SELECT sum(amount) FROM ");
            query.append(tableName);
            query.append(" WHERE dt=? ");
            query.append(" AND cid=");
            query.append(cid);
            query.append(whereFilter.toString());
            if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                ps = this.con.prepareStatement(query.toString());
                ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)dayDate));
                rs = ps.executeQuery();
                while (rs.next()) {
                    value = rs.getLong(1);
                }
            }
        }
        return value;
    }
}

