/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class InterfaceEditor
extends BGPanel {
    private BGTable table = new BGTable();
    private BGTextField title = new BGTextField();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
    private DefaultListModel<BGUListItem> sourceModel = new DefaultListModel();
    private JList<BGUListItem> sourceList = new JList<BGUListItem>(this.sourceModel);
    private IntTextField number = new IntTextField();
    private JPanel editorPanel = new JPanel();
    private JComboBox<ComboBoxItem> comboZone = new JComboBox();
    private boolean sourceListInit = false;
    private int currentId = 0;

    public InterfaceEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "interface");
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.number, new GridBagConstraints(1, 0, 1, 1, 0.33, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.title, new GridBagConstraints(3, 0, 1, 1, 0.33, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u0417\u043e\u043d\u0430:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add(this.comboZone, new GridBagConstraints(5, 0, 1, 1, 0.33, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.okCancel, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView((Component)this.table);
        this.sourceList.setSelectionMode(0);
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InterfaceEditor.this.setData();
            }
        });
        JPanel sourceListPane = new JPanel(new GridBagLayout());
        sourceListPane.add((Component)new JScrollPane(this.sourceList), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        sourceListPane.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 "));
        sourceListPane.setMinimumSize(new Dimension(250, 0));
        sourceListPane.setPreferredSize(new Dimension(250, 0));
        this.add(sourceListPane, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(scrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceEditor.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InterfaceEditor.this.editItem();
                }
            }
        });
        this.number.setMinValue(-1L);
    }

    public void setData() {
        Request request;
        if (!this.sourceListInit) {
            request = new Request();
            request.setModule("load");
            request.setModuleId(this.getModuleId());
            request.setAction("SourceList");
            Document doc = this.getDocument(request);
            ClientUtils.buildList(this.sourceList, this.sourceModel, (Node)XMLUtils.getNode((Document)doc, (String)"list"));
            this.sourceListInit = true;
        }
        this.editorPanel.setVisible(false);
        request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("Iface");
        BGUListItem listItem = this.sourceList.getSelectedValue();
        if (listItem != null) {
            request.setAttribute("source_id", listItem.getId());
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            }
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            if (Utils.isEmptyString((String)this.title.getText().trim())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("IfaceUpdate");
            request.setContractId(this.getContractId());
            request.setAttribute("id", this.currentId);
            request.setAttribute("title", this.title.getText());
            request.setAttribute("number", this.number.getText());
            ComboBoxItem item = (ComboBoxItem)this.comboZone.getSelectedItem();
            request.setAttribute("zone_id", item.getObject());
            BGUListItem listItem = this.sourceList.getSelectedValue();
            request.setAttribute("source_id", listItem.getId());
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setData();
                this.editorPanel.setVisible(false);
            }
        } else {
            this.editorPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        String id = ClientUtils.getRowId((BGTable)this.table);
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAction("IfaceDelete");
            request.setAttribute("id", id);
            BGUListItem listItem = this.sourceList.getSelectedValue();
            request.setAttribute("source_id", listItem.getId());
            this.stopEdit(false);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setData();
            }
        }
    }

    public void editItem() {
        this.currentId = Utils.parseInt((String)ClientUtils.getRowId((BGTable)this.table), (int)-1);
        if (this.currentId > 0) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.currentId = 0;
        this.startEdit();
    }

    private void startEdit() {
        Document doc;
        Request request;
        String zone = null;
        if (this.currentId > 0) {
            request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAction("IfaceGet");
            request.setAttribute("id", this.currentId);
            doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element element = XMLUtils.getElement((Document)doc, (String)"iface");
                this.title.setText(element.getAttribute("title"));
                this.number.setText(element.getAttribute("number"));
                zone = element.getAttribute("zone_id");
            }
        } else {
            this.title.setText("");
            this.number.setText("");
        }
        request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAction("ZoneList");
        request.setAttribute("id", this.currentId);
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.comboZone, (Node)XMLUtils.getNode((Document)doc, (String)"zones"), zone);
        }
        this.editorPanel.setVisible(true);
    }
}

