/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import bitel.billing.server.admin.resource.bean.Resource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;

public abstract class ResourceManager<T extends Resource> {
    protected Connection con;
    protected int mid;
    protected String tableName;

    public ResourceManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = this.getTableName() + "_" + mid;
    }

    public void changeResourceCategory(String ids, int categoryId) {
        try {
            String query = "UPDATE " + this.tableName + " SET category_id=? WHERE id IN (" + ids + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, categoryId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getResourceCount(int categoryId) {
        int result = 0;
        try {
            String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE category_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, categoryId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteResource(String id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id IN(" + id + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadStandartResourceFromRs(ResultSet rs, Resource res) throws SQLException {
        res.setId(rs.getInt("id"));
        res.setDateFrom(rs.getDate("date1"));
        res.setDateTo(rs.getDate("date2"));
        res.setCategoryId(rs.getInt("category_id"));
    }

    public abstract void updateResource(T var1) throws BGException;

    protected abstract T getResourceFromRs(ResultSet var1) throws SQLException;

    protected abstract String getTableName();

    public static ResourceManager<?> newResourceManager(String module, Connection con, int mid) throws BGException {
        try {
            Class<?> clazz = null;
            if ("ipn".equals(module)) {
                clazz = Class.forName("bitel.billing.server.ipn.bean.IPNResourceManager");
            } else if ("dialup".equals(module)) {
                clazz = Class.forName("bitel.billing.server.dialup.bean.DialupIPResourceManager");
            } else if ("phone".equals(module)) {
                clazz = Class.forName("bitel.billing.server.admin.resource.bean.NumberResourceManager");
            }
            return clazz.asSubclass(ResourceManager.class).getConstructor(Connection.class, Integer.TYPE).newInstance(con, mid);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void syncResourceUse() throws BGException {
    }
}

