/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;

public class ActionGetPatternList
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Element patterns = this.createElement(this.rootNode, "patterns");
        Set<Integer> domainIds = null;
        if (!PermissionOfRoles.isAdmin(this.userId)) {
            Optional<Role> role = PermissionOfRoles.getRoleByUserId(this.userId);
            if (role.isEmpty()) {
                return;
            }
            List<PermissionKit> kits = role.get().getPermissionKits();
            if (Utils.isEmptyCollection(kits)) {
                return;
            }
            HashSet<Integer> domainsInKits = new HashSet<Integer>();
            for (PermissionKit kit : kits) {
                domainsInKits.addAll(kit.getDomenIds());
            }
            domainIds = DomainRuntimeMap.getInstance().getAllDescendantDomainIds(domainsInKits);
        }
        if (this.request.getParameter("nondef") == null && this.setup.getBoolean("contract.template.default.enable", false)) {
            this.addListItem((Node)patterns, "0", "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        }
        String query = "SELECT id, title, domainId FROM contract_pattern ORDER BY title";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                int domainId = rs.getInt(3);
                if (domainId > 0 && Utils.notEmptyCollection(domainIds) && !domainIds.contains(domainId)) continue;
                this.addListItem((Node)patterns, rs.getString(1), rs.getString(2));
            }
        }
    }
}

