/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean.find;

import bitel.billing.server.contract.bean.find.SearchContract;
import bitel.billing.server.contract.bean.find.SearchContractByAddress;
import bitel.billing.server.contract.bean.find.SearchContractByComment;
import bitel.billing.server.contract.bean.find.SearchContractByEmail;
import bitel.billing.server.contract.bean.find.SearchContractById;
import bitel.billing.server.contract.bean.find.SearchContractByLogin;
import bitel.billing.server.contract.bean.find.SearchContractByParameter;
import bitel.billing.server.contract.bean.find.SearchContractByPhone;
import bitel.billing.server.contract.bean.find.SearchContractByTitle;
import bitel.billing.server.contract.bean.find.SearchContractModule;
import bitel.billing.server.contract.bean.find.SearchContractModuleEmpty;
import bitel.billing.server.contract.bean.find.SearchConvertPattern;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class SearchContracts {
    private static final Logger log = LogManager.getLogger();
    private static final Map<String, SearchContractModule> searchContractMap = new HashMap<String, SearchContractModule>();
    private static final SearchContractModule empty = new SearchContractModuleEmpty();
    public final SearchContract[] searchContracts;
    private final boolean and;

    public SearchContracts(Map<String, String> params) {
        SearchContract[] searchContracts = SearchContracts.loadSearchContracts(params);
        boolean and = "and".equals(params.get("mode"));
        this.searchContracts = searchContracts;
        this.and = and;
    }

    public final List<Contract> findContract(Connection con, Calendar date, String[] tokens, StringBuilder report) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            boolean first = true;
            for (SearchContract s : this.searchContracts) {
                if (s.pos > tokens.length) continue;
                String param = tokens[s.pos - 1];
                List<Contract> subResult = s.findContract(con, param, date, report);
                if (this.and) {
                    if (subResult.size() == 0) {
                        return Collections.emptyList();
                    }
                    if (first) {
                        result.addAll(subResult);
                    } else {
                        HashSet<Contract> forRemove = new HashSet<Contract>();
                        for (Contract contract : result) {
                            if (subResult.contains((Object)contract)) continue;
                            forRemove.add(contract);
                        }
                        result.removeAll(forRemove);
                    }
                } else {
                    result.addAll(subResult);
                }
                first = false;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public boolean isAndSearch() {
        return this.and;
    }

    public static SearchContract[] loadSearchContracts(Map<String, String> params) {
        String mode;
        ArrayList<SearchContract> result = new ArrayList<SearchContract>();
        int i = 1;
        while ((mode = params.get(i + ".type")) != null) {
            int pid = Utils.parseInt((String)params.get(i + ".pid"), (int)0);
            int mid = Utils.parseInt((String)params.get(i + ".mid"), (int)0);
            int pos = Utils.parseInt((String)params.get(i + ".pos"), (int)0);
            int regime = Utils.parseInt((String)params.get(i + ".regime"), (int)1);
            String replace = params.get(i + ".replace");
            String groupsStr = params.get(i + ".groups");
            long groups = groupsStr != null ? Utils.enumToMask((String)groupsStr) : 0L;
            String patternTitle = params.get(i + ".pattern");
            boolean noContractPeriodCheck = Utils.parseInt((String)params.get(i + ".no.contract.period.check")) == 1;
            SearchContractModule search = regime == 0 ? empty : SearchContracts.getSearchContractModule(mode);
            SearchConvertPattern[] conv = SearchConvertPattern.getPatterns(replace);
            SearchContract s = new SearchContract(search, mid, pid, pos, conv, regime, groups, patternTitle, !noContractPeriodCheck);
            result.add(s);
            ++i;
        }
        SearchContract[] ar = new SearchContract[result.size()];
        return result.toArray(ar);
    }

    public static SearchContractModule getSearchContractModule(String mode) {
        SearchContractModule result = searchContractMap.get(mode);
        if (result != null) {
            return result;
        }
        log.warn("SearchContract: can't find search mode: '" + mode + "'");
        return empty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("mode= " + (this.and ? "and\n" : "or\n"));
        for (SearchContract s : this.searchContracts) {
            sb.append(s.toString());
            sb.append("\n\n");
        }
        return sb.toString();
    }

    static {
        try {
            SearchContractModule search = empty;
            searchContractMap.put(search.getName().intern(), search);
            search = new SearchContractByTitle();
            searchContractMap.put(search.getName().intern(), search);
            search = new SearchContractById();
            searchContractMap.put(search.getName().intern(), search);
            search = new SearchContractByComment();
            searchContractMap.put(search.getName().intern(), search);
            search = new SearchContractByParameter();
            searchContractMap.put(search.getName().intern(), search);
            search = new SearchContractByLogin();
            searchContractMap.put(search.getName().intern(), search);
            search = new SearchContractByPhone();
            searchContractMap.put(search.getName().intern(), search);
            search = new SearchContractByEmail();
            searchContractMap.put(search.getName().intern(), search);
            search = new SearchContractByAddress();
            searchContractMap.put(search.getName().intern(), search);
            List<BGInstalledModule> moduleList = ModuleCache.getInstance().getInstalledModulesList();
            for (BGInstalledModule module : moduleList) {
                Map<String, Element> extensionMap = module.getServerExtensionMap();
                if (extensionMap == null || !extensionMap.containsKey(SearchContracts.class.getName())) continue;
                for (Element elem : XMLUtils.selectElements((Node)extensionMap.get(SearchContracts.class.getName()), (String)"search")) {
                    String className = elem.getAttribute("class");
                    try {
                        Object comp = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!(comp instanceof SearchContractModule)) continue;
                        search = (SearchContractModule)comp;
                        searchContractMap.put(search.getName().intern(), search);
                    }
                    catch (Exception e) {
                        log.error("\u041e\u0431\u044a\u0435\u043a\u0442 \u043a\u043b\u0430\u0441\u0441\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f " + module.getName() + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

