/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext;

import bitel.billing.server.ext.ExtSetup;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public abstract class ExtServer {
    protected abstract ExtSetup newSetup();

    protected abstract void showHelp();

    public void sendCommand(String[] args) {
        StringBuilder command = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            command.append(args[i] + " ");
        }
        this.sendCommand(command.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(String args) {
        Socket socket = null;
        try {
            ExtSetup setup = this.newSetup();
            int adm_port = setup.getInt("admin.port", 1899);
            socket = new Socket(InetAddress.getByName("127.0.0.1"), adm_port);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String trimCommand = args.trim();
            out.println(trimCommand);
            String line = null;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception ex) {
            System.err.println("Error: " + ex.getLocalizedMessage());
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    public void parseParams(String[] args) {
        if (args[0].equals("help") || args[0].equals("?")) {
            this.showHelp();
        } else {
            this.sendCommand(args);
        }
    }
}

