/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.client;

import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.base.phone.client.CostMapTree;
import ru.bitel.bgbilling.kernel.base.phone.client.ServiceConfigCostMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMapItem;
import ru.bitel.bgbilling.kernel.base.phone.common.service.PhoneService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.treetable.BGTreeTableModel;

class CostMapTreeEditor
extends BGUPanel {
    private final ServiceConfigCostMap serviceConfigCostMap;
    private int currentMapId = -1;
    private BGUTreeTable treeTable;
    private BGTreeTableModel<CostMapItem> model;
    private BGEditor editor;
    private String selectedCode = null;
    private CostMapTree costMapTree;

    public CostMapTreeEditor(ServiceConfigCostMap serviceConfigCostMap, CostMapTree costMapTree) {
        super((LayoutManager)new GridBagLayout());
        this.serviceConfigCostMap = serviceConfigCostMap;
        this.costMapTree = costMapTree;
        this.setName("tree");
    }

    protected void jbInit() {
        this.model = new BGTreeTableModel<CostMapItem>("phoneCode"){

            protected void initColumns() {
                this.addColumn("\u041f\u0440\u0435\u0444\u0438\u043a\u0441", CostMapItem.class, -1, 300, -1, null, false);
                this.addColumn("\u0426\u0435\u043d\u0430", 200, 200, 200, "cost", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 300, -1, "title", false);
            }

            public Object getValue(CostMapItem val, int column) throws BGException {
                switch (column) {
                    case 0: {
                        if (val == this.root) {
                            return "\u041f\u0440\u0435\u0444\u0438\u043a\u0441\u044b";
                        }
                        return val.getCode() + (String)(val.getDestination() != null ? " " + val.getDestination() : "");
                    }
                }
                return super.getValue((Object)val, column);
            }
        };
        this.treeTable = new BGUTreeTable(this.model);
        this.editor = new BGEditor();
        this.editor.addForm((JComponent)((Object)new CostMapTreeItemEditor()));
        this.editor.addForm((JComponent)((Object)new CostMapImport()));
        this.editor.addForm((JComponent)((Object)new CostMapExport()));
        this.editor.setVisible(false);
        this.editor.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.editor.performAction(e.getActionCommand()), new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.IMPORT, BGDialogToolBar.ButtonData.EXPORT});
        toolBar.setFloatable(false);
        toolBar.compact();
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        BGTextField find = new BGTextField(20);
        JPanel panel = new JPanel(new GridBagLayout());
        BGButton findButton = new BGButton("\u041d\u0430\u0439\u0442\u0438");
        panel.add((Component)find, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)findButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        ActionListener actionListener = e -> {
            String text = find.getText();
            CostMapItem root = (CostMapItem)((Object)((Object)this.model.getRoot()));
            CostMapItem[] items = (CostMapItem[])root.findCodePath(text);
            if (items.length > 0) {
                this.treeTable.scrollPathToVisible(new TreePath((Object[])items));
                TreePath path = new TreePath((Object[])items);
                this.treeTable.expandPath(path);
                this.treeTable.setSelectionPath(path);
                this.treeTable.scrollPathToVisible(path);
            }
        };
        findButton.addActionListener(actionListener);
        find.addActionListener(actionListener);
        this.add(panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        this.add(new JScrollPane((Component)this.treeTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        this.editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.treeTable, "enabled", "oldValue"));
        this.editor.addActionListener("ok", e -> this.setData());
        BGButton close = new BGButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        close.addActionListener(e -> this.performActionClose());
        this.add((Component)close, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 3, 3, 3), 0, 0));
    }

    protected void initActions() {
    }

    public void setData() {
        CostMap costMap = (CostMap)((Object)this.serviceConfigCostMap.table.model.getSelectedRow());
        if (costMap != null) {
            this.currentMapId = costMap.getId();
            CostMapItem root = new CostMapItem();
            try {
                this.getTree(root, new JSONObject(this.costMapTree.get(this.currentMapId)));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            if (root != null) {
                this.model.setData((Object)root);
                if (this.selectedCode != null) {
                    TreePath path = new TreePath((Object[])((CostMapItem)((Object)this.model.getRoot())).findCodePath(this.selectedCode));
                    this.treeTable.expandPath(path);
                    this.treeTable.setSelectionPath(path);
                    this.treeTable.scrollPathToVisible(path);
                }
                this.selectedCode = null;
                this.performActionOpen();
            }
        }
    }

    private void getTree(CostMapItem i, JSONObject json) {
        i.setId(json.optInt("id"));
        i.setCode(json.optString("code"));
        i.setTitle(json.optString("title"));
        i.setCost(json.optBigDecimal("cost", BigDecimal.ZERO));
        i.setDestination(json.optString("dest"));
        i.setDestinationId(json.getInt("destId"));
        JSONArray array = json.optJSONArray("childs");
        if (array != null) {
            for (int index = 0; index < array.length(); ++index) {
                CostMapItem childCostMapItem = new CostMapItem();
                this.getTree(childCostMapItem, array.optJSONObject(index));
                i.addChild(childCostMapItem);
            }
        }
    }

    private class CostMapTreeItemEditor
    extends BGUPanel {
        private BGTextField code;
        private BGTextField cost;

        public CostMapTreeItemEditor() {
            super((LayoutManager)new GridBagLayout());
            this.code = new BGTextField();
            this.cost = new BGTextField();
            this.setName("itemEdiitor");
        }

        protected void jbInit() {
            this.code.setHorizontalAlignment(0);
            this.add(new JLabel("\u041a\u043e\u0434:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            this.add((Component)this.code, new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 17, 2, new Insets(3, 5, 3, 0), 0, 0));
            this.add(new JLabel("\u0426\u0435\u043d\u0430:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 3, 0), 0, 0));
            this.add((Component)this.cost, new GridBagConstraints(3, 0, 1, 1, 0.6, 0.0, 17, 2, new Insets(3, 5, 3, 3), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.code.setEditable(true);
                this.code.setText("");
                this.cost.setText("");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                CostMapItem item = (CostMapItem)((Object)((Object)CostMapTreeEditor.this.model.getSelectedRow()));
                if (item != null) {
                    this.code.setEditable(true);
                    this.code.setText(item.getCode());
                    this.cost.setText(Utils.formatCost((BigDecimal)item.getCost()));
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                List items = CostMapTreeEditor.this.model.getSelectedRows();
                if (items != null && !items.isEmpty() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0446\u0435\u043d\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    boolean Ok = false;
                    for (CostMapItem item : items) {
                        Request request = ((ClientContext)this.getContext()).newRequest("CostMap");
                        request.setModule("base.phone");
                        request.setAttribute("operation", "deleteItem");
                        request.setAttribute("costMapId", CostMapTreeEditor.this.currentMapId);
                        request.setAttribute("code", item.getCode());
                        if (!ClientUtils.checkStatus((Document)((ClientContext)this.getContext()).getDocument(request))) continue;
                        Ok = true;
                    }
                    if (Ok) {
                        CostMapItem item;
                        TreePath path = CostMapTreeEditor.this.treeTable.getSelectionPath().getParentPath();
                        if (path != null && (item = (CostMapItem)((Object)((Object)path.getLastPathComponent()))) != null) {
                            CostMapTreeEditor.this.selectedCode = item.getCode();
                        }
                        this.performActionClose();
                        CostMapTreeEditor.this.setData();
                    }
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "Ok"){

                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    Request req = ((ClientContext)CostMapTreeItemEditor.this.getContext()).newRequest("CostMap");
                    req.setModule("base.phone");
                    req.setAttribute("operation", "updateItem");
                    req.setAttribute("costMapId", CostMapTreeEditor.this.currentMapId);
                    req.setAttribute("code", CostMapTreeItemEditor.this.code.getText());
                    req.setAttribute("cost", CostMapTreeItemEditor.this.cost.getText());
                    if (ClientUtils.checkStatus((Document)((ClientContext)CostMapTreeItemEditor.this.getContext()).getDocument(req))) {
                        CostMapTreeEditor.this.selectedCode = CostMapTreeItemEditor.this.code.getText();
                        CostMapTreeItemEditor.this.performActionClose();
                    }
                }
            };
        }
    }

    private class CostMapImport
    extends BGUPanel {
        private JRadioButton fileSource;
        private JRadioButton clipSource;
        private JRadioButton importLoad;
        private JRadioButton importUpdate;
        private BGSelectFilePanel fileSelect;
        private IntTextField prefix;
        private JTextArea clipboard;

        public CostMapImport() {
            super((LayoutManager)new GridBagLayout());
            this.fileSource = new JRadioButton("\u0444\u0430\u0439\u043b\u0430");
            this.clipSource = new JRadioButton("\u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430");
            this.importLoad = new JRadioButton("\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c");
            this.importUpdate = new JRadioButton("\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
            this.setName("import");
        }

        protected void jbInit() {
            this.fileSelect = new BGSelectFilePanel();
            this.prefix = new IntTextField();
            this.clipboard = new JTextArea();
            this.clipboard.setEditable(false);
            ButtonGroup group = new ButtonGroup();
            group.add(this.fileSource);
            group.add(this.clipSource);
            group = new ButtonGroup();
            group.add(this.importLoad);
            group.add(this.importUpdate);
            this.add(new JLabel("\u0412\u0437\u044f\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add(this.fileSource, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add(this.clipSource, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add(new JLabel("\u041e\u043f\u0446\u0438\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            this.add(this.importLoad, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add(this.importUpdate, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add(new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)this.fileSelect, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 0, 3), 0, 0));
            this.add(new JLabel("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0435\u0444\u0438\u043a\u0441:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)this.prefix, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 5, 0, 3), 0, 0));
            new IntTextField();
            JScrollPane clipScroll = new JScrollPane(this.clipboard);
            clipScroll.setMinimumSize(new Dimension(100, 150));
            clipScroll.setPreferredSize(new Dimension(100, 150));
            this.add(new JLabel("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430:"), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add(clipScroll, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.fileSource.setSelected(true);
            this.importLoad.setSelected(true);
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("import", "import"){

                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    try {
                        CostMapImport.this.clipboard.setText((String)CostMapImport.this.getToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    CostMapImport.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0418\u043c\u043f\u043e\u0440\u0442"){

                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    String data;
                    block11: {
                        data = null;
                        if (CostMapImport.this.fileSource.isSelected()) {
                            File file = CostMapImport.this.fileSelect.getSelectedFile();
                            if (file == null) {
                                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                                return;
                            }
                            try (FileInputStream fis = new FileInputStream(file);){
                                data = new String(Utils.readByBlock((InputStream)fis), "UTF-8");
                                break block11;
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                                return;
                            }
                        }
                        data = CostMapImport.this.clipboard.getText();
                    }
                    if (Utils.isBlankString((String)data)) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                        return;
                    }
                    Request req = ((ClientContext)CostMapImport.this.getContext()).newRequest("CostMap");
                    req.setModule("base.phone");
                    req.setAttribute("operation", "importMap");
                    req.setAttribute("costMapId", CostMapTreeEditor.this.currentMapId);
                    req.setAttribute("update", CostMapImport.this.importUpdate.isSelected() ? 1 : 0);
                    req.setAttribute("prefix", CostMapImport.this.prefix.getText());
                    req.setAttribute("data", data);
                    if (ClientUtils.checkStatus((Document)((ClientContext)CostMapImport.this.getContext()).getDocument(req))) {
                        CostMapImport.this.performActionClose();
                    }
                }
            };
        }
    }

    private class CostMapExport
    extends BGUPanel {
        private JRadioButton exportAll;
        private JRadioButton exportSelected;
        private BGSelectFilePanel fileSelect;

        public CostMapExport() {
            super((LayoutManager)new GridBagLayout());
            this.exportAll = new JRadioButton("\u0432\u0441\u0451");
            this.exportSelected = new JRadioButton("\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0443\u0437\u0435\u043b");
            this.setName("export");
        }

        protected void jbInit() {
            ButtonGroup group = new ButtonGroup();
            group.add(this.exportAll);
            group.add(this.exportSelected);
            this.exportAll.setSelected(true);
            this.fileSelect = new BGSelectFilePanel();
            this.add(new JLabel("\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add(this.exportAll, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add(this.exportSelected, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add(new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            this.add((Component)this.fileSelect, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 3, 3), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("export", "export"){

                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    CostMapExport.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442"){

                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    CostMapItem item;
                    File file = CostMapExport.this.fileSelect.getSelectedFile();
                    if (file == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                        return;
                    }
                    String code = null;
                    if (CostMapExport.this.exportSelected.isSelected() && (item = (CostMapItem)((Object)CostMapTreeEditor.this.model.getSelectedRow())) != null) {
                        code = item.getCode();
                    }
                    try {
                        FileWriter fw = new FileWriter(file);
                        fw.write(((PhoneService)((ClientContext)CostMapExport.this.getContext()).getWebService(PhoneService.class)).exportCostMap(CostMapTreeEditor.this.currentMapId, code));
                        fw.flush();
                        fw.close();
                        CostMapExport.this.performActionClose();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    }
                }
            };
        }
    }
}

