/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.web.action;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.TransactionUtils;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.container.web.action.ActionContext;
import ru.bitel.bgbilling.kernel.container.web.action.ActionRequest;
import ru.bitel.bgbilling.kernel.contract.api.server.Module;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.basic.server.bean.ModulePaymentMethods;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public abstract class AbstractAction {
    protected int userId = -1;
    protected int moduleId = -1;
    protected int contractId = -1;
    protected String moduleName;
    protected Setup setup = null;
    protected ModuleSetup moduleSetup = null;
    protected ActionContext context;
    protected ActionRequest req;
    final Map<String, Object> result = new LinkedHashMap<String, Object>(8);
    static final String ACTION_RESULT = "result";
    protected Connection con;

    public AbstractAction(String moduleName) {
        this.moduleName = moduleName;
    }

    public void execute() throws BGException {
        this.setResultParam("jspPage", this.moduleName + "/body.jsp");
        if (this.req.getBoolean("getBody", false)) {
            this.requestDispatcher(this.moduleName, "body");
        }
    }

    protected void setResult(Object result) {
        this.result.put(ACTION_RESULT, result);
    }

    protected Map<String, Object> getResult() {
        return this.result;
    }

    protected String getPageTitle(int webMenuItemId, String moduleName) throws BGException {
        return this.getPageTitle(webMenuItemId, moduleName, 0);
    }

    protected String getPageTitle(int webMenuItemId, String moduleName, int moduleId) throws BGException {
        BGModule bgModule = null;
        ModuleBase moduleBase = null;
        if (moduleId == 0) {
            moduleBase = new Module();
        } else {
            bgModule = ModuleCache.getInstance().getModule(moduleId);
            if (bgModule != null && bgModule.getName().equals(moduleName)) {
                try {
                    moduleBase = (ModuleBase)Class.forName(bgModule.getInstalledModule().getPackageServer() + ".Module").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            }
        }
        if (moduleBase != null) {
            for (MenuItem menuItem : moduleBase.getWebMenuItems(this.con, moduleName, moduleId)) {
                if (menuItem.getId() != webMenuItemId) continue;
                return menuItem.getTitle();
            }
        }
        return bgModule == null ? "\u041e\u043f\u043b\u0430\u0442\u0430" : bgModule.getGuiTitle();
    }

    protected void setResultParam(String name, Object param) {
        this.result.put(name, param);
    }

    protected Object getResultParam(String name) {
        return this.result.get(name);
    }

    protected void addYearsElement(Result<?> result, ParameterMap moduleSetup) {
        int showYears = moduleSetup.getInt("showyears", 3);
        int currentYear = new GregorianCalendar().get(1);
        ArrayList<IdTitle> yearList = new ArrayList<IdTitle>();
        for (int i = 0; i < showYears; ++i) {
            int yearValue = currentYear - i;
            IdTitle year = new IdTitle();
            year.setId(yearValue);
            year.setTitle(String.valueOf(yearValue));
            yearList.add(year);
        }
        result.setAttribute("year_list", yearList);
    }

    @Deprecated
    protected Period getPeriodByYearsAndDays() {
        GregorianCalendar currentDate = new GregorianCalendar();
        int year = this.req.getInt("year", currentDate.get(1));
        int month = this.req.getInt("month", currentDate.get(2) + 1);
        int dayFrom = this.req.getInt("day_from", 0);
        int dayTo = this.req.getInt("day_to", 0);
        int day = this.req.getInt("day", 0);
        this.setResultParam("year", year);
        this.setResultParam("month", month);
        this.setResultParam("day_from", dayFrom);
        this.setResultParam("day_to", dayTo);
        if (day > 0) {
            dayFrom = day;
            dayTo = day;
        }
        if (dayFrom <= 0) {
            dayFrom = 1;
        }
        if (dayTo <= 0) {
            dayTo = ((Calendar)currentDate).getActualMaximum(5);
        }
        Period p = new Period(year, month - 1, dayFrom, dayTo);
        this.setResultParam("date_from", p.getDateFrom());
        this.setResultParam("date_to", p.getDateTo());
        if (TimeUtils.dateEqual((Date)p.getDateFrom(), (Date)p.getDateTo())) {
            this.setResultParam("day", p.getDateFromCalendar().get(5));
        }
        this.setResultParam("period", p);
        this.setResultParam("now", new Date());
        return p;
    }

    protected Period getPeriodByYearMonthDays() {
        Period period = new Period();
        GregorianCalendar calendar = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        int year = this.req.getInt("year", calendar.get(1));
        calendar.set(1, year);
        int month = this.req.getInt("month", calendar.get(2) + 1);
        if (month < 1 || month > 12) {
            month = calendar.get(2) + 1;
        }
        calendar.set(2, month - 1);
        int dayMax = ((Calendar)calendar).getActualMaximum(5);
        int dayFrom = this.req.getInt("day_from", 1);
        if (dayFrom < 0 || dayFrom > dayMax) {
            dayFrom = 1;
        }
        calendar.set(5, dayFrom);
        period.setDateFrom(calendar.getTime());
        int dayTo = this.req.getInt("day_to", dayMax);
        if (dayTo < dayFrom || dayTo > dayMax) {
            dayTo = dayMax;
        }
        calendar.set(5, dayTo);
        ((Calendar)calendar).add(5, 1);
        ((Calendar)calendar).add(14, -1);
        period.setDateTo(calendar.getTime());
        Element dateElement = XMLUtils.createElement((Element)((Element)this.context.getRootNode()), (String)"date");
        dateElement.setAttribute("year", String.valueOf(year));
        dateElement.setAttribute("month", String.valueOf(month));
        dateElement.setAttribute("day_from", String.valueOf(dayFrom));
        dateElement.setAttribute("day_to", String.valueOf(dayTo));
        return period;
    }

    protected Period getPeriodByYearMonthDay() {
        Period period = new Period();
        GregorianCalendar now = new GregorianCalendar();
        Calendar calendar = (Calendar)((Calendar)now).clone();
        int year = this.req.getInt("year", calendar.get(1));
        calendar.set(1, year);
        int month = this.req.getInt("month", calendar.get(2) + 1);
        if (month < 1 || month > 12) {
            month = calendar.get(2) + 1;
        }
        calendar.set(2, month - 1);
        int day = this.req.getInt("day", 0);
        int dayMax = calendar.getActualMaximum(5);
        if (day < 1 || day > dayMax) {
            day = 0;
            calendar.set(5, 1);
            period.setDateFrom(calendar.getTime());
            calendar.set(5, dayMax);
            period.setDateTo(calendar.getTime());
        } else {
            calendar.set(5, day);
            period.setDateFrom(calendar.getTime());
            period.setDateTo(calendar.getTime());
        }
        Element dateElement = XMLUtils.createElement((Element)((Element)this.context.getRootNode()), (String)"date");
        dateElement.setAttribute("year", String.valueOf(year));
        dateElement.setAttribute("month", String.valueOf(month));
        dateElement.setAttribute("day", String.valueOf(day));
        return period;
    }

    protected Page getPage() {
        return this.getPage(10);
    }

    protected Page getPage(int defaultPageSize) {
        Page page = new Page();
        page.setPageIndex(this.req.getInt("pageIndex", 1));
        page.setPageSize(this.req.getInt("pageSize", defaultPageSize));
        this.setResultParam("page", page);
        return page;
    }

    protected Period getPeriod() {
        GregorianCalendar nowDate = new GregorianCalendar();
        int mm = this.req.getInt("month", nowDate.get(2) + 1);
        int yy = this.req.getInt("year", nowDate.get(1));
        Period period = new Period(yy, mm - 1, 1, 32);
        this.setResultParam("period", period);
        return period;
    }

    protected String getStatus(AbstractTransactionStatus statusDefault) {
        String status = this.req.get("status");
        if (status == null) {
            status = statusDefault.getCode();
        }
        this.setResultParam("status", status);
        try {
            this.setResultParam("statusList", Arrays.asList((AbstractTransactionStatus[])statusDefault.getClass().getMethod("values", new Class[0]).invoke((Object)statusDefault, new Object[0])));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return status;
    }

    protected void setMinMaxSum(String prefix, Class<?> constantsClass) {
        TransactionUtils.setMinMaxSum((ParameterMap)this.moduleSetup, this.result, (String)prefix.toUpperCase(), constantsClass);
    }

    protected void setPaymentMethods() {
        BGModule bgModule = ModuleCache.getInstance().getModule(this.moduleId);
        try {
            Class<?> clazz = Class.forName(bgModule.getInstalledModule().getPackageServer() + ".Module");
            if (clazz.isAnnotationPresent(BGPaymentModule.class)) {
                ModuleBase moduleBase = (ModuleBase)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.setResultParam("paymentMethods", moduleBase.getPaymentMethods(bgModule.getId()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setModulePaymentMethods() {
        ArrayList<ModulePaymentMethods> modulePaymentMethods = new ArrayList<ModulePaymentMethods>();
        Set<Object> contractModuleIds = new HashSet();
        if (this.contractId > 0) {
            try {
                contractModuleIds = new ContractModuleManager(this.con).getContractModuleSet(this.contractId);
            }
            catch (Exception ex) {
                LogManager.getLogger().error((Object)ex);
            }
        }
        for (BGModule bgModule : ModuleCache.getInstance().getModulesList()) {
            if (!contractModuleIds.contains(bgModule.getId())) continue;
            try {
                Class<?> clazz = Class.forName(bgModule.getInstalledModule().getPackageServer() + ".Module");
                if (!clazz.isAnnotationPresent(BGPaymentModule.class) || !Setup.getSetup().getModuleSetup(bgModule.getId()).getBoolean(bgModule.getName() + ".enable", true)) continue;
                ModuleBase moduleBase = (ModuleBase)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                ModulePaymentMethods methods = new ModulePaymentMethods();
                methods.setBgModule(bgModule);
                methods.setPaymentMethods(moduleBase.getPaymentMethods(bgModule.getId()));
                methods.setPaymentMode(moduleBase.getPaymentMode());
                modulePaymentMethods.add(methods);
            }
            catch (Exception exception) {}
        }
        this.setResultParam("modulePaymentMethods", modulePaymentMethods);
    }

    protected void setAutopaymentData(int moduleId, int contractId, ParameterMap moduleSetup, Connection con, String prefix, AbstractAutopaymentManager autopaymentManager, Class<?> constantsClass) throws BGException {
        TransactionUtils.setAutopaymentData((int)moduleId, (int)contractId, (ParameterMap)moduleSetup, this.result, (Connection)con, (String)prefix, (AbstractAutopaymentManager)autopaymentManager, constantsClass);
    }

    protected void setCustomerAddress(String prefix, Class<?> constantsClass) throws BGException {
        prefix = prefix.toUpperCase();
        String keyCustomerAddressEnable = this.getFieldValue(constantsClass, "KEY_" + prefix + "_FISCALIZATION_CUSTOMER_ADDRESS_ENABLE", "");
        String keyCustomerAddressTitle = this.getFieldValue(constantsClass, "KEY_" + prefix + "_FISCALIZATION_CUSTOMER_ADDRESS_TITLE", "");
        String keyCustomerAddressRequired = this.getFieldValue(constantsClass, "KEY_" + prefix + "_FISCALIZATION_CUSTOMER_ADDRESS_REQUIRED", "");
        Setup setup = Setup.getSetup();
        boolean customerAddressEnable = this.moduleSetup != null ? this.moduleSetup.getBoolean(keyCustomerAddressEnable, false) : setup.getBoolean(keyCustomerAddressEnable, false);
        this.setResultParam("customerAddressEnable", customerAddressEnable);
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.con, this.moduleId);){
            if (customerAddressEnable) {
                this.setResultParam("customerAddressTitle", this.moduleSetup != null ? this.moduleSetup.get(keyCustomerAddressTitle, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 E-mail \u0438\u043b\u0438 \u043d\u043e\u043c\u0435\u0440 \u0441\u043e\u0442\u043e\u0432\u043e\u0433\u043e \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0447\u0435\u043a\u0430") : setup.get(keyCustomerAddressTitle, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 E-mail \u0438\u043b\u0438 \u043d\u043e\u043c\u0435\u0440 \u0441\u043e\u0442\u043e\u0432\u043e\u0433\u043e \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0447\u0435\u043a\u0430"));
                this.setResultParam("customerAddressRequired", this.moduleSetup != null ? this.moduleSetup.getBoolean(keyCustomerAddressRequired, false) : setup.getBoolean(keyCustomerAddressRequired, false));
                this.setResultParam("customerAddress", contractModuleConfigDao.get(this.contractId, "customerAddress"));
            }
            this.setResultParam("paymentPhone", contractModuleConfigDao.get(this.contractId, "payment.phone"));
        }
    }

    private String getFieldValue(Class<?> constantsClass, String fieldName, String defaultValue) {
        String result = defaultValue;
        try {
            result = (String)constantsClass.getDeclaredField(fieldName).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private int getIntFieldValue(Class<?> constantsClass, String fieldName, int defaultValue) {
        int result = defaultValue;
        try {
            result = (Integer)constantsClass.getDeclaredField(fieldName).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected void setCustomerEmail(boolean customerEmailEnable, boolean customerEmailRequired) throws BGException {
        this.setResultParam("customerEmailEnable", customerEmailEnable);
        if (customerEmailEnable) {
            this.setResultParam("customerEmailRequired", customerEmailRequired);
            try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.con, this.moduleId);){
                this.setResultParam("customerEmail", contractModuleConfigDao.get(this.contractId, "customerEmail"));
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected void paymentForm(String moduleName, Class<?> constantsClass, Class<?> autopaymentManagerClass) throws BGException {
        this.setMinMaxSum(moduleName, constantsClass);
        this.setCustomerAddress(moduleName, constantsClass);
        this.setPaymentMethods();
        if (autopaymentManagerClass != null) {
            try (AbstractAutopaymentManager autopaymentManager = (AbstractAutopaymentManager)((Object)autopaymentManagerClass.getConstructor(Connection.class, Integer.TYPE).newInstance(this.con, this.moduleId));){
                this.setAutopaymentData(this.moduleId, this.contractId, (ParameterMap)this.moduleSetup, this.con, moduleName, autopaymentManager, constantsClass);
            }
            catch (Exception ex) {
                LogManager.getLogger().error((Object)ex);
            }
        }
        this.requestDispatcher(moduleName, "form");
    }

    protected void requestDispatcher(String module, String jsp) {
        try {
            for (Map.Entry<String, Object> e : this.result.entrySet()) {
                this.context.request.setAttribute(e.getKey(), e.getValue());
            }
            this.context.response.setContentType("text/html; charset=utf-8");
            this.context.request.setAttribute("dataMap", this.result);
            this.context.request.setAttribute("contentType", (Object)ActionResultContentType.binary);
            this.context.request.getRequestDispatcher("/WEB-INF/jspf/" + module + "/" + jsp + ".jsp").include((ServletRequest)this.context.getRequest(), (ServletResponse)this.context.getResponse());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void autopaymentWeek(String prefix, Preferences modeDataMap, Autopayment autopayment, Class<?> constantsClass) {
        String keyDayDefault = prefix + ".autopayment.mode.week.day.default".toLowerCase();
        int autopaymentWeekDay = this.moduleSetup.getInt(keyDayDefault, 1);
        modeDataMap.set("autopayment.mode.week.day", String.valueOf(this.req.getInt("dayOfWeek", autopaymentWeekDay)));
        String keyWeekSumDefault = prefix + ".autopayment.mode.week.sum.default".toLowerCase();
        int weekSumDefault = this.getIntFieldValue(constantsClass, prefix + "_AUTOPAYMENT_MODE_WEEK_SUM_DEFAULT".toUpperCase(), 100);
        BigDecimal autopaymentWeekSum = this.moduleSetup.getBigDecimal(keyWeekSumDefault, new BigDecimal(weekSumDefault));
        autopaymentWeekSum = this.req.getBigDecimal("weekSum", autopaymentWeekSum);
        modeDataMap.set("autopayment.mode.week.sum", String.valueOf(autopaymentWeekSum));
        autopayment.setSum(autopaymentWeekSum);
        autopayment.setMode(AutopaymentMode.WEEK);
    }

    protected void autopaymentMonth(String prefix, Preferences modeDataMap, Autopayment autopayment, Class<?> constantsClass) {
        String keyMonthDefault = prefix + ".autopayment.mode.month.day.default".toLowerCase();
        int autopaymentMonthDay = this.moduleSetup.getInt(keyMonthDefault, 1);
        modeDataMap.set("autopayment.mode.month.day", String.valueOf(this.req.getInt("dayOfMonth", autopaymentMonthDay)));
        String keyMonthSumDefault = prefix + ".autopayment.mode.month.sum.default".toLowerCase();
        int monthSumDefault = this.getIntFieldValue(constantsClass, prefix + "_AUTOPAYMENT_MODE_MONTH_SUM_DEFAULT".toUpperCase(), 100);
        BigDecimal autopaymentMonthSum = this.moduleSetup.getBigDecimal(keyMonthSumDefault, new BigDecimal(monthSumDefault));
        autopaymentMonthSum = this.req.getBigDecimal("monthSum", autopaymentMonthSum);
        modeDataMap.set("autopayment.mode.month.sum", String.valueOf(autopaymentMonthSum));
        autopayment.setSum(autopaymentMonthSum);
        autopayment.setMode(AutopaymentMode.MONTH);
    }

    protected void autopaymentAuto(String prefix, Preferences modeDataMap, Autopayment autopayment, Class<?> constantsClass) {
        String keyAutoDaySumDefault = prefix + ".autopayment.mode.auto.day.sum.default".toLowerCase();
        int autoDaySumDefault = this.getIntFieldValue(constantsClass, prefix + "_AUTOPAYMENT_MODE_AUTO_DAY_SUM_DEFAULT".toUpperCase(), 100);
        BigDecimal autopaymentAutoMaxDaySum = this.moduleSetup.getBigDecimal(keyAutoDaySumDefault, new BigDecimal(autoDaySumDefault));
        autopaymentAutoMaxDaySum = this.req.getBigDecimal("maxDaySum", autopaymentAutoMaxDaySum);
        modeDataMap.set("autopayment.mode.auto.day.sum", String.valueOf(autopaymentAutoMaxDaySum));
        String keyAutoWeekSumDefault = prefix + ".autopayment.mode.auto.week.sum.default".toLowerCase();
        int autoWeekSumDefault = this.getIntFieldValue(constantsClass, prefix + "_AUTOPAYMENT_MODE_AUTO_WEEK_SUM_DEFAULT".toUpperCase(), 100);
        BigDecimal autopaymentAutoMaxWeekSum = this.moduleSetup.getBigDecimal(keyAutoWeekSumDefault, new BigDecimal(autoWeekSumDefault));
        autopaymentAutoMaxWeekSum = this.req.getBigDecimal("maxWeekSum", autopaymentAutoMaxWeekSum);
        modeDataMap.set("autopayment.mode.auto.week.sum", String.valueOf(autopaymentAutoMaxWeekSum));
        String keyAutoMonthSumDefault = prefix + ".autopayment.mode.auto.month.sum.default".toLowerCase();
        int autoMonthSumDefault = this.getIntFieldValue(constantsClass, prefix + "_AUTOPAYMENT_MODE_AUTO_MONTH_SUM_DEFAULT".toUpperCase(), 100);
        BigDecimal autopaymentAutoMaxMonthSum = this.moduleSetup.getBigDecimal(keyAutoMonthSumDefault, new BigDecimal(autoMonthSumDefault));
        autopaymentAutoMaxMonthSum = this.req.getBigDecimal("maxMonthSum", autopaymentAutoMaxMonthSum);
        modeDataMap.set("autopayment.mode.auto.month.sum", String.valueOf(autopaymentAutoMaxMonthSum));
        autopayment.setSum(autopaymentAutoMaxDaySum);
        autopayment.setMode(AutopaymentMode.AUTO);
    }
}

