/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;

public class ContractSubPanel_Group
extends ContractSubPanel {
    private List<ContractLabelItem> avaliableItems = new ArrayList<ContractLabelItem>();
    private List<ContractLabelItem> selectedItems = new ArrayList<ContractLabelItem>();
    private ContractLabelTree contractLabelTreeAvaliable = new ContractLabelTree();
    private ContractLabelTree contractLabelTreeSelected = new ContractLabelTree();
    private List<Integer> selectedIds = new ArrayList<Integer>();
    private final ContractLabelService contractLabelService;
    private final JPanel selectedLabelsPanel = this.initPanelForItems("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0433\u0440\u0443\u043f\u043f\u044b");
    private final JPanel availableLabelsPanel = this.initPanelForItems("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0433\u0440\u0443\u043f\u043f\u044b");
    private BGUComboBox<Domain> domainComboBox = new BGUComboBox();

    public ContractSubPanel_Group() {
        this.contractLabelService = (ContractLabelService)this.getContext().getPort(ContractLabelService.class);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        BGButton addButton = new BGButton("<");
        addButton.setColumns(5);
        addButton.addActionListener(e -> this.newItem());
        BGButton delButton = new BGButton(">", "delModule");
        delButton.addActionListener(e -> this.deleteItem());
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add(Box.createVerticalStrut(50), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)addButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        controlPanel.add((Component)delButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        controlPanel.add(Box.createGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(BGSwingUtilites.wrapBorder((JPanel)this.getDomainPanel(), (String)"\u0414\u043e\u043c\u0435\u043d"), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.selectedLabelsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add(controlPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.availableLabelsPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
    }

    private JPanel initPanelForItems(String titlePanel) {
        JPanel panel = new JPanel(new GridLayout());
        Dimension dimension = new Dimension(200, 200);
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.setBorder((Border)new BGTitleBorder(titlePanel));
        return panel;
    }

    private JPanel getDomainPanel() {
        BGButton domainUpdate = new BGButton((Action)new BGUAction("domain.update", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u043e\u043c\u0435\u043d"){

            public void actionPerformed(ActionEvent e) {
                Domain domain = (Domain)ContractSubPanel_Group.this.domainComboBox.getSelectedItem();
                if (domain == null) {
                    return;
                }
                if (!BGSwingUtilites.confirm((String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u043e\u043c\u0435\u043d", (Object)domain)) {
                    return;
                }
                try {
                    ((ContractService)ContractSubPanel_Group.this.getContext().getPort(ContractService.class, 0)).contractDomainUpdate(ContractSubPanel_Group.this.getContractId(), domain.getId());
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ContractSubPanel_Group.this.getContractId()));
                ContractSubPanel_Group.this.refreshDomain();
            }
        });
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)this.domainComboBox, "Center");
        panel.add((Component)domainUpdate, "East");
        return panel;
    }

    public void setData() {
        try {
            this.selectedIds = this.contractLabelService.getContractLabelIds(this.getContractId());
            this.avaliableItems = this.contractLabelService.getContractLabelTreeItemList(-1, false);
            if (this.avaliableItems.size() == 1) {
                this.contractLabelService.syncLabelAndGroupDirectory();
                this.avaliableItems = this.contractLabelService.getContractLabelTreeItemList(-1, false);
            }
            this.contractLabelTreeAvaliable.setData(this.avaliableItems);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.selectedItems.clear();
        this.selectedItems.addAll(this.avaliableItems.stream().filter(item -> this.selectedIds.contains(item.getId())).toList());
        HashSet parents = new HashSet();
        this.selectedItems.forEach(i -> this.contractLabelTreeAvaliable.addParents((ContractLabelItem)i, parents));
        this.selectedItems.addAll(this.avaliableItems.stream().filter(item -> parents.contains(item.getId()) && !this.selectedIds.contains(item.getId())).toList());
        this.contractLabelTreeSelected.setData(this.selectedItems);
        JScrollPane scrollPaneSelect = new JScrollPane(this.contractLabelTreeSelected);
        scrollPaneSelect.setVerticalScrollBarPolicy(22);
        this.selectedLabelsPanel.removeAll();
        this.selectedLabelsPanel.add(scrollPaneSelect);
        JScrollPane scrollPaneAvailable = new JScrollPane(this.contractLabelTreeAvaliable);
        scrollPaneAvailable.setVerticalScrollBarPolicy(22);
        this.availableLabelsPanel.removeAll();
        this.availableLabelsPanel.add(scrollPaneAvailable);
        this.refreshDomain();
    }

    private void refreshDomain() {
        Async domainList = Async.of(() -> {
            List list = this.getContext().getDirectory(Domain.class, 0).list();
            Set parentIds = list.stream().map(a -> a.getParentId()).collect(Collectors.toSet());
            ArrayList<Domain> list2 = new ArrayList<Domain>(list.size() + 1);
            Domain domain = new Domain();
            domain.setTitle("---");
            list2.add(domain);
            list.stream().filter(a -> !parentIds.contains(a.getId())).collect(Collectors.toCollection(() -> list2));
            return list2;
        });
        Async contract = Async.of(() -> ((ContractService)this.getContext().getPort(ContractService.class, 0)).contractGet(this.getContractId()));
        try {
            this.domainComboBox.setData((List)domainList.get());
            this.domainComboBox.setSelectedItem((Object)((Contract)((Object)contract.get())).getDomainId());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void newItem() {
        List<ContractLabelItem> selectedItems = this.contractLabelTreeAvaliable.getSelectedItems();
        if (Utils.notEmptyCollection(selectedItems)) {
            List<ContractLabelItem> selectedWithParents = this.contractLabelTreeAvaliable.getSelectedItems0(true);
            selectedWithParents.removeIf(i -> i.getContractLabelType().equals((Object)ContractLabelType.GROUP) || i.getContractLabelType().equals((Object)ContractLabelType.LABEL));
            selectedWithParents.removeIf(ContractLabelItem::isForbiddenEdit);
            this.selectedIds.addAll(selectedWithParents.stream().mapToInt(Id::getId).boxed().toList());
            try {
                this.contractLabelService.setContractLabelIds(this.getContractId(), this.selectedIds);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        this.setData();
        EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
    }

    public void deleteItem() {
        for (ContractLabelItem selectedItem : this.contractLabelTreeSelected.getSelectedItems()) {
            if (selectedItem.isForbiddenEdit()) continue;
            ContractLabelType type = selectedItem.getContractLabelType();
            if (type == ContractLabelType.LABEL || type == ContractLabelType.GROUP) {
                this.selectedItems.removeIf(child -> child.getParentId() == selectedItem.getId());
                this.selectedIds.removeIf(id -> id.intValue() == selectedItem.getId());
                continue;
            }
            if (type != ContractLabelType.LABEL_ITEM && type != ContractLabelType.GROUP_ITEM) continue;
            int parentId = selectedItem.getParentId();
            this.selectedItems.removeIf(item -> item.getId() == selectedItem.getId());
            long countChildren = this.selectedItems.stream().filter(item -> item.getParentId() == parentId).count();
            if (countChildren == 0L) {
                this.selectedIds.removeIf(id -> id == parentId);
            }
            this.selectedIds.removeIf(id -> id.intValue() == selectedItem.getId());
        }
        try {
            this.contractLabelService.setContractLabelIds(this.getContractId(), this.selectedIds);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.setData();
        EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
    }
}

