/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.kernel.contract.object.client.ContractObjectEditor;
import ru.bitel.bgbilling.kernel.contract.object.client.ObjectModuleEditor;
import ru.bitel.bgbilling.kernel.contract.object.client.ObjectParamEditor;
import ru.bitel.bgbilling.kernel.contract.object.client.ObjectStatusEditor;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.Utils;

public class ObjectEditor
extends BGPanel {
    private JTabbedPane tabPanel = new JTabbedPane();
    private ObjectParamEditor paramEditor = new ObjectParamEditor();
    private ObjectStatusEditor statusEditor = new ObjectStatusEditor();
    private ObjectModuleEditor moduleEditor = new ObjectModuleEditor();

    public ObjectEditor() {
        this.jbInit();
    }

    private void jbInit() {
        this.statusEditor.addPropertyChangeListener(e -> {
            if ("statusUpdate".equals(e.getPropertyName())) {
                this.firePropertyChange("statusUpdate", e.getOldValue(), e.getNewValue());
            }
        });
        this.tabPanel.add((Component)((Object)this.paramEditor), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        this.tabPanel.add((Component)((Object)this.statusEditor), "\u0421\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        this.tabPanel.add((Component)((Object)this.moduleEditor), "\u041c\u043e\u0434\u0443\u043b\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        this.tabPanel.addChangeListener(e -> this.setData());
        this.setLayout(new GridBagLayout());
        this.add(this.tabPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData() {
        Component component = this.tabPanel.getSelectedComponent();
        if (component instanceof BGPanel) {
            BGPanel panel = (BGPanel)component;
            panel.trySetData();
        } else if (component instanceof BGUPanel) {
            BGUPanel panel = (BGUPanel)component;
            panel.performAction("refresh");
        }
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.paramEditor.init(module, moduleId);
        this.moduleEditor.init(module, moduleId);
    }

    public void setStatusList(List<Status> statusList) {
        this.statusEditor.setStatusList(statusList);
    }

    public void setContractId(int id) {
        super.setContractId(id);
        this.paramEditor.setContractId(id);
        this.moduleEditor.setContractId(id);
    }

    public void setId(String id) {
        super.setId(id);
        this.paramEditor.setId(id);
        this.statusEditor.setObjectId(id == null ? -1 : Utils.parseInt((String)id));
        this.moduleEditor.setId(id);
    }

    public void setContractObjectEditor(ContractObjectEditor contractObjectEditor) {
        this.paramEditor.setContractObjectEditor(contractObjectEditor);
    }
}

